package com.xxfc.platform.vehicle.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.xxfc.platform.vehicle.biz.SysRegionBiz;
import com.xxfc.platform.vehicle.common.BaseController;
import com.xxfc.platform.vehicle.common.CustomIllegalParamException;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.constant.ResCode.ResCode;
import com.xxfc.platform.vehicle.entity.SysRegion;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/sysRegion")
@IgnoreClientToken
@Slf4j
public class SysRegionController extends BaseController<SysRegionBiz> {


    @IgnoreUserToken
    @RequestMapping(value ="/sons/{id}",method = RequestMethod.GET)
    public RestResponse<List<SysRegion>> getSonRegion(@PathVariable Long id){
        return RestResponse.data(baseBiz.getSonRegion(id));
    }

    @RequestMapping(value ="",method = RequestMethod.GET)
    public RestResponse<List<SysRegion>> getRegion(@RequestParam String idListJson){
        try {
            List<Long> ids = JSON.parseArray(idListJson,Long.class);
            return RestResponse.data(baseBiz.getRegionsByCodes(ids));
        } catch (JSONException ex) {
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        } catch (CustomIllegalParamException ex){
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
    }

}
