package com.xxfc.platform.vehicle.biz;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.xxfc.platform.vehicle.entity.VehicleUpkeepItem;
import com.xxfc.platform.vehicle.mapper.VehicleUpkeepItemMapper;
import com.xxfc.platform.vehicle.mapper.VehicleUpkeepLogMapper;
import com.xxfc.platform.vehicle.pojo.VehicleUpkeepLogItemVo;
import com.xxfc.platform.vehicle.pojo.VehicleUpkeepLogVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class VehicleUpkeepService {

    @Autowired
    VehicleUpkeepItemMapper vehicleUpkeepItemMapper;

    @Autowired
    VehicleUpkeepLogMapper vehicleUpkeepLogMapper;

    public List<VehicleUpkeepItem> getAllItem() {
        return vehicleUpkeepItemMapper.selectAll();
    }

    public PageInfo<VehicleUpkeepItem> pageItem(Integer page, Integer limit) {
        PageHelper.startPage(page, limit);
        return new PageInfo<>(vehicleUpkeepItemMapper.selectAll());
    }

    public void addItem(String itemName) {
        VehicleUpkeepItem item = new VehicleUpkeepItem();
        item.setName(itemName);
        vehicleUpkeepItemMapper.insert(item);
    }

    public void updateItem(VehicleUpkeepItem item) {
        vehicleUpkeepItemMapper.updateByPrimaryKey(item);
    }

    public void deleteItem(Integer id) {
        vehicleUpkeepItemMapper.deleteByPrimaryKey(id);
    }

    public PageInfo<VehicleUpkeepLogVo> pageLog(String numberPlate, Integer page, Integer limit) {
        PageHelper.startPage(page, limit);
        return new PageInfo<>(vehicleUpkeepLogMapper.selectVoAll(numberPlate));
    }

    public VehicleUpkeepLogVo getLogVoById(Integer id) {
        VehicleUpkeepLogVo vehicleUpkeepLogVo = vehicleUpkeepLogMapper.selectVoById(id);
        List<VehicleUpkeepLogItemVo> upkeepItems = vehicleUpkeepLogMapper.getItemsByLogId(id);
        vehicleUpkeepLogVo.setUpkeepItems(upkeepItems);
        return vehicleUpkeepLogVo;
    }

    public void deleteLog(Integer id) {
        vehicleUpkeepLogMapper.deleteByPrimaryKey(id);
        vehicleUpkeepLogMapper.deleteItemsByLogId(id);
    }
}
