package com.xxfc.platform.vehicle.pojo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Map;

@Data
public class BookVehicleVO {
    /**
     * 车辆id
     */
    @ApiModelProperty("车辆id")
    private String vehicle;

    /**
     * 预定目标日期(开始)
     */
    @ApiModelProperty("预定目标日期(开始)")
    private String bookStartDate;

    /**
     * 预定目标日期(结束)
     */
    @ApiModelProperty("预定目标日期(结束)")
    private String bookEndDate;

    /**
     * 取消预定目标日期(开始)
     */
    @ApiModelProperty("取消预定目标日期(开始)")
    private String unbookStartDate;

    /**
     * 取消预定目标日期(结束)
     */
    @ApiModelProperty("取消预定目标日期(结束)")
    private String unbookEndDate;

    /**
     * 提车地点
     */
    @ApiModelProperty("提车地点")
    private String liftAddr;

    /**
     * 提车公司
     */
    @ApiModelProperty("提车公司")
    private Integer liftCompany;

    /**
     * 目的地
     */
    @ApiModelProperty("目的地")
    private String destination;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 随车物品id以及数量 List<Map<id,数量>>
     */
    @ApiModelProperty("随车物品id以及数量 List<Map<id,数量>>")
   Map<Integer,Integer> selectedAccItem;

    /**
     * 提车阶段里程数
     */
    @ApiModelProperty("提车阶段里程数")
    private Integer mileageLift;

    /**
     * 还车阶段里程数
     */
    @ApiModelProperty("还车阶段里程数")
    private Integer mileageRet;

    /**
     * 是否违章
     */
    @ApiModelProperty("是否违章")
    private Integer haveViolation;


}