package com.xxfc.platform.universal.controller;

import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.util.result.JsonResultUtil;
import com.xxfc.platform.universal.biz.OrderRefundBiz;
import com.xxfc.platform.universal.entity.OrderRefund;
import com.xxfc.platform.universal.vo.OrderRefundVo;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("refund")
public class OrderRefundController extends BaseController<OrderRefundBiz,OrderRefund> {



    @RequestMapping(value = "/app/wx", method = RequestMethod.POST) //匹配的是href中的download请求
    public JSONObject refund(@RequestBody OrderRefundVo orderRefundVo) {
        try {
            return baseBiz.refund(orderRefundVo);
        }catch (Exception e){
            e.getMessage();
            return JsonResultUtil.createFailedResult(ResultCode.EXCEPTION_CODE, "出现异常");
        }
    }

}