package com.xxfc.platform.tour.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 旅游商品表
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 11:41:51
 */
@Data
@Table(name = "tour_good")
public class TourGood implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    //
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("")
    private Integer id;
	
	    //商品名
    @Column(name = "name")
	@ApiModelProperty(value = "商品名")
    private String name;
	
	    //商品封面图
    @Column(name = "cover")
	@ApiModelProperty(value = "商品封面图")
    private String cover;
	
	    //商品原价
    @Column(name = "price")
	@ApiModelProperty(value = "商品原价")
    private BigDecimal price;
	
	    //儿童价格
    @Column(name = "child_price")
	@ApiModelProperty(value = "儿童价格")
    private BigDecimal childPrice;
	
	    //商品浏览量
    @Column(name = "view_count")
	@ApiModelProperty(value = "商品浏览量")
    private Integer viewCount;
	
	    //商品销售量
    @Column(name = "sale_count")
	@ApiModelProperty(value = "商品销售量")
    private Integer saleCount;

	//天数
	@Column(name = "number")
	@ApiModelProperty(value = "天数")
	private Integer number;
	
	//商品描述
    @Column(name = "describes")
	@ApiModelProperty(value = "商品描述")
    private String describe;
	
	    //商品详情(行程亮点)
    @Column(name = "content")
	@ApiModelProperty(value = "商品详情(行程亮点)")
    private String content;
	
	    //行程介绍
    @Column(name = "introduce")
	@ApiModelProperty(value = "行程介绍")
    private String introduce;

	//费用说明
	@Column(name = "explains")
	@ApiModelProperty(value = "费用说明")
	private String explain;
	
	    //排序
    @Column(name = "rank")
	@ApiModelProperty(value = "排序")
    private Integer rank;
	
	    //状态:0-未发布;1-上架；2-下架
    @Column(name = "status")
	@ApiModelProperty(value = "状态:0-未发布;1-上架；2-下架")
    private Integer status;
	
	    //创建时间
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    //更新时间
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    //是否推荐:0-未推荐；1-已推荐
    @Column(name = "recommend")
	@ApiModelProperty(value = "是否推荐:0-未推荐；1-已推荐")
    private Integer recommend;
	
	    //是否会员价:0-否；1-是
    @Column(name = "is_member")
	@ApiModelProperty(value = "是否会员价:0-否；1-是")
    private Integer isMember;
	
	    //库存
    @Column(name = "stock")
	@ApiModelProperty(value = "库存")
    private Integer stock;
	
	    //单位
    @Column(name = "unit")
	@ApiModelProperty(value = "单位")
    private String unit;

	//是否删除，0否，1是
	@Column(name = "is_del")
	@ApiModelProperty(value = "是否删除，0否，1是")
	private Integer isDel;
	

}
