package com.xinxincaravan.caravan.vehicle.vo;

import lombok.Data;

import java.util.Date;

@Data
public class VehiclePageQueryVo {

    /**
     * 车辆编号，0-没有
     */
    private Integer code;

    /**
     * 车辆状态： 1-正常运行 2-维修 3-报废
     */
    private Integer status;

    /**
     * 车牌号，空字符串-没有
     */
    private String numberPlate;

    /**
     * 品牌（编码，对应关系见相关常量），0-未填写
     */
    private Integer brand;

    /**
     * 所属分支机构（id）
     */
    private Integer subordinateBranch;

    /**
     * 用途类型：租赁房车（1）、展车等，对应关系见车辆常量表
     */
    private Integer useType;
    /**
     * 预定目标日期(开始)
     */
    private String bookedStartDate;
    /**
     * 预定目标日期(结束)
     */
    private String bookedEndDate;

    /**
     * 未预定目标日期(开始)
     */
    private String notBookedStartDate;
    /**
     * 未预定目标日期(结束)
     */
    private String notBookedEndDate;

    private Integer page;

    private Integer limit;

    /**
     * 车架号
     */
    private String vin;

    /**
     * 里程数
     */
    private Integer mileageRangeStart;

    /**
     * 里程数
     */
    private Integer mileageRangeEnd;


    /**
     * 保险公司，见常量表
     */
    private Integer insuranceCompany;


    /**
     * 保险结束时间查询范围 - 开始
     */
    private Date insuranceDateRangeStart;

    /**
     * 保险结束时间查询范围 - 结束
     */
    private Date insuranceDateRangeEnd;

    /**
     * 年审日期查询范围 - 开始
     */
    private Date aVRangeDateStart;

    /**
     * 年审日期查询范围 - 结束
     */
    private Date aVRangeDateEnd;

    /**
     * 保养日期查询范围 - 开始
     */
   private Date mRangeDateStart;

    /**
     * 保养日期查询范围 - 结束
     */
    private Date mRangeDateEnd;

    /**
     * 是否违章
     */
    private Integer haveViolation;

    public Integer getMileageRangeStart() {
        return mileageRangeStart;
    }

    public void setMileageRangeStart(Integer mileageRangeStart) {
        this.mileageRangeStart = mileageRangeStart;
    }

    public Integer getMileageRangeEnd() {
        return mileageRangeEnd;
    }

    public void setMileageRangeEnd(Integer mileageRangeEnd) {
        this.mileageRangeEnd = mileageRangeEnd;
    }

    public Integer getInsuranceCompany() {
        return insuranceCompany;
    }

    public void setInsuranceCompany(Integer insuranceCompany) {
        this.insuranceCompany = insuranceCompany;
    }

    public Date getInsuranceDateRangeStart() {
        return insuranceDateRangeStart;
    }

    public void setInsuranceDateRangeStart(Date insuranceDateRangeStart) {
        this.insuranceDateRangeStart = insuranceDateRangeStart;
    }

    public Date getInsuranceDateRangeEnd() {
        return insuranceDateRangeEnd;
    }

    public void setInsuranceDateRangeEnd(Date insuranceDateRangeEnd) {
        this.insuranceDateRangeEnd = insuranceDateRangeEnd;
    }

    public Date getaVRangeDateStart() {
        return aVRangeDateStart;
    }

    public void setaVRangeDateStart(Date aVRangeDateStart) {
        this.aVRangeDateStart = aVRangeDateStart;
    }

    public Date getaVRangeDateEnd() {
        return aVRangeDateEnd;
    }

    public void setaVRangeDateEnd(Date aVRangeDateEnd) {
        this.aVRangeDateEnd = aVRangeDateEnd;
    }

    public Date getmRangeDateStart() {
        return mRangeDateStart;
    }

    public void setmRangeDateStart(Date mRangeDateStart) {
        this.mRangeDateStart = mRangeDateStart;
    }

    public Date getmRangeDateEnd() {
        return mRangeDateEnd;
    }

    public void setmRangeDateEnd(Date mRangeDateEnd) {
        this.mRangeDateEnd = mRangeDateEnd;
    }
}
