package com.xinxincaravan.caravan.vehicle.constant;

import com.google.common.collect.Maps;

import java.util.Map;

public enum VehicleBelong2Type {
    OWN(1,"欣新房车有限公司"),//自有
    TRUST(2,"托管"),
    RENTAL(3,"租赁"),

    ;

    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    private static Map<Integer,String> codeAndDesc = Maps.newHashMap();

    static{
        for(VehicleBelong2Type constantType : VehicleBelong2Type.values()){
            codeAndDesc.put(constantType.getCode(),constantType.getDesc());
        }
    }

    VehicleBelong2Type(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }

}
