package com.xxfc.platform.uccn.biz;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.uccn.dto.SummitActivityFindDTO;
import com.xxfc.platform.uccn.dto.SummitActivitySaveDTO;
import com.xxfc.platform.uccn.vo.SummitActivityAdminVo;
import com.xxfc.platform.uccn.vo.SummitActivityDetailVo;
import com.xxfc.platform.uccn.vo.SummitActivityVo;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import com.xxfc.platform.uccn.entity.SummitActivity;
import com.xxfc.platform.uccn.mapper.SummitActivityMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import tk.mybatis.mapper.entity.Example;

import java.time.Instant;
import java.util.Collections;
import java.util.List;

/**
 * 峰会活动
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-08-26 15:25:32
 */
@Service
public class SummitActivityBiz extends BaseBiz<SummitActivityMapper, SummitActivity> {


    public List<SummitActivityVo> findSummitActivityForHomePage(Integer limit) {
        Example example = new Example(SummitActivity.class);
        example.setOrderByClause("rank");
        Example.Criteria criteria = example.createCriteria();
        //未删除
        criteria.andEqualTo("isDel",0);
        //是首页展示
        criteria.andEqualTo("isHomePage",1);
        //已发布
        criteria.andEqualTo("isPublish",1);
        //活动未下架
        criteria.andEqualTo("isShow",0);
        //结束时间大于当前时间
        //criteria.andGreaterThanOrEqualTo("endTime", Instant.now().toEpochMilli());
        PageDataVO<SummitActivity> dataVO = PageDataVO.pageInfo(1, limit, () -> mapper.selectByExample(example));
        List<SummitActivity> summitActivities = dataVO.getData();
        if (CollectionUtils.isEmpty(summitActivities)){
            return Collections.EMPTY_LIST;
        }
        return JSON.parseObject(JSON.toJSONString(summitActivities),new TypeReference<List<SummitActivityVo>>(){});
    }

    public SummitActivityDetailVo findSummitActivityDetailById(Integer id) {
        SummitActivityDetailVo summitActivityDetailVo = new SummitActivityDetailVo();
        SummitActivity summitActivity = mapper.selectByPrimaryKey(id);
        BeanUtils.copyProperties(summitActivity, summitActivityDetailVo);
        return summitActivityDetailVo;
    }

    public PageDataVO<SummitActivityAdminVo> listSummitActivityWithPage(SummitActivityFindDTO summitActivityFindDTO) {
        return null;
    }

    public void saveSummitActivity(SummitActivitySaveDTO summitActivitySaveDTO, UserDTO userDTO) {
    }

    public void publishSummitActivityById(Integer id, Integer state) {
        SummitActivity summitActivity = new SummitActivity();
        summitActivity.setIsPublish(state);
        summitActivity.setId(id);
        mapper.updateByPrimaryKeySelective(summitActivity);
    }

    public void soldOutSummitAcitivityById(Integer id, Integer state) {
        SummitActivity summitActivity = new SummitActivity();
        summitActivity.setIsShow(state);
        summitActivity.setId(id);
        mapper.updateByPrimaryKeySelective(summitActivity);
    }

    public void setShowOnHomePageById(Integer id, Integer state) {
        SummitActivity summitActivity = new SummitActivity();
        summitActivity.setIsHomePage(state);
        summitActivity.setId(id);
        mapper.updateByPrimaryKeySelective(summitActivity);
    }

    public void setRegSateWithSummitActivityById(Integer id, Integer state) {
        SummitActivity summitActivity = new SummitActivity();
        summitActivity.setIsOpenReg(state);
        summitActivity.setId(id);
        mapper.updateByPrimaryKeySelective(summitActivity);
    }

    public void deleteSummitActivityById(Integer id) {
        SummitActivity summitActivity = new SummitActivity();
        summitActivity.setIsDel(1);
        summitActivity.setId(id);
        mapper.updateByPrimaryKeySelective(summitActivity);
    }
}