package com.xxfc.platform.universal.controller;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.universal.constant.CaptchaType;
import com.xxfc.platform.universal.dto.CaptchaBaseParam;
import com.xxfc.platform.universal.service.AbstractCaptcha;
import com.xxfc.platform.universal.service.CaptchaFactory;
import com.xxfc.platform.universal.service.ICaptchaFactory;
import com.xxfc.platform.universal.utils.ImageUtils;
import com.xxfc.platform.universal.vo.CaptchaBaseVO;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @author stx
 * @date 2018/11/5 14:58
 * @desc
 */
@Controller
@RequestMapping(value = "/captcha")
public class CaptchaController {

    @RequestMapping("/app/unauth/blockPuzzle")
    @ResponseBody
    ObjectRestResponse blockPuzzle() {

        ICaptchaFactory captchaFactory = new CaptchaFactory();
        AbstractCaptcha captcha = captchaFactory.getInstance(CaptchaType.BLOCK_PUZZLE);
        CaptchaBaseParam captchaBaseParam = new CaptchaBaseParam();
        captchaBaseParam.setUrlOrPath(ImageUtils.getBlockPuzzleBgPath());
        captcha.setJigsawUrlOrPath(ImageUtils.getBlockPuzzleJigsawPath());
        CaptchaBaseVO dataVO = captcha.create(captchaBaseParam);
        return ObjectRestResponse.succ(dataVO);
    }

    @RequestMapping("/app/unauth/clickWord")
    @ResponseBody
    ObjectRestResponse clickWord() {

        ICaptchaFactory captchaFactory = new CaptchaFactory();
        AbstractCaptcha captcha = captchaFactory.getInstance(CaptchaType.CLICK_WORD);

        CaptchaBaseParam captchaBaseParam = new CaptchaBaseParam();
        captchaBaseParam.setUrlOrPath(ImageUtils.getClickWordBgPath());
        captcha.setFontColorRandom(false);
        CaptchaBaseVO dataVO = captcha.create(captchaBaseParam);
        return ObjectRestResponse.succ(dataVO);
    }


}
