package com.xxfc.platform.universal.entity;



import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * 证件信息表
 */
@Table(name = "id_information")
@Data
public class IdInformation implements Serializable {




    @Id
    @GeneratedValue(generator = "JDBC")
    private Integer id;


    /**
     *   证件号
     */
    @Column(name ="id_number")
    private String  idNumber;


    /**
     * 用户真实姓名
     */
    private String name;

    /**
     *
     */
    /**
     * 用户id
     */
    @Column(name = "user_login_id")
    private Integer  userLoginId;

    /**
     *
     */
    /**
     * 证件类型
     */
    @Column(name = "certificate_type")
    private Integer  certificateType;

    /**
     * 正面url
     */
    @Column(name = "front_url")
    private String  frontUrl;


    /**
     * 背面url
     */
    @Column(name = "back_url")
    private String  backUrl;

    /**
     *到期时间
     */
    @Column(name = "expiration_date")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyyMMdd",timezone="GMT+8")
    private Date expirationDate;

    /**
     * 认证方式
     */
    @Column(name = "authentication_methods")
    private Integer authenticationMethods;

    /**
     *创建时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH;mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH;mm:ss",timezone = "GMT+8")
    @Column(name = "crt_time")
    private Date crtTime;

    /**
     * 修改时间
     */

    @DateTimeFormat(pattern = "yyyy-MM-dd HH;mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH;mm:ss",timezone = "GMT+8")
    @Column(name = "upd_time")
    private Date updTime;


}
