package com.xxfc.platform.order.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 租车订单统计
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-11-08 18:03:42
 */
@Data
@Table(name = "order_rent_vehicle_received_statistics")
public class OrderRentVehicleReceivedStatistics extends OrderReceivedStatisticsBase implements Serializable {
    private static final long serialVersionUID = 1L;

    @Column(name = "deposit_amount")
    @ApiModelProperty("押金")
    private BigDecimal depositAmount;

    @Column(name = "deposit_refund_amount")
    @ApiModelProperty("押金退款")
    private BigDecimal depositRefundAmount;

    @Column(name = "break_rules_regulation_amount")
    @ApiModelProperty("违章金")
    private BigDecimal breakRulesRegulationAmount;

    @Column(name = "loss_specified_amount")
    @ApiModelProperty("定损金")
    private BigDecimal lossSpecifiedAmount;

    @Column(name = "no_deductible_amount")
    @ApiModelProperty("不计免赔费用")
    private BigDecimal noDeductibleAmount;

    @Column(name = "no_deductible_refund_amount")
    @ApiModelProperty("不计免赔费用")
    private BigDecimal noDeductibleRefundAmount;

}
