package com.xxfc.platform.order.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 *  全部订单统计
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-11-08 18:03:42
 */
@Data
@Table(name = "order_received_statistics")
@ApiModel("订单统计")
public class OrderReceivedStatistics extends OrderReceivedStatisticsBase implements Serializable {
	private static final long serialVersionUID = 1L;

	@Column(name = "member_amount")
	@ApiModelProperty("会员费")
	private BigDecimal memberAmount;

	@Column(name = "member_refund_amount")
	@ApiModelProperty("会员退款费")
	private BigDecimal memberRefundAmout;

	@Column(name = "member_quantity")
	@ApiModelProperty("会员订单量")
	private Integer memberQuantity;

	@Column(name = "travel_amount")
	@ApiModelProperty("旅游费")
	private BigDecimal travelAmount;

	@Column(name = "travel_refund_amount")
	@ApiModelProperty("旅游退款费")
	private BigDecimal travelRefundAmount;

	@Column(name = "travel_quantity")
	@ApiModelProperty("旅游订单量")
	private Integer travelQuantity;

	@Column(name = "rent_vehicle_amount")
	@ApiModelProperty("租车费")
	private BigDecimal rentVehicleAmount;

	@Column(name = "rent_vehicle_refund_amount")
	@ApiModelProperty("租车退款费")
	private BigDecimal rentVehicleRefundAmount;

	@Column(name = "rent_vehicle_quantity")
	@ApiModelProperty("租车订单量")
	private Integer rentVehicleQuantity;

	@Column(name = "no_deductible_amount")
	@ApiModelProperty("不计免赔费")
	private BigDecimal noDeductibleAmount;

	@Column(name = "no_deductible_refund_amount")
	@ApiModelProperty("不计免赔退款费用")
	private BigDecimal noDeductibleRefundAmount;

	@Column(name = "deposit_amount")
	@ApiModelProperty("押金")
	private BigDecimal depositAmount;

	@Column(name = "deposit_refund_amount")
	@ApiModelProperty("押金退款")
	private BigDecimal depositRefundAmount;

	@Column(name = "break_rules_regulation_amount")
	@ApiModelProperty("违章金")
	private BigDecimal breakRulesRegulationAmount;

	@Column(name = "loss_specified_amount")
	@ApiModelProperty("定损金")
	private BigDecimal lossSpecifiedAmount;


}
