package com.xxfc.platform.activity.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.activity.biz.ActivityWinningRecordBiz;
import com.xxfc.platform.activity.vo.ActivityWinningRecordVo;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/3 19:44
 */
@RestController
@RequestMapping("activityWinningRecord")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class ActivityWinningRecordController {


     private final ActivityWinningRecordBiz activityWinningRecordBiz;

     @GetMapping("/{id}")
     public ObjectRestResponse<ActivityWinningRecordVo> findActivityAttendanceRecordById(@PathVariable(value = "id") Long id){
          ActivityWinningRecordVo activityWinningRecordVo = activityWinningRecordBiz.findActivityAttendanceRecordById(id);
          return ObjectRestResponse.succ(activityWinningRecordVo);
     }

}