package com.xxfc.platform.activity.handler;


import com.alibaba.fastjson.JSONObject;
import com.rabbitmq.client.Channel;
import com.xxfc.platform.activity.biz.IntegralUserRecordBiz;
import com.xxfc.platform.activity.config.RabbitActivityConfig;
import com.xxfc.platform.activity.vo.IntegralUserRecordDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.support.AmqpHeaders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Component
@Slf4j
public class IntegralMQHandler {

    @Autowired
    IntegralUserRecordBiz integralUserRecordBiz;

    @RabbitListener(queues = {RabbitActivityConfig.INTEGRAL_HANDLE_QUEUE})
    public void integralHandler(Message message, @Headers Map<String, Object> headers, Channel channel) {
        ExecutorService executorService = Executors.newCachedThreadPool();
        executorService.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    String messageId = message.getMessageProperties().getMessageId();
                    String msg = new String(message.getBody(), "UTF-8");
                    log.info("接收到的消息：msg = {}, 消息ID是：messageId = {} ", msg, messageId);

                    if (StringUtils.isNotBlank(msg)) {
                        IntegralUserRecordDto integralUserRecordDto = JSONObject.parseObject(msg, IntegralUserRecordDto.class);
                        integralUserRecordBiz.add(integralUserRecordDto);
                    }

                    executorService.shutdown();
                    Long deliveryTag = (Long) headers.get(AmqpHeaders.DELIVERY_TAG);
                    // 手动签收
                    channel.basicAck(deliveryTag, false);
                } catch (Exception e) {
                    log.info("接收到的消息失败");
                    try {
                        channel.basicNack(message.getMessageProperties().getDeliveryTag(), false, false);
                    } catch (IOException i) {
                        log.error(e.getMessage(), i);
                    }
                    log.error(e.getMessage(), e);
                }
            }
        });
    }


}
