package com.xxfc.platform.activity.bo;

import com.xxfc.platform.activity.vo.ActivityWinningRecordVo;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/4 8:40
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ActivityWinningRecordBo implements Serializable {

    private Integer totalPage;
    private Long totalCount;
    private Integer pageNum;
    private Integer pageSize;
    private List<ActivityWinningRecordVo> activityWinningRecords;
    private ActivityWinningRecordTotalVo activityWinningRecordTotalVo;

    public Integer getTotalPage() {
        return totalPage==null?0:totalPage;
    }

    public Long getTotalCount() {
        return totalCount==null?0:totalCount;
    }

    public Integer getPageNum() {
        return pageNum==null?0:pageNum;
    }

    public Integer getPageSize() {
        return pageSize==null?0:pageSize;
    }

    public List<ActivityWinningRecordVo> getActivityWinningRecords() {
        return CollectionUtils.isEmpty(activityWinningRecords)? Collections.EMPTY_LIST:activityWinningRecords;
    }

    public ActivityWinningRecordTotalVo getActivityWinningRecordTotalVo() {
        return activityWinningRecordTotalVo==null?new ActivityWinningRecordTotalVo():activityWinningRecordTotalVo;
    }
}
