package com.github.wxiaoqi.security.admin.biz;

import cn.hutool.core.collection.CollectionUtil;
import com.github.wxiaoqi.security.admin.entity.AppStaffUser;
import com.github.wxiaoqi.security.admin.entity.AppStaffUserDTO;
import com.github.wxiaoqi.security.admin.entity.AppStaffUserVo;
import com.github.wxiaoqi.security.admin.entity.ModifiedUsers;
import com.github.wxiaoqi.security.admin.mapper.AppStaffUserMapper;
import com.github.wxiaoqi.security.admin.vo.AppUserVo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.im.utils.StringUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import java.util.Date;
import java.util.List;

/**
 * @author Administrator
 */
@Service
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
@Slf4j
public class AppStaffUserBiz extends BaseBiz<AppStaffUserMapper, AppStaffUser> {
    private final AppUserDetailBiz appUserDetailBiz;
    private final Integer POSITION_ID=4;


    public List<AppStaffUser> getAll(Integer id, String username) {
        return mapper.selectByBysuIdOrUsername(id,username);
    }

    @Override
    public int insertSelectiveRe(AppStaffUser appStaffUser) {
        appStaffUser.setCrtTime(new Date());
        return mapper.insertSelective(appStaffUser);
    }


    @Override
    public int updateSelectiveByIdRe(AppStaffUser appStaffUser) {
        appStaffUser.setUpdTime(new Date());
        return mapper.updateByPrimaryKeySelective(appStaffUser);
    }

    public AppStaffUser findOne(AppStaffUser appStaffUser) {
        Example example = new Example(AppStaffUser.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isDel", 0);
        if (appStaffUser.getId() != null) {
            criteria.andEqualTo("id", appStaffUser.getId());
        }
        if (appStaffUser.getPhone() != null) {
            criteria.andEqualTo("phone", appStaffUser.getPhone());
        }

        List<AppStaffUser> appStaffUsers = mapper.selectByExample(example);

        if (CollectionUtil.isNotEmpty(appStaffUsers)) {
            AppStaffUser staffUser = appStaffUsers.get(0);
            AppStaffUserVo appStaffUserVo = new AppStaffUserVo();
            BeanUtils.copyProperties(staffUser, appStaffUserVo);
            Integer suId = staffUser.getSuId();
            //上级员工信息
            if (suId != null && suId != 0 && appStaffUser.getPhone() != null){
                AppUserVo spuser = appUserDetailBiz.getUserInfoById(suId);
                appStaffUserVo.setEmployeeName(spuser.getRealname());
                appStaffUserVo.setEmployeePhone(spuser.getUsername());
            }
            //客户信息
            Integer uid = staffUser.getUid();
            if (uid != null && uid > 0){
                AppUserVo user = appUserDetailBiz.getUserInfoById(uid);
                appStaffUserVo.setUName(StringUtil.isEmpty(user.getRealname())?user.getNickname():user.getRealname());
                appStaffUserVo.setPhone(user.getUsername());
            }

            return appStaffUserVo;
        }
        return null;
    }

    public boolean select(AppStaffUser appStaffUser) {
        Example example = new Example(AppStaffUser.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("phone", appStaffUser.getPhone())
                .andEqualTo("isDel", 0);
        List<AppStaffUser> appStaffUsers = mapper.selectByExample(example);
        return CollectionUtil.isEmpty(appStaffUsers) ? true : false;
    }

    public void update(AppStaffUser staffUser, Integer userid) {
        Example example = new Example(AppStaffUser.class);
        example.createCriteria().andEqualTo("id", staffUser.getId()).andEqualTo("suId", userid);
        mapper.updateByExampleSelective(staffUser, example);
    }

    public void updateByPhone(AppStaffUser staffUser) {
        Example example = new Example(AppStaffUser.class);
        example.createCriteria().andEqualTo("phone",staffUser.getPhone());
        mapper.updateByExampleSelective(staffUser, example);
    }

    /**
     * 添加用户关系
     * @param staffUserDTO
     */
    public void addAppStaffUser(AppStaffUserDTO staffUserDTO){
        log.info("staffUserDTO={}",staffUserDTO);
        AppUserVo superAppUserVo= appUserDetailBiz.getUserInfoById(staffUserDTO.getSuId());
        AppUserVo userInfoById = appUserDetailBiz.getUser(staffUserDTO.getUid());
        log.info("userInfoById={}",userInfoById);
        AppStaffUser appStaffUser = new  AppStaffUser();

        appStaffUser.setSuId(superAppUserVo.getUserid());
        appStaffUser.setSuPhone(superAppUserVo.getUsername());
        appStaffUser.setUid(staffUserDTO.getUid());
        appStaffUser.setUName(StringUtil.isEmpty(userInfoById.getRealname()) ? userInfoById.getNickname() : userInfoById.getRealname());
        appStaffUser.setPhone(userInfoById.getUsername());
        appStaffUser.setStatus(1);

        if (select(appStaffUser)) {
            insertSelective(appStaffUser);
        }else {
            updateByPhone(appStaffUser);
        }
    }

    /**
     * 修改客户关系,根据修改后的用户信息
     * @param modifiedUsers
     */
    public void updateByModifiedUsers(ModifiedUsers modifiedUsers){
        if (POSITION_ID.equals(modifiedUsers.getPositionId())) {
            mapper.updateByPositionId(modifiedUsers);
        }else {
            mapper.update(modifiedUsers);
        }
    }


    public void insertBatch(List<AppStaffUser> appStaffUsers){
        mapper.insertList(appStaffUsers);
    }

    public void saveStaffUser(AppStaffUser appStaffUser) {
        mapper.saveStaffUser(appStaffUser);
    }
}
