package com.github.wxiaoqi.security.admin.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;

/**
 * 员工变更记录表
 */
@Table(name = "app_user_position_change_record")
@Data
public class AppUserPositionChangeRecord implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator = "JDBC")//此处加上注解
    @ApiModelProperty("主键id")
    private Integer id;

    @ApiModelProperty("用户id")
    @Column(name = "phone")
    private String phone;

    @ApiModelProperty("用户名称")
    @Column(name = "user_name")
    private String userName;

    @ApiModelProperty("变更后所在公司ID")
    @Column(name = "new_company_id")
    private Integer newCompanyId;

    @ApiModelProperty("变更前所在公司ID")
    @Column(name = "old_company_id")
    private Integer oldCompanyId;

    @ApiModelProperty("变更后所在公司名称")
    @Column(name = "new_company_name")
    private String newCompanyName;

    @ApiModelProperty("变更前所在公司名称")
    @Column(name = "old_company_name")
    private String oldCompanyName;

    @ApiModelProperty("旧职位ID")
    @Column(name = "old_job_id")
    private Integer oldJobId;

    @ApiModelProperty("新职位ID")
    @Column(name = "new_job_id")
    private Integer newJobId;

    @ApiModelProperty("操作人名称")
    @Column(name = "operator_id")
    private Integer operatorId;

    @ApiModelProperty("操作时间")
    @Column(name = "crt_time")
    private Timestamp crtTime;

    @ApiModelProperty("员工职位、所属公司、离职、入职等的实际上任时间")
    @Column(name = "rel_time")
    private Timestamp relTime;

    @ApiModelProperty("新身份ID")
    @Column(name = "new_position_id")
    private Integer newPositionId;

    @ApiModelProperty("旧身份ID")
    @Column(name = "old_position_id")
    private Integer oldPositionId;

    @ApiModelProperty("1:入职；2：职位变更；3：身份变更 4：公司所属变更；5离职")
    @Column(name = "job_remark")
    private Integer jobRemark;

    @ApiModelProperty("新身份名称")
    @Column(name = "new_position_name")
    private String newPositionName;

    @ApiModelProperty("旧身份名称")
    @Column(name = "old_position_name")
    private String oldPositionName;

    @ApiModelProperty("新职位名称")
    @Column(name = "new_job_name")
    private String newJobName;

    @ApiModelProperty("旧职位名称")
    @Column(name = "old_job_name")
    private String oldJobName;



}
