package com.github.wxiaoqi.security.admin.constant.enumerate;

import java.util.HashMap;
import java.util.Map;

public enum MemberEnum {
    NONE(0, "非会员", 100),
    NORMAL(1, "普通会员", 80),
    GOLD(2, "黄金会员", 70),
    DIAMOND(3, "钻石会员", 60),
    ;
    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    /**
     * 优惠比例
     */
    private Integer percent;

    private static Map<Integer,String> codeAndDesc = new HashMap<Integer, String>();

    MemberEnum(Integer code, String desc, Integer percent){
        this.code=code;
        this.desc=desc;
        this.percent=percent;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getPercent() {
        return percent;
    }

    public void setPercent(Integer percent) {
        this.percent = percent;
    }

    public static MemberEnum getByCode(Integer code) {
        if(code == null) return null;
        for(MemberEnum enumE : values()) {
            if(enumE.getCode().equals(code)) {
                return enumE;
            }
        }
        return null;
    }
}