package com.github.wxiaoqi.security.common.util.excel;

import org.apache.poi.ss.usermodel.*;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/4 18:37
 */
public class ExcelUtils {
    private XSSFWorkbook hssfWorkbook;
    private XSSFSheet sheet;

    public ExcelUtils(String sheetName){
         hssfWorkbook = new XSSFWorkbook();
         sheet = hssfWorkbook.createSheet(sheetName);
    }

    public  void createCellData(Sheet sheet, int startRowIndex, CellStyle cellStyle, List<String[]> datas) {
        for (String[] data : datas) {
            Row row = sheet.createRow(startRowIndex++);
            createCellCount(row, 0, data, cellStyle);
        }
    }

    private   void createCellCount(Row row, int CellStartIndex, String[] data, CellStyle cellStyle) {
        for (int i = CellStartIndex, y = 0; y < data.length; i++, y++) {
            Cell cell = row.createCell(i);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(data[y]);

        }
    }

    public  void createHeader(Row row, int cellStartIndex, String[] header, CellStyle cellStyle) {
        for (int i = 0; i < header.length; i++) {
            Cell cell = row.createCell(cellStartIndex);
            cell.setCellValue(header[i]);
            cell.setCellStyle(cellStyle);
            cellStartIndex += 1;
        }
    }

    public  CellStyle createGeneralCellStyle() {
        CellStyle cellStyleGeneral = createHeaderCellStyle();
        cellStyleGeneral.setWrapText(true);
        XSSFFont generalFont = createFont();
        generalFont.setBold(false);
        cellStyleGeneral.setFont(generalFont);
        return cellStyleGeneral;
    }

    public  CellStyle createHeaderCellStyle() {
        XSSFCellStyle cellStyleHeader = hssfWorkbook.createCellStyle();
        cellStyleHeader.setAlignment(HorizontalAlignment.CENTER);
        cellStyleHeader.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyleHeader.setLocked(false);
        XSSFFont headerFont = createFont();
        cellStyleHeader.setFont(headerFont);
        return cellStyleHeader;
    }

    public  XSSFFont createFont() {
        XSSFFont font = hssfWorkbook.createFont();
        font.setFontName("黑体");
        font.setBold(true);
        return font;
    }

    public XSSFWorkbook getHssfWorkbook() {
        return hssfWorkbook;
    }

    public void setHssfWorkbook(XSSFWorkbook hssfWorkbook) {
        this.hssfWorkbook = hssfWorkbook;
    }

    public XSSFSheet getSheet() {
        return sheet;
    }

    public void setSheet(XSSFSheet sheet) {
        this.sheet = sheet;
    }
}
