/*
 * Decompiled with CFR 0.152.
 */
package ytx.org.apache.http.impl.cookie;

import ytx.org.apache.http.annotation.Immutable;
import ytx.org.apache.http.cookie.Cookie;
import ytx.org.apache.http.cookie.CookieOrigin;
import ytx.org.apache.http.cookie.MalformedCookieException;
import ytx.org.apache.http.cookie.SetCookie;
import ytx.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;

@Immutable
public class BasicSecureHandler
extends AbstractCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        return !cookie.isSecure() || origin.isSecure();
    }
}

