package com.xxfc.platform.vehicle.pojo.dto;

import com.github.wxiaoqi.security.common.vo.DataInter;
import com.github.wxiaoqi.security.common.vo.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class VehiclePlanDto extends PageParam implements DataInter {

    /**
     * 车辆编号
     */
    private Integer code;

    @ApiModelProperty(value = "车辆Id")
    private String vehicleId;

    @ApiModelProperty(value = "开始时间")
    private String startTime;

    @ApiModelProperty(value = "结束时间")
    private String endTime;

    @ApiModelProperty(value = "车辆状态")
    private Integer status;

    @ApiModelProperty(value = "车牌")
    private String numberPlate;

    @ApiModelProperty(value = "所属分公司Id")
    private Integer subordinateBranch;

    @ApiModelProperty(value = "停车分公司Id")
    private Integer parkBranchCompanyId;

    @ApiModelProperty(value = "所属分公司大区")
    private Integer zoneId;

    private List<Integer> companyIds;
    /**
     * 车辆用途 1、租赁，2、自用
     */
    private Integer useType;

    private String keywords;

    /**
     * 车型id
     */
    private Integer modelId;

    private  Long branchId;

    List<Integer> dataCorporationIds;

    List<Integer> dataCompanyIds;
}
