package com.xxfc.platform.universal.fastservice.dto;

import lombok.Data;

/**
 * 快服务事件通知参数实体
 */
@Data
public class EventNotifyRequestDto {
    private String requestTime; //	String(17)	M	请求报文的发送时间，格式：yyyyMMddHHmmssSSS(UTC)
    private String requestId;//	String	M 事件唯一ID。在消息是否重传、以及撤销时作唯一识别标识。如果重传，则需要保证重传消息的requestId与原消息的requestId一致，服务端会对重复请求进行过滤处理。其他情况，则需要保证每次requestId不同。可以使用UUID作为requestId；Pattern: [a-zA-Z0-9\-]{1,64}。
    private String openId;	//String(512)	M	华为分配的，第三方帐号与华为帐号的关联ID。
    private String eventName;	//	String(100)	M	事件名称，由开发者定义，在事件卡片规则中关联到某个卡片；需要保证事件名称在同一个appid下是唯一的。
    private String parameters;	//String(255)	O  事件的参数，由开发者定义，华为快服务智慧平台透传给卡片页面。 Json格式，key不能以_、$和hag_开始，不要使用for, if, show, tid等保留字。
    private String effectiveTime;	//String(17)	M	事件的生效时间，如酒店入住时间；UTC时区，精确到毫秒，格式：yyyyMMddHHmmssSSS。
    private String expireTime;	//String(17)	M	事件的失效时间，超过该时间后，事件不再通知用户，UTC时区，精确到毫秒，格式：yyyyMMddHHmmssSSS。
    private String abilityId;	//String(128)	O	通知的服务ID，开发者可以在华为快服务智慧平台的开发者控制台上获取。
    private OAuthToken oAuthToken;	//OAuthToken	O  开发者在账号绑定完成后，如果快应用服务器需要对用户的快应用请求进行鉴权，则需要给用户分配AccessToken/RefreshToken信息；如果快应用服务器需要刷新保存在华为快服务智慧平台的用户AccessToken/RefreshToken，也通过该参数。
}
