package com.xxfc.platform.uccn.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import com.xxfc.platform.vehicle.pojo.dto.BranchCompanyFindDTO;
import com.xxfc.platform.vehicle.pojo.vo.BranchCompanyListVO;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/9/17 15:24
 */
@RestController
@RequestMapping("/app/unauth/branch_company")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class BranchCompanyController {

    private final VehicleFeign vehicleFeign;

    @PostMapping("/page")
    public ObjectRestResponse<PageDataVO> listBranchCompanyWithPage(@RequestBody BranchCompanyFindDTO branchCompanyFindDTO) {
        PageDataVO<BranchCompanyListVO> branchCompanyWithPage = vehicleFeign.findBranchCompanyWithPage(branchCompanyFindDTO);
        return ObjectRestResponse.succ(branchCompanyWithPage);
    }
}
