package com.xxfc.platform.tour.entity;

import java.io.Serializable;
import java.util.List;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;


/**
 * 旅游路线标签
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 11:41:51
 */
@Data
@Table(name = "tour_tag")
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class TourTag implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 主键id
	 */

	@Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Integer id;

	/**
	 * 名称
	 */
	@Column(name = "name")
	@ApiModelProperty(value = "名称")
    private String name;

	/**
	 * 图片
	 */

	@Column(name = "img")
	@ApiModelProperty(value = "图片")
    private String img;

	/**
	 * 描述
	 */
	@Column(name = "describe")
	@ApiModelProperty(value = "描述")
    private String describe;

	/**
	 * 链接
	 */
	@Column(name = "link")
	@ApiModelProperty(value = "链接")
    private String link;

	/**
	 * 是否热门：0-否；1-是
	 */
    @Column(name = "is_hot")
	@ApiModelProperty(value = "是否热门：0-否；1-是")
    private Integer isHot;

	/**
	 * 成单量
	 */
	@Column(name = "count")
	@ApiModelProperty(value = "成单量")
    private Integer count;

	/**
	 * 排序
	 */
    @Column(name = "rank")
	@ApiModelProperty(value = "排序")
    private Integer rank;
	
	/**
	 * 创建时间
	 */
    @Column(name = "ctr_time")
	@ApiModelProperty(value = "创建时间")
    private Long ctrTime;

	/**
	 * 更新时间
	 */
	@Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;

	/**
	 * 是否删除:0-正常；1-删除
	 */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除:0-正常；1-删除")
    private Integer isDel;

    @Transient
	private List<TourGood> list;
}
