package com.xxfc.platform.order.mqhandler;


import cn.hutool.json.JSONUtil;
import com.rabbitmq.client.Channel;
import com.xxfc.platform.order.biz.CompanyWalletDetailBiz;
import com.xxfc.platform.order.biz.CompanyWalletDetailV2Biz;
import com.xxfc.platform.order.biz.OrderAccountBiz;
import com.xxfc.platform.order.biz.OrderRefundBiz;
import com.xxfc.platform.order.contant.enumerate.OrderTypeEnum;
import com.xxfc.platform.order.entity.CompanyWalletDetail;
import com.xxfc.platform.order.pojo.mq.OrderMQDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.support.AmqpHeaders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import static com.xxfc.platform.order.config.RabbitOrderConfig.*;

@Component
@Slf4j
public class OrderExtractMQHandler {

    @Autowired
    CompanyWalletDetailV2Biz companyWalletDetailBiz;



    /**
     * 退款
     * @param
     */
    @RabbitListener(queues = ORDER_DEPOSIT_FINISH_QUEUE)
    public void integralHandler(Message message, @Headers Map<String, Object> headers, Channel channel) {
        try {
            Thread.sleep(5000L);
        }catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        ExecutorService executorService = Executors.newCachedThreadPool();
        executorService.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    String messageId = message.getMessageProperties().getMessageId();
                    String msg = new String(message.getBody(), "UTF-8");
                    OrderMQDTO orderMQDTO = JSONUtil.toBean(msg, OrderMQDTO.class);
                    CompanyWalletDetail companyWalletDetail=new CompanyWalletDetail();
                    companyWalletDetail.setCono(orderMQDTO.getNo());
                    //companyWalletDetailBiz.addOrUpd(companyWalletDetail,1);
                    executorService.shutdown();
                    Long deliveryTag = (Long) headers.get(AmqpHeaders.DELIVERY_TAG);
                    // 手动签收
                    channel.basicAck(deliveryTag, false);
                } catch (Exception e) {
                    log.info("接收到的消息失败");
                    try {
                        channel.basicNack(message.getMessageProperties().getDeliveryTag(), false, false);
                    } catch (IOException i) {
                        log.error(e.getMessage(), i);
                    }
                    log.error(e.getMessage(), e);
                }
            }
        });
    }


    /**
     * 退款
     * @param
     */
    @RabbitListener(queues = ORDER_DEPOSIT_END2_QUEUE)
    public void orderHandler(Message message, @Headers Map<String, Object> headers, Channel channel) {
        try {
            Thread.sleep(5000L);
        }catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        ExecutorService executorService = Executors.newCachedThreadPool();
        executorService.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    String messageId = message.getMessageProperties().getMessageId();
                    String msg = new String(message.getBody(), "UTF-8");
                    OrderMQDTO orderMQDTO = JSONUtil.toBean(msg, OrderMQDTO.class);
                    CompanyWalletDetail companyWalletDetail=new CompanyWalletDetail();
                    companyWalletDetail.setCono(orderMQDTO.getNo());
                    //companyWalletDetailBiz.addOrUpd(companyWalletDetail,2);
                    executorService.shutdown();
                    Long deliveryTag = (Long) headers.get(AmqpHeaders.DELIVERY_TAG);
                    // 手动签收
                    channel.basicAck(deliveryTag, false);
                } catch (Exception e) {
                    log.info("接收到的消息失败");
                    try {
                        channel.basicNack(message.getMessageProperties().getDeliveryTag(), false, false);
                    } catch (IOException i) {
                        log.error(e.getMessage(), i);
                    }
                    log.error(e.getMessage(), e);
                }
            }
        });
    }
}
