package com.xxfc.platform.order.pojo.order;

import com.github.wxiaoqi.security.common.constant.CommonConstants;
import lombok.Data;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.*;

@Data
public class DelayRentOrderDTO {
    Integer operateId;
    String no;
    Integer needDamageSafe = 0;
    Long delayEndTime;
    Long endTime;
    String bookEndDate;
    String bookEndDateTime;
    Long startTime;
    String bookStartDate;
    String bookStartDateTime;

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
        this.bookStartDate = stampTo8Zone(YMR_SLASH_FORMATTER, startTime);
        this.bookStartDateTime = stampTo8Zone(DATE_TIME_LINE_FORMATTER, startTime);
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
        this.bookEndDate = stampTo8Zone(YMR_SLASH_FORMATTER, endTime);
        this.bookEndDateTime = stampTo8Zone(DATE_TIME_LINE_FORMATTER, endTime);
    }
}