package com.xxfc.platform.order.pojo.dto;


import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import java.math.BigDecimal;

/**
 * 门店收支明细DTO
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/25 14:53
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CompanyWalletDetailDTO{


    @ApiModelProperty("订单号")
    private  String orderNo;

    @ApiModelProperty("出发门店")
    private  Integer startCompanyId;


    @ApiModelProperty("结束门店")
    private  Integer endCompanyId;


    @ApiModelProperty("所属门店")
    private  Integer vehicleCompanyId;


    @ApiModelProperty("平台门店")
    private  Integer platformCompanyId;


    @ApiModelProperty("平台门店")
    private  Long platformBranchId;


    @ApiModelProperty("订单总额")
    private BigDecimal orderAmount =BigDecimal.ZERO;

    @ApiModelProperty("收车服务费")
    private BigDecimal closedVehicleAmout =BigDecimal.ZERO;


    @ApiModelProperty("不计免赔费")
    private BigDecimal damageSafeAmount =BigDecimal.ZERO;


    @ApiModelProperty("押金")
    private BigDecimal deposit =BigDecimal.ZERO;

    //算出来
    @ApiModelProperty("分销金额")
    private BigDecimal comssion =BigDecimal.ZERO;


    @ApiModelProperty("定损费")
    private BigDecimal lossSpecifiedAmount =BigDecimal.ZERO;


    @ApiModelProperty("违章费")
    private BigDecimal breakRulesRegulation =BigDecimal.ZERO;


    @ApiModelProperty("违约金")
    private BigDecimal violateAmount =BigDecimal.ZERO;


    @ApiModelProperty("订单抽成比例")
    private BigDecimal orderExtract = new BigDecimal(1);


    @ApiModelProperty("平台抽成比例")
    private BigDecimal platformExtract = new BigDecimal(1);


    //算出来
    @ApiModelProperty("车辆费用")
    private  BigDecimal vehicleAmount;

    public  BigDecimal getVehicleAmount(){
        return orderAmount.subtract(closedVehicleAmout).subtract(damageSafeAmount).subtract(deposit).subtract(comssion);
    }


    @ApiModelProperty("订单抽成")
    private  BigDecimal orderComssion;


    public  BigDecimal getOrderComssion(){
        return getVehicleAmount().multiply(orderExtract).setScale(2, BigDecimal.ROUND_HALF_UP);
    }


    @ApiModelProperty("平台抽成")
    private  BigDecimal platformComssion;


    public  BigDecimal getPlatformComssion(){
        return getVehicleAmount().multiply(platformExtract).setScale(2, BigDecimal.ROUND_HALF_UP);
    }


    //算出来
    @ApiModelProperty("车辆租赁费")
    private  BigDecimal rentVehicleAmount;



    public  BigDecimal getRentVehicleAmount(){
        return getVehicleAmount().subtract(getOrderComssion()).subtract(getPlatformComssion());
    }




    @ApiModelProperty("出发门店金额")
    private  BigDecimal startCompanyAmount;



    public  BigDecimal getStartCompanyAmount(){
        return  getOrderComssion();
    }


    @ApiModelProperty("收车门店金额")
    private  BigDecimal endCompanyAmount;



    public  BigDecimal getEndCompanyAmount(){
        return  this.closedVehicleAmout;
    }


    @ApiModelProperty("所属门店金额")
    private  BigDecimal vehicleCompanyAmount;

    public  BigDecimal getVehicleCompanyAmount(){
        return  getVehicleAmount().add(damageSafeAmount).add(lossSpecifiedAmount).add(breakRulesRegulation).add(violateAmount);
    }






}
