package com.xxfc.platform.order.contant.enumerate;

import java.util.HashMap;
import java.util.Map;

public enum CompanyWalletITypeEnum {
    VEHICLE(1, "租车订单收入"),
    VIOLATE(2, "违约金"),
    REGULATION(3, "违章补偿"),
    LOSS(4, "定损"),
    PLATFORM(5, "平台抽成"),
    CATH(6, "提现"),
    TOUR(7, "旅游订单收入"),
    ;
    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    public static Map<Integer, CompanyWalletITypeEnum> codeAndDesc = new HashMap<Integer, CompanyWalletITypeEnum>();
            //Maps.newHashMap();

    static{
        for(CompanyWalletITypeEnum enumE : CompanyWalletITypeEnum.values()){
            codeAndDesc.put(enumE.getCode(), enumE);
        }
    }

    CompanyWalletITypeEnum(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }

    public static CompanyWalletITypeEnum get(Integer code) {
        for(CompanyWalletITypeEnum enumE : CompanyWalletITypeEnum.values()) {
            if (enumE.getCode().equals(code)) {
                return enumE;
            }
        }
        return null;
    }
}