package com.xxfc.platform.campsite.rest;

import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.GoodDataVO;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.campsite.biz.CampsiteShopBiz;
import com.xxfc.platform.campsite.dto.CampsiteShopFindDTO;
import com.xxfc.platform.campsite.entity.CampsiteShop;
import com.xxfc.platform.campsite.vo.CampsiteShopDetailVo;
import com.xxfc.platform.campsite.vo.CampsiteShopPageVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description 营地店铺
 * @data 2019/6/17 13:37
 */
@RestController
@RequestMapping("/campsiteShop")
@Api(tags = "App营地店铺")
public class CampsiteShopController extends BaseController<CampsiteShopBiz, CampsiteShop> {


    @ApiOperation("分页查询营地列表")
    @GetMapping("/app/unauth/shops")
    public ObjectRestResponse<PageDataVO<CampsiteShopPageVo>> findCampsiteShopPageByTypeAndName(@RequestParam(value = "type", required = false) Integer type,
                                                                                                @RequestParam(value = "pageNo", required = false, defaultValue = "1") Integer pageNo,
                                                                                                @RequestParam(value = "pageSize", required = false, defaultValue = "6") Integer pageSize,
                                                                                                @RequestParam(value = "keyWord",required = false) String keyWord) {
        CampsiteShopFindDTO campsiteShopFindDTO = new CampsiteShopFindDTO();
        campsiteShopFindDTO.setType(type);
        campsiteShopFindDTO.setPage(pageNo);
        campsiteShopFindDTO.setLimit(pageSize);
        campsiteShopFindDTO.setKeyWord(keyWord);
        PageDataVO<CampsiteShopPageVo> pageDataVO = getBaseBiz().findCampsiteShopPageByType(campsiteShopFindDTO);
        return ObjectRestResponse.succ(pageDataVO);
}

    @PostMapping(value = "/app/unauth/campsites")
    public ObjectRestResponse<PageDataVO<CampsiteShopPageVo>> findCampsiteShopPageForUncc(@RequestBody CampsiteShopFindDTO campsiteShopFindDTO) {
        PageDataVO<CampsiteShopPageVo> campsiteShops = baseBiz.findCampsiteShopPageForUncc(campsiteShopFindDTO);
        return ObjectRestResponse.succ(campsiteShops);
    }

    /**
     * @param longitude 经度
     * @param latitude  纬度
     * @return
     */
    @ApiOperation("查询营地详情")
    @GetMapping("/app/unauth/shop")
    public ObjectRestResponse<CampsiteShopDetailVo> findCampsiteShopDetailById(@RequestParam(value = "id") Integer id,
                                                                               @RequestParam(value = "longitude", required = false) Double longitude,
                                                                               @RequestParam(value = "latitude", required = false) Double latitude,
                                                                               AppUserDTO appUserDTO) {
        CampsiteShopDetailVo campsiteShopDetailVo = getBaseBiz().findCampsiteShopDetailById(appUserDTO.getUserid(),id, longitude, latitude);
        return ObjectRestResponse.succ(campsiteShopDetailVo);
    }

    @ApiOperation("首页营地列表")
    @GetMapping(value = "/app/shopList")
    public List<GoodDataVO> goodList(@RequestParam(value = "page", defaultValue = "1") Integer page,
                                     @RequestParam(value = "limit", defaultValue = "4") Integer limit,
                                     @RequestParam(value = "longitude", required = false) Double longitude,
                                     @RequestParam(value = "latitude", required = false) Double latitude) {
        return getBaseBiz().getAllByHome(page, limit,longitude,latitude);
    }

    @ApiOperation("随机获取营地")
    @GetMapping(value = "/app/unauth/findRandomVehicle")
    public ObjectRestResponse findRandomVehicle(Integer number) {
        return baseBiz.findRandomVehicle(number);
    }

    @PostMapping(value = "/app/unauth/webchat_official/campsites")
    public ObjectRestResponse<PageDataVO<CampsiteShopPageVo>> findCampsitesForPublicNumber(@RequestBody CampsiteShopFindDTO campsiteShopFindDTO) {

        PageDataVO<CampsiteShopPageVo> campsiteShops = baseBiz.findCampsiteShopPageByType(campsiteShopFindDTO);
        return ObjectRestResponse.succ(campsiteShops);
    }


    @ApiOperation("首页营地列表")
    @GetMapping(value = "/app/unauth/info")
    public ObjectRestResponse<CampsiteShop> info(@RequestParam(value = "id", defaultValue = "0") Integer id) {
        return ObjectRestResponse.succ(baseBiz.selectById(id));
    }

}