package com.github.wxiaoqi.security.admin.rest.admin;

import com.github.wxiaoqi.security.admin.biz.MemberShareCountRecordBiz;
import com.github.wxiaoqi.security.admin.dto.MemberShareCountRecordDto;
import com.github.wxiaoqi.security.admin.entity.MemberShareCountRecord;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

@RestController
@RequestMapping("memberShareCountRecord")
@Slf4j
public class MemberShareCountRecordController extends BaseController<MemberShareCountRecordBiz, MemberShareCountRecord> {

	@GetMapping(value = "selectList")
	public ObjectRestResponse selectList(MemberShareCountRecordDto memberShareCountRecordDto) {
		return baseBiz.selectList(memberShareCountRecordDto);
	}

	@GetMapping(value = "export")
	public ObjectRestResponse export(HttpServletResponse response, MemberShareCountRecordDto memberShareCountRecordDto) {
		try {
			baseBiz.exportRecordList(response, memberShareCountRecordDto);
		} catch (Exception e) {
			log.error("{}", e);
			return ObjectRestResponse.createDefaultFail();
		}
		return ObjectRestResponse.succ();
	}


}