package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.UserMemberLevelBiz;
import com.github.wxiaoqi.security.admin.entity.BaseUserMemberLevel;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.weekend.WeekendSqls;

import java.util.List;

/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-08 11:51
 */
@RestController
@RequestMapping("member")
@IgnoreClientToken
public class MemberLevelController extends BaseController<UserMemberLevelBiz, BaseUserMemberLevel> {

    @Autowired
    private UserMemberLevelBiz memberBiz;

    @RequestMapping(value = "/app/unauth/levels", method = RequestMethod.GET)
    public @ResponseBody
    List<BaseUserMemberLevel> levels() throws Exception {
        return memberBiz.getLevesls();
    }

    @RequestMapping(value = "/app/unauth/level/list", method = RequestMethod.GET)
    public ObjectRestResponse<List<BaseUserMemberLevel>>list(BaseUserMemberLevel baseUserMemberLevel) throws Exception {
        baseUserMemberLevel.setIsShow(1);
        return ObjectRestResponse.succ(memberBiz.getList(baseUserMemberLevel));
    }

    @RequestMapping(value = "/app/unauth/level/{type}", method = RequestMethod.GET)
    public @ResponseBody
    BaseUserMemberLevel level(@PathVariable Integer type) throws Exception {
         List<BaseUserMemberLevel> list=memberBiz.getLevesls();
         if(type!=null){
             if(list.size()>0){
                 for (BaseUserMemberLevel userMemberLevel:list){
                     if(userMemberLevel.getLevel()!=null&&userMemberLevel.getLevel()==type){
                         return userMemberLevel;
                     }
                 }
             }
         }
        return null;
    }

      @GetMapping("/manage/getMembers")
    public ObjectRestResponse getMembers(){
        Example exa = Example.builder(BaseUserMemberLevel.class).where(
                WeekendSqls.<BaseUserMemberLevel>custom()
                        .andEqualTo(BaseUserMemberLevel::getIsdel,0)
        ).orderByAsc("level").build();
        List<BaseUserMemberLevel> baseUserMemberLevels = baseBiz.selectByExample(exa);
        return ObjectRestResponse.succ(baseUserMemberLevels);
    }


    @DeleteMapping("/manage/delMembershipGrade/{id}")
    public ObjectRestResponse delMembershipGrade(@PathVariable Integer id){
        BaseUserMemberLevel baseUserMemberLevel = new BaseUserMemberLevel();
        baseUserMemberLevel.setId(id);
        baseUserMemberLevel.setIsdel(1);
        baseBiz.updateSelectiveByIdRe(baseUserMemberLevel);
        return ObjectRestResponse.succ();
    }

    @PutMapping("/update")
    public ObjectRestResponse<Void> updateMemberBaseInfo(@RequestBody BaseUserMemberLevel baseUserMemberLevel){
        getBaseBiz().updateMemberBaseInfo(baseUserMemberLevel);
        return ObjectRestResponse.succ();
    }
}
