package com.github.wxiaoqi.security.admin.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 会员分成月统计信息
 * 
 * @author jiaoruizhen
 * @email jiaoruizhen@126.com
 * @date 2020-11-03 11:12:15
 */
@Data
@Table(name = "member_share_count_record")
public class MemberShareCountRecord implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  会员用户分成月统计id
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("会员用户分成月统计id")
    private Long id;
	
	    /**
     *  用户id
     */
    @Column(name = "user_id")
	@ApiModelProperty(value = "用户id")
    private Long userId;
	
	    /**
     *  用户姓名
     */
    @Column(name = "real_name")
	@ApiModelProperty(value = "用户姓名")
    private String realName;
	
	    /**
     *  统计月份
     */
    @Column(name = "count_month")
	@ApiModelProperty(value = "统计月份")
    private String countMonth;
	
	    /**
     *  总金额
     */
    @Column(name = "amount")
	@ApiModelProperty(value = "总金额")
    private BigDecimal amount;
	
	    /**
     *  
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "", hidden = true )
    private Long crtTime;
	
	    /**
     *  
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "", hidden = true )
    private Long updTime;
	
	    /**
     *  会员等级
     */
    @Column(name = "member_level")
	@ApiModelProperty(value = "会员等级")
    private Integer memberLevel;
	

}
