package com.xxfc.platform.universal.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;


/**
 * 下单
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-28 16:17:42
 */
@Data
public class OrderPayVo{

    //订单号
    @ApiModelProperty(value = "订单号")
    private String orderNo;

    //用户id
    @ApiModelProperty(value = "用户id")
    private Integer userId;
	
    //1:微信公众号支付 2.支付宝即时到账,3,银联
    @ApiModelProperty(value = "1:微信公众号支付 2.支付宝即时到账,3,银联")
    private Integer payWay;
	
    //渠道：1-租车;2-旅游
    @ApiModelProperty(value = "渠道：1-租车;2-旅游")
    private Integer channel;
	
    //来源:1-app;2-小程序
    @ApiModelProperty(value = "1-app;2-小程序")
    private Integer type;
	
    //买家IP地址
    @ApiModelProperty(value = "买家IP地址")
    private String buyerIp;
	
    //商品标题
    @ApiModelProperty(value = "商品标题")
    private String subject;
	
    //商品描述信息
    @ApiModelProperty(value = "商品描述信息")
    private String body;

    //回调地址
    @ApiModelProperty(value = "回调地址")
    private String notifyUrl;

    //支付金额 分
    @ApiModelProperty(value = "支付金额")
    private Integer amount;

    //买家第三方付款账号
    @ApiModelProperty(value = "买家第三方付款账号")
    private String buyerAccount;


}
