package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.AppUserManageBiz;
import com.github.wxiaoqi.security.admin.entity.AppUserManage;
import com.github.wxiaoqi.security.admin.vo.AppUserVo;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import org.springframework.web.bind.annotation.*;

/**
 * app用户管理类
 * @author Administrator
 */
@RestController
@RequestMapping("appUsersManage")
public class AppUsersManageController extends BaseController<AppUserManageBiz,AppUserManage> {

    /**
     * 查询所有
     * @return
     */
    @GetMapping("/findAll")
    public ObjectRestResponse<AppUserVo> findAllByQuery(@RequestBody AppUserVo  appUserVo){
        return ObjectRestResponse.succ(baseBiz.findAllByQuery(appUserVo));
    }

    /**
     * 删除
     * @param id
     * @return
     */
    @DeleteMapping("/deleteById/{id}")
    public  ObjectRestResponse deleteById(@PathVariable Integer id){
          baseBiz.deleteAppUser(id);
        return ObjectRestResponse.succ();
    }

    /**
     * 查询一条
     * @param id
     * @return
     */
    @GetMapping("/findOneById/{id}")
    public ObjectRestResponse<AppUserVo> findOneById(@PathVariable Integer id){
        return ObjectRestResponse.succ(baseBiz.findOneById(id));
    }

    @PostMapping("/save")
    public ObjectRestResponse save(@RequestBody AppUserVo  appUserVo){
        baseBiz.save(appUserVo);
        return ObjectRestResponse.succ();
    }


}
