package com.github.wxiaoqi.security.auth.feign;

import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.api.vo.user.AppUserInfo;
import com.github.wxiaoqi.security.api.vo.user.UserInfo;
import com.github.wxiaoqi.security.auth.configuration.FeignConfiguration;
import com.github.wxiaoqi.security.auth.util.user.JwtAuthenticationRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;


/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-21 8:11
 */
@FeignClient(value = "ace-admin", configuration = FeignConfiguration.class)
public interface IUserService {
    @RequestMapping(value = "/api/user/validate", method = RequestMethod.POST)
    public UserInfo validate(@RequestBody JwtAuthenticationRequest authenticationRequest);

    @RequestMapping(value = "/api/app/user/validate", method = RequestMethod.POST)
    AppUserInfo AppValidate(@RequestBody JwtAuthenticationRequest authenticationRequest);

    @RequestMapping(value = "/api/app/user/sendsms", method = RequestMethod.POST)
    public JSONObject sendsms(@RequestParam(value="username",defaultValue="")String  username, @RequestParam(value="type",defaultValue="0")Integer type);
    @RequestMapping(value = "/api/app/user/register", method = RequestMethod.POST)
    public JSONObject register(   @RequestParam(value="username",defaultValue="")String  username,
                                  @RequestParam(value="mobilecode",defaultValue="")String mobilecode,
                                  @RequestParam(value="password",defaultValue="")String  password);
   @RequestMapping(value = "/api/app/user/wxregister", method = RequestMethod.POST)
    public JSONObject wxregister(
            @RequestParam(value="username")String  username,@RequestParam(value="mobilecode")String mobilecode,
            @RequestParam(value="password")String  password,@RequestParam(value="nickname")String  nickname,
            @RequestParam(value="headimgurl")String  headimgurl,@RequestParam(value="openid")String  openid,
            @RequestParam(value="unionid")String  unionid,@RequestParam(value="type")Integer  type,@RequestParam(value="isQQ")Integer  isQQ);
    @RequestMapping(value = "/api/app/user/checkBindWechat",method = RequestMethod.POST)
    public JSONObject checkBindWechat( @RequestParam(value="username")String  username);
    @RequestMapping(value = "/api/app/user/wxlogin",method = RequestMethod.POST)
    public JSONObject wxlogin(@RequestParam(value="openid")String  openid,@RequestParam(value="isQQ")Integer  isQQ);
    @RequestMapping(value = "/api/app/user/login", method = RequestMethod.POST)
    public JSONObject login(   @RequestParam(value="username")String  username,
                               @RequestParam(value="password")String  password,
                               @RequestParam(value="mobilecode")String mobilecode,
                               @RequestParam(value="type")Integer  type);
    @RequestMapping(value = "/api/app/user/reset", method = RequestMethod.POST)
    public JSONObject reset(   @RequestParam(value="username")String  username,
                                  @RequestParam(value="mobilecode")String mobilecode,
                                  @RequestParam(value="password")String  password);

    /**
     * 小程序通过用户id登录登录
     * @param userid
     * @return
     */
    @RequestMapping(value = "/api/app/applet/uid/login", method = RequestMethod.POST)
    public JSONObject appletLogin(@RequestParam(value = "userid") Integer userid);

    /**
     * 小程序注册
     * @param username
     * @param nickname
     * @param headimgurl
     * @return
     */
    @PostMapping("/api/app/applet/registry")
    public JSONObject appletRegistry(@RequestParam(value="username")String  username, @RequestParam(value="nickname")String  nickname,
                                     @RequestParam(value="headimgurl")String  headimgurl,@RequestParam(value="userid",defaultValue="0")Integer  userid);
}
