package com.xxfc.platform.vehicle.mapper;

import com.xxfc.platform.vehicle.entity.VehicleUserScore;
import com.xxfc.platform.vehicle.pojo.dto.VehicleUserScoreDetailDTO;
import com.xxfc.platform.vehicle.pojo.dto.VehicleUserScoreListDTO;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

/**
 * 用户评分表
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-18 15:03:58
 */
public interface VehicleUserScoreMapper extends Mapper<VehicleUserScore> {

    /**
     * 根据审核状态和车型id查询评论
     * @param modelId
     * @param status
     * @return
     */
    @Select("select `user_id` as `userId`,`comment` as `comment`,`ave_score` as `aveScore`,`is_anony` as `isAnony`,`imgs` as `imgs`,`crt_time` as `crtTime` from `vehicle_user_score` where `model_id`=#{modelId} and `status`=#{status}")
    List<VehicleUserScoreListDTO> findyByModelIdAndApproved(@Param("modelId") Integer modelId, @Param("status") Integer status);

    /**
     * 根据订单查询评价
     * @param orderId
     * @return
     */
    VehicleUserScoreDetailDTO findVehicleUserScoreDetailByOrderId(Integer orderId);
}
