package com.xxfc.platform.order.pojo.price;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class TourPriceVO extends OrderPriceVO{
    @ApiModelProperty(value = "费用详情")
    private String costDetail;
    @ApiModelProperty(value = "成人人数")
    private Integer number;
    @ApiModelProperty(value = "儿童人数")
    private Integer childNumber;

    //大人单价"
    @ApiModelProperty(value = "大人单价")
    private BigDecimal price;

    //大人总价
    @ApiModelProperty(value = "大人总价")
    private BigDecimal totalPrice;

    //大人真实总价（优惠后的价格）
    @ApiModelProperty(value = "大人真实总价（优惠后的价格）")
    private BigDecimal realPrice;

    //儿童单价
    @ApiModelProperty(value = "儿童单价")
    private BigDecimal childPrice;

    //儿童总价
    @ApiModelProperty(value = "儿童总价")
    private BigDecimal totalChildPrice;

    //儿童真实总价（优惠后的价格）
    @ApiModelProperty(value = "儿童真实总价（优惠后的价格）")
    private BigDecimal realChildPrice;
}
