package com.xxfc.platform.campsite.mapper;

import com.xxfc.platform.campsite.dto.CampsiteTagListDTO;
import com.xxfc.platform.campsite.entity.CampsiteTag;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Update;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

/**
 * 店铺类型表
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-17 10:28:48
 */
public interface CampsiteTagMapper extends Mapper<CampsiteTag> {


    /**
     * 查询可用营地列表
     * @return
     */
    List<CampsiteTagListDTO> findCampsiteTags();

    /**
     * 更新类型的删除状态
     * @param tagId
     * @param status
     * @return
     */
    @Update("update `campsite_tag` set `is_del`=#{status} where `id`=#{tagId}")
    int updateCampsiteTagStatus(@Param("tagId") Integer tagId, @Param("status") int status);
}
