package com.xxfc.platform.campsite.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Table;
import java.io.Serializable;


/**
 * 店铺类型表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-17 10:28:48
 */
@Data
@Table(name = "campsite_shop_tag")
@ApiModel(value = "店铺类型vo")
public class CampsiteShopTagVo implements Serializable {
    private static final long serialVersionUID = 1L;


    @ApiModelProperty("首页banner图主键")
    private Long id;

    /**
     * 店铺id
     */
    @ApiModelProperty(value = "店铺id")
    private Integer shopId;

    /**
     * 类型id
     */
    @ApiModelProperty(value = "类型id")
    private Integer tagId;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间", hidden = true)
    private Long crtTime;

    /**
     * 修改时间
     */
    @ApiModelProperty(value = "修改时间", hidden = true)
    private Long updTime;

    /**
     * 是否删除，0否，1是
     */
    @ApiModelProperty(value = "是否删除，0否，1是")
    private Integer isDel;


}
