package com.github.wxiaoqi.security.admin.feign;

import com.github.wxiaoqi.security.admin.dto.UserMemberDTO;
import com.github.wxiaoqi.security.admin.entity.BaseUserMemberLevel;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.admin.vo.AppUserVo;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-21 8:11
 */
@FeignClient(value = "ace-admin")
public interface UserFeign {
    @RequestMapping(value = "/public/userinfo-by-token")
    public ObjectRestResponse<UserDTO> userinfoByToken(@RequestParam("token") String token);

    /**
     * token获取用户信息
     * @param token
     * @return
     */
    @RequestMapping(value = "/public/app/userinfo-by-token")
    public ObjectRestResponse<AppUserDTO> userDetailByToken(@RequestParam("token") String token);


    /**
     *status:0-判断是否认证过,1-认证成功后修改用户认证状态
     *userId:用户登录时的id,必须
     *idNumber:证件号,修改认证状态是必须有
     */
    @RequestMapping(value = "/api/app/user/authentication", method = RequestMethod.POST)
    public ObjectRestResponse authentication( @RequestParam(value="userId")Integer  userId,
                                              @RequestParam(value="idNumber")String idNumber,
                                              @RequestParam(value="status")Integer  status);

    /**
     * 获取会员等级列表
     * @return
     */
    @RequestMapping(value = "/member/app/unauth/levels", method = RequestMethod.GET)
    public List<BaseUserMemberLevel> levels();

    /**
     * 获取单个会员等级
     * @return
     */
    @RequestMapping(value = "/member/app/unauth/level/{type}", method = RequestMethod.GET)
    public List<BaseUserMemberLevel> level(@PathVariable Integer type);

    /**
     * 批量获取用户基本信息
     * @param ids
     * @return
     */
    @RequestMapping(value = "/public/getByUserIds", method = RequestMethod.GET)
    public ObjectRestResponse<List<AppUserVo>> getByUserIds(@RequestParam("ids")List<Integer> ids);

    /**
     * 购买会员
     * @param userMemberDTO
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/user/buyMember", method = RequestMethod.POST)
    public ObjectRestResponse buyMember(@RequestBody UserMemberDTO userMemberDTO) throws Exception;

    /**
     * 订单更改会员
     * @param userId
     * @param days
     * @param type 1-用户锁定下单；2-购买下单;3-取消订单
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/user/buyMember", method = RequestMethod.POST)
    public int buyMember(
            @RequestParam(value = "userId",defaultValue = "0")Integer userId,
            @RequestParam(value = "days",defaultValue = "0")Integer days,
            @RequestParam(value = "type",defaultValue = "1")Integer type
    ) throws Exception;

    
}
