package com.xxfc.platform.order.pojo.account;

import lombok.Data;
import org.assertj.core.util.Lists;

import java.math.BigDecimal;
import java.util.List;

@Data
public class OrderAccountDetail {
    /**
     * 实际返回订单款 账单的的orderAmount 对应的是 订单的商品金额
     */
    BigDecimal orderAmount = BigDecimal.ZERO;
    /**
     * 实际返回押金款
     */
    BigDecimal depositAmount = BigDecimal.ZERO;
    /**
     * 原来要返回的订单款 账单的的orderAmount 对应的是 订单的商品金额
     */
    BigDecimal originOrderAmount = BigDecimal.ZERO;
    /**
     * 原来要返回的押金款
     */
    BigDecimal originDepositAmount = BigDecimal.ZERO;

    /**
     * 扣款列表
     */
    List<OrderAccountDeduction> deductions = Lists.newArrayList();
}
