package com.xxfc.platform.order.contant.enumerate;

import java.util.HashMap;
import java.util.Map;

public enum DeductionTypeEnum {
    //账款类型 1--违约金；2--消费金额；3--赔偿金（定损）；4--违章相关
    VIOLATE_CANCEL(101, "提前取消违约金"),
    VIOLATE_ADVANCE(102, "提前还车违约金"),
    VIOLATE_DELAY(103, "延迟还车违约金"),
    CONSUME(201, "消费金额"),
    DAMAGES(301, "赔偿金（定损）"),
    VIOLATE_TRAFFIC_DEDUCT(401, "违章扣款"),
    VIOLATE_TRAFFIC_KEEP(402, "违章扣款保留金"),
    ;
    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    private static Map<Integer,String> codeAndDesc = new HashMap<Integer, String>();
            //Maps.newHashMap();

    static{
        for(DeductionTypeEnum enumE : DeductionTypeEnum.values()){
            codeAndDesc.put(enumE.getCode(),enumE.getDesc());
        }
    }

    DeductionTypeEnum(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }
}