package com.xxfc.platform.universal.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;
import tk.mybatis.mapper.annotation.KeySql;
import tk.mybatis.mapper.code.IdentityDialect;

import javax.persistence.Column;
import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@Data
public class LicensePlateType implements Serializable {

    /**
     * id
     */
    @Id
    @KeySql(dialect = IdentityDialect.MYSQL)
    private Integer id;
    /**
     * 车型代码
     */
    private String code;

    /**
     * 车型类型
     */
    private String type;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone = "GMT-8",pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;

    /**
     * 修改时间
     */
    @Column(name = "update_date")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone = "GMT-8",pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateDate;


    public LicensePlateType(String code, String type) {
        this.code=code;
        this.type=type;
    }


    public LicensePlateType() {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LicensePlateType that = (LicensePlateType) o;
        return code.equals(that.code) &&
                type.equals(that.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(code, type);
    }
}
