package com.xxfc.platform.tour.biz;

import com.xxfc.platform.tour.mapper.TourUserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xxfc.platform.tour.entity.TourUser;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

import java.util.List;

/**
 * 出游人信息表
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 11:41:51
 */
@Service
public class TourUserBiz extends BaseBiz<TourUserMapper,TourUser> {


    /**
     * 获取全部成人或儿童
     * @param id 用户id
     * @param isChild 0-儿童 1-成年人
     * @return
     */
    public List<TourUser> findListByTourUserByIsChild(Integer id, Integer isChild) {
        TourUser user = new TourUser();
        user.setUserid(id);
        user.setIsdel(0);
        user.setIsChild(isChild);
        return mapper.findListByTourUserByIsChild(user);
    }

    /**
     * 获得全部出游人信息
     * @param id 用户id
     * @return
     */
    public List<TourUser> getTourUser(Integer id) {
        TourUser user = new TourUser();
        user.setUserid(id);
        user.setIsdel(0);
        return mapper.findListByTourUser(user);
    }

}