package com.xxfc.platform.order.pojo.price;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.xxfc.platform.vehicle.pojo.dto.order.VMCalendarPriceCostDTO;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class CostDetailExtend {

    public static final int CANCEL_NO_START = 1;
    public static final int CANCEL_STARTED = 2;
    public static final int FINLISH_ADVANCE = 3;
    public static final int FINLISH_DELAY = 4;
    public static final int FINLISH_ONTIME = 5;

    private String costDetail = "";

    /**
     * type：1--取消违约金；2--取消费用明细；3--提前还车费用明细；4--延期还车费用明细 5--订单按时还车
     */
    protected Integer type;

    /**
     * 违约金描述
     */
    private String violateDesc;

    /**
     * 违约金金额
     */
    private BigDecimal violateAmount = BigDecimal.ZERO;

    /**
     * 参数json
     */
    public String paramJson = "";

    /**
     * 使用（消耗）详情列表
     */
    List<VMCalendarPriceCostDTO> useAmountList = CollUtil.newArrayList();

    /**
     * 违约金 费用详情列表
     */
    List<VMCalendarPriceCostDTO> violateAmountList = CollUtil.newArrayList();

    //标记是否单价一样
    private Integer sameUseUnitPrice = 1;

    //标记是否单价一样
    private Integer sameViolateUnitPrice = 1;

    public void setSameUseUnitPriceFromList(List<VMCalendarPriceCostDTO> useAmountList) {
        this.sameUseUnitPrice = judgeSame(useAmountList);
    }

    public void setSameViolateUnitPriceFromList(List<VMCalendarPriceCostDTO> violateAmountList) {
        this.sameViolateUnitPrice = judgeSame(violateAmountList);
    }

    protected Integer judgeSame(List<VMCalendarPriceCostDTO> useAmountList) {
        BigDecimal tempUnitPrice = null;
        for(VMCalendarPriceCostDTO vmcpcd : useAmountList) {
            if(null == tempUnitPrice) {
                tempUnitPrice = vmcpcd.getPrice();
            }else if(!tempUnitPrice.equals(vmcpcd.getPrice())) {
                return 0;
            }
        }
        return 1;
    }

    public void initParamJson() {
        paramJson = JSONUtil.toJsonStr(this);
    }

}
