package com.xxfc.platform.campsite.mapper;

import com.xxfc.platform.campsite.dto.CampsiteTagDTO;
import com.xxfc.platform.campsite.dto.CampsiteTagListDTO;
import com.xxfc.platform.campsite.entity.CampsiteTag;
import org.apache.ibatis.annotations.Param;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

/**
 * 店铺类型表
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-17 10:28:48
 */
public interface CampsiteTagMapper extends Mapper<CampsiteTag> {


    /**
     * 查询可用营地列表
     * @return
     */
    List<CampsiteTagListDTO> findAllCampsiteTags();

    /**
     * 更新类型的删除状态
     * @param tagId
     * @param status
     * @return
     */
    int updateCampsiteTagStatusById(@Param("tagId") Integer tagId, @Param("status") int status);


    /**
     * 查询全部营地类型
     * @return
     */
    List<CampsiteTagDTO> findAllCampsiteTagsBydelStatus();

    /**
     * 更改筛选条件状态
     * @param id
     * @param status
     * @return
     */
    int updateCampsiteTagIsearchStatusById(@Param("id") Integer id, @Param("status") Integer status);


    /**
     * 检验营地类型名
     * @param id
     * @param name
     * @return
     */
    int checkTagNameExist(@Param("id") Integer id,@Param("name") String name);
}
