package com.xxfc.platform.vehicle;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.file.FileWriter;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.xxfc.platform.vehicle.biz.SysRegionBiz;
import com.xxfc.platform.vehicle.entity.SysRegion;
import lombok.Data;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.weekend.WeekendSqls;

import java.util.*;

@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest(classes={VehicleApplication.class})
public class RegionTest {
    @Autowired
    private RedisTemplate customRedisTemplate;

    @Autowired
    private SysRegionBiz sysRegionBiz;

//    public static final String TEST_REDIS_KEY ="redis:{1}";
     private   final String TEST_REDIS_KEY ="redis:{1}";
    @Data
    public class Title{
        String title;
        List<String> lists;
    }

    @Data
    public class City{
        List<Title> city;
    }

    @Data
    public class NewData{
        Long id;
        String name;
        String lat;
        String lon;
    }

    @Data
    public class NewTitle{
        String title;
        List<NewData> lists;
    }

    @Data
    public class NewCity{
        List<NewTitle> city;
    }

    @Data
    public class CityData{
        String name;
        List<CityItem> cities;
    }

    @Data
    public class CityItem {
        String name;
        String tags;
        Integer cityid;
    }

    //@Test
    public void test() throws Exception {
//        String jsonstr = "{\"city\":[{\"title\":\"A\",\"lists\":[\"阿坝\",\"阿拉善\",\"阿里\",\"安康\",\"安庆\",\"鞍山\",\"安顺\",\"安阳\",\"澳门\"]},{\"title\":\"B\",\"lists\":[\"北京\",\"白银\",\"保定\",\"宝鸡\",\"保山\",\"包头\",\"巴中\",\"北海\",\"蚌埠\",\"本溪\",\"毕节\",\"滨州\",\"百色\",\"亳州\"]},{\"title\":\"C\",\"lists\":[\"重庆\",\"成都\",\"长沙\",\"长春\",\"沧州\",\"常德\",\"昌都\",\"长治\",\"常州\",\"巢湖\",\"潮州\",\"承德\",\"郴州\",\"赤峰\",\"池州\",\"崇左\",\"楚雄\",\"滁州\",\"朝阳\"]},{\"title\":\"D\",\"lists\":[\"大连\",\"东莞\",\"大理\",\"丹东\",\"大庆\",\"大同\",\"大兴安岭\",\"德宏\",\"德阳\",\"德州\",\"定西\",\"迪庆\",\"东营\"]},{\"title\":\"E\",\"lists\":[\"鄂尔多斯\",\"恩施\",\"鄂州\"]},{\"title\":\"F\",\"lists\":[\"福州\",\"防城港\",\"佛山\",\"抚顺\",\"抚州\",\"阜新\",\"阜阳\"]},{\"title\":\"G\",\"lists\":[\"广州\",\"桂林\",\"贵阳\",\"甘南\",\"赣州\",\"甘孜\",\"广安\",\"广元\",\"贵港\",\"果洛\"]},{\"title\":\"H\",\"lists\":[\"杭州\",\"哈尔滨\",\"合肥\",\"海口\",\"呼和浩特\",\"海北\",\"海东\",\"海南\",\"海西\",\"邯郸\",\"汉中\",\"鹤壁\",\"河池\",\"鹤岗\",\"黑河\",\"衡水\",\"衡阳\",\"河源\",\"贺州\",\"红河\",\"淮安\",\"淮北\",\"怀化\",\"淮南\",\"黄冈\",\"黄南\",\"黄山\",\"黄石\",\"惠州\",\"葫芦岛\",\"呼伦贝尔\",\"湖州\",\"菏泽\"]},{\"title\":\"J\",\"lists\":[\"济南\",\"佳木斯\",\"吉安\",\"江门\",\"焦作\",\"嘉兴\",\"嘉峪关\",\"揭阳\",\"吉林\",\"金昌\",\"晋城\",\"景德镇\",\"荆门\",\"荆州\",\"金华\",\"济宁\",\"晋中\",\"锦州\",\"九江\",\"酒泉\"]},{\"title\":\"K\",\"lists\":[\"昆明\",\"开封\"]},{\"title\":\"L\",\"lists\":[\"兰州\",\"拉萨\",\"来宾\",\"莱芜\",\"廊坊\",\"乐山\",\"凉山\",\"连云港\",\"聊城\",\"辽阳\",\"辽源\",\"丽江\",\"临沧\",\"临汾\",\"临夏\",\"临沂\",\"林芝\",\"丽水\",\"六安\",\"六盘水\",\"柳州\",\"陇南\",\"龙岩\",\"娄底\",\"漯河\",\"洛阳\",\"泸州\",\"吕梁\"]},{\"title\":\"M\",\"lists\":[\"马鞍山\",\"茂名\",\"眉山\",\"梅州\",\"绵阳\",\"牡丹江\"]},{\"title\":\"N\",\"lists\":[\"南京\",\"南昌\",\"南宁\",\"宁波\",\"南充\",\"南平\",\"南通\",\"南阳\",\"那曲\",\"内江\",\"宁德\",\"怒江\"]},{\"title\":\"P\",\"lists\":[\"盘锦\",\"攀枝花\",\"平顶山\",\"平凉\",\"萍乡\",\"莆田\",\"濮阳\"]},{\"title\":\"Q\",\"lists\":[\"青岛\",\"黔东南\",\"黔南\",\"黔西南\",\"庆阳\",\"清远\",\"秦皇岛\",\"钦州\",\"齐齐哈尔\",\"泉州\",\"曲靖\",\"衢州\"]},{\"title\":\"R\",\"lists\":[\"日喀则\",\"日照\"]},{\"title\":\"S\",\"lists\":[\"上海\",\"深圳\",\"苏州\",\"沈阳\",\"石家庄\",\"三门峡\",\"三明\",\"三亚\",\"商洛\",\"商丘\",\"上饶\",\"山南\",\"汕头\",\"汕尾\",\"韶关\",\"绍兴\",\"邵阳\",\"十堰\",\"朔州\",\"四平\",\"绥化\",\"遂宁\",\"随州\",\"宿迁\",\"宿州\"]},{\"title\":\"T\",\"lists\":[\"天津\",\"太原\",\"泰安\",\"泰州\",\"台州\",\"唐山\",\"天水\",\"铁岭\",\"铜川\",\"通化\",\"通辽\",\"铜陵\",\"铜仁\",\"台湾\"]},{\"title\":\"W\",\"lists\":[\"武汉\",\"乌鲁木齐\",\"无锡\",\"威海\",\"潍坊\",\"文山\",\"温州\",\"乌海\",\"芜湖\",\"乌兰察布\",\"武威\",\"梧州\"]},{\"title\":\"X\",\"lists\":[\"厦门\",\"西安\",\"西宁\",\"襄阳\",\"湘潭\",\"湘西\",\"咸宁\",\"咸阳\",\"孝感\",\"邢台\",\"新乡\",\"信阳\",\"新余\",\"忻州\",\"西双版纳\",\"宣城\",\"许昌\",\"徐州\",\"香港\",\"锡林郭勒\",\"兴安\"]},{\"title\":\"Y\",\"lists\":[\"银川\",\"雅安\",\"延安\",\"延边\",\"盐城\",\"阳江\",\"阳泉\",\"扬州\",\"烟台\",\"宜宾\",\"宜昌\",\"宜春\",\"营口\",\"益阳\",\"永州\",\"岳阳\",\"榆林\",\"运城\",\"云浮\",\"玉树\",\"玉溪\",\"玉林\"]},{\"title\":\"Z\",\"lists\":[\"杂多县\",\"赞皇县\",\"枣强县\",\"枣阳市\",\"枣庄\",\"泽库县\",\"曾都区\",\"泽普县\",\"泽州县\",\"札达县\",\"扎赉特旗\",\"扎兰屯市\",\"扎鲁特旗\",\"扎囊县\",\"张北县\",\"张店区\",\"章贡区\",\"张家港\",\"张家界\",\"张家口\",\"漳平市\",\"漳浦县\",\"章丘市\",\"樟树市\",\"张湾区\",\"彰武县\",\"漳县\",\"张掖\",\"漳州\",\"长子县\",\"湛河区\",\"湛江\",\"站前区\",\"沾益县\",\"诏安县\",\"召陵区\",\"昭平县\",\"肇庆\",\"昭通\",\"赵县\",\"昭阳区\",\"招远市\",\"肇源县\",\"肇州县\",\"柞水县\",\"柘城县\",\"浙江\",\"镇安县\",\"振安区\",\"镇巴县\",\"正安县\",\"正定县\",\"正蓝旗\",\"正宁县\",\"蒸湘区\",\"正镶白旗\",\"正阳县\",\"郑州\",\"镇海区\",\"镇江\",\"浈江区\",\"镇康县\",\"镇赉县\",\"镇平县\",\"振兴区\",\"镇雄县\",\"镇原县\",\"志丹县\",\"治多县\",\"芝罘区\",\"枝江市\",\"芷江侗族自治县\",\"织金县\",\"中方县\",\"中江县\",\"钟楼区\",\"中牟县\",\"中宁县\",\"中山\",\"中山区\",\"钟山区\",\"钟山县\",\"中卫\",\"钟祥市\",\"中阳县\",\"中原区\",\"周村区\",\"周口\",\"周宁县\",\"舟曲县\",\"舟山\",\"周至县\",\"庄河市\",\"诸城市\",\"珠海\",\"珠晖区\",\"诸暨市\",\"驻马店\",\"准格尔旗\",\"涿鹿县\",\"卓尼\",\"涿州市\",\"卓资县\",\"珠山区\",\"竹山县\",\"竹溪县\",\"株洲\",\"株洲县\",\"淄博\",\"子长县\",\"淄川区\",\"自贡\",\"秭归县\",\"紫金县\",\"自流井区\",\"资溪县\",\"资兴市\",\"资阳\"]}]}";
//        //City city = JSONObject.parseObject
//        City city = JSONUtil.toBean(jsonstr, City.class);
//        NewCity newCity = new NewCity();
//        newCity.setCity(new ArrayList<NewTitle>());
//        for(Title title : city.getCity()) {
//            NewTitle newTitle = new NewTitle();
//            newTitle.setTitle(title.getTitle());
//            newTitle.setLists(new ArrayList<NewData>());
//            for(String str : title.getLists()) {
//                TableResultResponse<SysRegion> sysRegionTableResultResponse = sysRegionBiz.selectByQuery(new Query(new HashMap<String, Object>(){{
//                    put("name", str);
//                }}));
//                NewData newData = new NewData(){{
//                    setId(sysRegionTableResultResponse.getData().getRows().get(0).getId());
//                    setName(sysRegionTableResultResponse.getData().getRows().get(0).getName());
//                }};
////                        builder()
////                        .id(sysRegionTableResultResponse.getData().getRows().get(0).getId()).name(sysRegionTableResultResponse.getData().getRows().get(0).getName()).build();
//                newTitle.getLists().add(newData);
//            }
//            newCity.getCity().add(newTitle);
//        }

        String  strs = "A,阿里,阿尔山,安庆,阿勒泰,安康,鞍山,安顺,阿克苏,阿拉善左旗,阿拉善右旗,中国澳门,B,包头,北海,北京,百色,保山,博乐,毕节,巴彦淖尔,C,长治,池州,长春,常州,昌都,朝阳,常德,长白山,成都,重庆,长沙,赤峰,D,大同,大连,东营,大庆,丹东,大理,敦煌,达州,稻城,E,恩施,鄂尔多斯,二连浩特,额济纳旗,F,佛山,福州,阜阳,抚远,G,贵阳,桂林,广州,广元,格尔木,赣州,固原,高雄,格林岛,H,哈密,呼和浩特,黑河,海拉尔,哈尔滨,海口,黄山,杭州,邯郸,合肥,黄龙,汉中,和田,淮安,花莲,J,鸡西,晋江,锦州,景德镇,嘉峪关,井冈山,济宁,九江,佳木斯,济南,加格达奇,金昌,揭阳,金门,嘉义,K,喀什,昆明,康定,克拉玛依,库尔勒,库车,喀纳斯,凯里,L,兰州,洛阳,丽江,荔波,林芝,柳州,泸州,连云港,黎平,连城,拉萨,临沧,临沂,吕梁,M,芒市,牡丹江,满洲里,绵阳,梅县,漠河,遵义(茅台),马公,马祖,N,南京,南充,南宁,南阳,南通,南昌,那拉提,宁波,南竿,P,攀枝花,普洱,Q,衢州,黔江,秦皇岛,庆阳,且末,齐齐哈尔,青岛,七美,祁连,R,日喀则,S,深圳,石家庄,三亚,沈阳,上海,神农架,T,唐山,铜仁,塔城,腾冲,台州,天水,天津,通辽,吐鲁番,太原,泰州,台北,台中,台南,台东,W,威海,武汉,梧州,文山,无锡,潍坊,武夷山,乌兰浩特,温州,乌鲁木齐,万州,乌海,X,兴义,西昌,厦门,香格里拉,西安,西宁,襄阳(中国),锡林浩特,西双版纳,徐州,中国香港,Y,义乌,永州,榆林,扬州,延安,运城,烟台,银川,宜昌,宜宾,宜春,盐城,延吉,玉树,伊宁,伊春,Z,珠海,昭通,张家界,舟山,郑州,中卫,芷江,湛江,遵义(新舟),遵义(茅台),张掖,张家口";

//        String customRedisTemplaterentTitle;
        NewCity newCity2 = new NewCity();
        newCity2.setCity(new ArrayList<NewTitle>());
        NewTitle currentTitle = null;
        for(String str : strs.split(",")) {
            char c = str.charAt(0);
            if(c >= 'A' && c <= 'Z') {
                if(null != currentTitle) {
                    newCity2.getCity().add(currentTitle);
                }
                currentTitle = new NewTitle();
                currentTitle.setTitle(str);
                currentTitle.setLists(new ArrayList<NewData>());
                continue;
            }else {
//                TableResultResponse<SysRegion> sysRegionTableResultResponse = sysRegionBiz.selectByQuery(new Query(new HashMap<String, Object>(){{
//                    put("name", str);
//                }}));
                List<SysRegion> sysRegions = new ArrayList<SysRegion>();
                for(int i = 1; i < 4; i++) {
                    sysRegions = sysRegionBiz.selectByExample(
                            Example.builder(SysRegion.class).where(
                                    WeekendSqls.<SysRegion>custom().andLike(SysRegion::getName, "%"+ str+ "%").andEqualTo(SysRegion::getType, i)
                            ).build()
                    );
                    if(sysRegions.size() > 0) {
                        break;
                    }
                }

                if(sysRegions.size() > 0) {
                    List<SysRegion> finalSysRegions = sysRegions;
                    NewData newData = new NewData(){{
                        setId(finalSysRegions.get(0).getId());
                        setName(str);
                    }};
//                        builder()
//                        .id(sysRegionTableResultResponse.getData().getRows().get(0).getId()).name(sysRegionTableResultResponse.getData().getRows().get(0).getName()).build();
                    currentTitle.getLists().add(newData);
                }else {
                    NewData newData = new NewData(){{
                        setId(-1L);
                        setName(str);
                    }};
                    currentTitle.getLists().add(newData);
                }
            }
        }

//
//        List<SysRegion> sysRegions = sysRegionBiz.selectCity();
//        String str = new String();
//        str += "{ \n\"city\": [";
//        for(int i = 1;i<=26;i++) {
//            str += "\n{ \"title\": \""+(char)(64+i)+"\", \n";
//            str += "\"lists\":[\n";
//            Boolean flag = false;
//                for(SysRegion sysRegion : sysRegions) {
//                    if(PinyinHelper.getShortPinyin(sysRegion.getName()).substring(0,1).equals(String.valueOf((char)(96+i)))){
//                            //(sysRegion.getName()))
//                        String name = sysRegion.getName();
//                        if("直辖县级".equals(name)) {
//                            //获得父级
//                            SysRegion sysRegionP = sysRegionBiz.selectOne(SysRegion.builder().id(sysRegion.getParentId()).build());
//                            name = sysRegionP.getName();
//                        }
//                        str += "{\"id\":"+sysRegion.getId()+", \"name\":\""+name+"\"},\n";
//                        flag = true;
//                    }
//                }
//            if(flag) {
//                str = StrUtil.sub(str, 0, str.length() - 2);
//            }
//            str += "]";
//            str += "},\n";
//        }
//        str = StrUtil.sub(str, 0, str.length() - 2);
//        str += "] \n }";
//        FileWriter writer = new FileWriter("D://"+ DateUtil.currentSeconds()+ "test.properties");
        FileWriter writer = new FileWriter("/Users/zhoujianwei/opt/xxfc/"+ DateUtil.currentSeconds()+ "test.properties");
//        writer.write(JSONUtil.toJsonStr(newCity));
        writer.write(JSONUtil.toJsonStr(newCity2));
        System.out.println("test");
    }


//    @Test
//    public  void test1() {
//        int i = DateTime.now().getMinuteOfDay() / 5;
//        System.out.println("DateTime.now().getMinuteOfDay() / 5++++++++++++"+i);
//        String redisLockKey = RedisKey.SYS_REGION_REFRESH_LOCK +i;//同一日每5分钟只刷新一次
//        System.out.println("redisLockKey++++++++++++++++"+redisLockKey);
//        String s = String.valueOf(DateTime.now().getMillis());
//        System.out.println("s++++++++++++++++++"+s);
//        Boolean suc = customRedisTemplate.opsForValue().setIfAbsent(redisLockKey, s);
//        Boolean test1 = customRedisTemplate.opsForValue().setIfAbsent("1", "2");
//        Boolean test2 = customRedisTemplate.opsForValue().setIfAbsent("1", "3");
//        System.out.println("test1///////////////////////////////"+test1);
//        System.out.println("test2///////////////////////////////"+test2);
//        System.out.println("suc++++++++++++++++++++"+suc);
//    }
//
//    @Test
//    public  void testRedis() {
//        SysRegion sysRegion = getSysRegion(1);
//        System.out.println("sysRegion+++++++++"+sysRegion);
//        System.out.println("TEST_REDIS_KEY+++++++++++" + TEST_REDIS_KEY);
//    }
//
//    @Cache(key = TEST_REDIS_KEY)
//    private SysRegion getSysRegion(int id){
//        SysRegion sysRegion = sysRegionBiz.selectById(2);
//        return sysRegion;
//    }


//     @Test
//    public void testStream(){
//         List<Integer> integers = Arrays.asList(1, 3, 5, 7, 9, 9);
//         HashSet<Integer> objects = new HashSet<>();
//         objects.addAll(integers);
//         System.out.println(objects);
//         System.out.println("获取最小值");
//         Optional<Integer> min = objects.parallelStream().min(Integer::compareTo);
//         if (min.isPresent()) {
//             System.out.println(min.get());
//         }
//         System.out.println("获取最大");
//         Optional<Integer> max = integers.parallelStream().max(Integer::compareTo);
//         if (max.isPresent()) {
//             System.out.println(max.get());
//         }
//         System.out.println("排序");
//         integers.stream().sorted().forEach(elem -> System.out.println(elem));
//
//         System.out.println("筛选");
//         integers.parallelStream().filter(e ->e>1).filter(e -> e<9).forEach(e -> System.out.println(e));
//         System.out.println("list的总和为");
//         integers.stream().reduce((a,b) -> a+b).ifPresent(System.out::println);
//
//     }


    //@Test
    public void testRegio() {
        String jsonStr = "[{name:\"★热门城市\",cities:[{name:\"北京市\",tags:\"BEIJING,北京市\",cityid:1},{name:\"上海市\",tags:\"SHANGHAI,上海市\",cityid:4},{name:\"深圳市\",tags:\"SHENZHEN,深圳市\",cityid:2},{name:\"广州市\",tags:\"GUANGZHOU,广州市\",cityid:3},{name:\"武汉市\",tags:\"WUHAN,武汉市\",cityid:6}]},{name:\"A\",cities:[{name:\"鞍山市\",tags:\"ANSHAN,鞍山市\",cityid:64},{name:\"安庆市\",tags:\"ANQING,安庆市\",cityid:149},{name:\"安阳市\",tags:\"ANYANG,安阳市\",cityid:174},{name:\"阿拉善盟\",tags:\"ALASHANMENG,阿拉善盟\",cityid:202},{name:\"阿坝州\",tags:\"ABAZHOU,阿坝州\",cityid:290},{name:\"安顺市\",tags:\"ANSHUN,安顺市\",cityid:294},{name:\"阿里地区\",tags:\"ALIDIQU,阿里地区\",cityid:316},{name:\"安康市\",tags:\"ANKANG,安康市\",cityid:320},{name:\"阿克苏地区\",tags:\"AKESUDIQU,阿克苏地区\",cityid:348},{name:\"阿勒泰地区\",tags:\"ALETAIDIQU,阿勒泰地区\",cityid:355},{name:\"阿拉尔市\",tags:\"ALAER,阿拉尔市\",cityid:356}]},{name:\"B\",cities:[{name:\"北京市\",tags:\"BEIJING,北京市\",cityid:1},{name:\"保定市\",tags:\"BAODING,保定市\",cityid:62},{name:\"包头市\",tags:\"BAOTOU,包头市\",cityid:63},{name:\"本溪市\",tags:\"BENXI,本溪市\",cityid:77},{name:\"蚌埠市\",tags:\"BANGBU,蚌埠市\",cityid:100},{name:\"北海市\",tags:\"BEIHAI,北海市\",cityid:161},{name:\"滨州市\",tags:\"BINZHOU,滨州市\",cityid:166},{name:\"宝鸡市\",tags:\"BAOJI,宝鸡市\",cityid:170},{name:\"亳州市\",tags:\"BOZHOU,亳州市\",cityid:189},{name:\"巴彦淖尔市\",tags:\"BAYANNAOER,巴彦淖尔市\",cityid:199},{name:\"白山市\",tags:\"BAISHAN,白山市\",cityid:208},{name:\"白城市\",tags:\"BAICHENG,白城市\",cityid:210},{name:\"百色市\",tags:\"BAISE,百色市\",cityid:263},{name:\"白沙黎族自治县\",tags:\"BAISHALIZUZIZHIXIAN,白沙黎族自治县\",cityid:278},{name:\"巴中市\",tags:\"BAZHONG,巴中市\",cityid:288},{name:\"毕节地区\",tags:\"BIJIEDIQU,毕节地区\",cityid:296},{name:\"保山市\",tags:\"BAOSHAN,保山市\",cityid:301},{name:\"白银市\",tags:\"BAIYIN,白银市\",cityid:323},{name:\"巴音郭楞州\",tags:\"BAYINGUOLENGZHOU,巴音郭楞州\",cityid:350},{name:\"博尔塔拉州\",tags:\"BOERTALAZHOU,博尔塔拉州\",cityid:352}]},{name:\"C\",cities:[{name:\"成都市\",tags:\"CHENGDU,成都市\",cityid:17},{name:\"重庆市\",tags:\"CHONGQING,重庆市\",cityid:18},{name:\"长沙市\",tags:\"CHANGSHA,长沙市\",cityid:24},{name:\"长春市\",tags:\"CHANGCHUN,长春市\",cityid:25},{name:\"常州市\",tags:\"CHANGZHOU,常州市\",cityid:45},{name:\"沧州市\",tags:\"CANGZHOU,沧州市\",cityid:59},{name:\"承德市\",tags:\"CHENGDE,承德市\",cityid:72},{name:\"常德市\",tags:\"CHANGDE,常德市\",cityid:106},{name:\"郴州市\",tags:\"CHENZHOU,郴州市\",cityid:107},{name:\"长治市\",tags:\"CHANGZHI,长治市\",cityid:127},{name:\"滁州市\",tags:\"CHUZHOU,滁州市\",cityid:148},{name:\"池州市\",tags:\"CHIZHOU,池州市\",cityid:187},{name:\"赤峰市\",tags:\"CHIFENG,赤峰市\",cityid:196},{name:\"巢湖市\",tags:\"CHAOHU,巢湖市\",cityid:204},{name:\"朝阳市\",tags:\"CHAOYANG,朝阳市\",cityid:205},{name:\"潮州市\",tags:\"CHAOZHOU,潮州市\",cityid:257},{name:\"崇左市\",tags:\"CHONGZUO,崇左市\",cityid:267},{name:\"澄迈县\",tags:\"CHENGMAIXIAN,澄迈县\",cityid:274},{name:\"楚雄州\",tags:\"CHUXIONGZHOU,楚雄州\",cityid:308},{name:\"昌都地区\",tags:\"CHANGDUDIQU,昌都地区\",cityid:313},{name:\"昌吉州\",tags:\"CHANGJIZHOU,昌吉州\",cityid:351}]},{name:\"D\",cities:[{name:\"大连市\",tags:\"DALIAN,大连市\",cityid:14},{name:\"东莞市\",tags:\"DONGWAN,东莞市\",cityid:21},{name:\"大庆市\",tags:\"DAQING,大庆市\",cityid:48},{name:\"东营市\",tags:\"DONGYING,东营市\",cityid:73},{name:\"德州市\",tags:\"DEZHOU,德州市\",cityid:120},{name:\"大同市\",tags:\"DATONG,大同市\",cityid:125},{name:\"大理州\",tags:\"DALIZHOU,大理州\",cityid:136},{name:\"丹东市\",tags:\"DANDONG,丹东市\",cityid:163},{name:\"德阳市\",tags:\"DEYANG,德阳市\",cityid:173},{name:\"大兴安岭地区\",tags:\"DAXINGANLINGDIQU,大兴安岭地区\",cityid:218},{name:\"儋州市\",tags:\"DANZHOU,儋州市\",cityid:270},{name:\"东方市\",tags:\"DONGFANG,东方市\",cityid:273},{name:\"定安县\",tags:\"DINGANXIAN,定安县\",cityid:275},{name:\"达州市\",tags:\"DAZHOU,达州市\",cityid:285},{name:\"德宏州\",tags:\"DEHONGZHOU,德宏州\",cityid:309},{name:\"迪庆州\",tags:\"DIQINGZHOU,迪庆州\",cityid:311},{name:\"定西市\",tags:\"DINGXI,定西市\",cityid:330}]},{name:\"E\",cities:[{name:\"鄂尔多斯市\",tags:\"EERDUOSI,鄂尔多斯市\",cityid:43},{name:\"鄂州市\",tags:\"EZHOU,鄂州市\",cityid:230},{name:\"恩施州\",tags:\"ENSHIZHOU,恩施州\",cityid:235}]},{name:\"F\",cities:[{name:\"福州市\",tags:\"FUZHOU,福州市\",cityid:34},{name:\"佛山市\",tags:\"FOSHAN,佛山市\",cityid:36},{name:\"抚顺市\",tags:\"FUSHUN,抚顺市\",cityid:66},{name:\"阜新市\",tags:\"FUXIN,阜新市\",cityid:164},{name:\"阜阳市\",tags:\"FUYANG,阜阳市\",cityid:188},{name:\"抚州市\",tags:\"FUZHOU,抚州市\",cityid:223},{name:\"防城港市\",tags:\"FANGCHENGGANG,防城港市\",cityid:260}]},{name:\"G\",cities:[{name:\"广州市\",tags:\"GUANGZHOU,广州市\",cityid:3},{name:\"贵阳市\",tags:\"GUIYANG,贵阳市\",cityid:82},{name:\"赣州市\",tags:\"GANZHOU,赣州市\",cityid:102},{name:\"桂林市\",tags:\"GUILIN,桂林市\",cityid:135},{name:\"贵港市\",tags:\"GUIGANG,贵港市\",cityid:262},{name:\"广元市\",tags:\"GUANGYUAN,广元市\",cityid:280},{name:\"广安市\",tags:\"GUANGAN,广安市\",cityid:284},{name:\"甘孜州\",tags:\"GANZIZHOU,甘孜州\",cityid:291},{name:\"甘南州\",tags:\"GANNANZHOU,甘南州\",cityid:333},{name:\"固原市\",tags:\"GUYUAN,固原市\",cityid:336},{name:\"果洛州\",tags:\"GUOLUOZHOU,果洛州\",cityid:342}]},{name:\"H\",cities:[{name:\"杭州市\",tags:\"HANGZHOU,杭州市\",cityid:5},{name:\"合肥市\",tags:\"HEFEI,合肥市\",cityid:15},{name:\"哈尔滨市\",tags:\"HAERBIN,哈尔滨市\",cityid:16},{name:\"呼和浩特市\",tags:\"HUHEHAOTE,呼和浩特市\",cityid:41},{name:\"邯郸市\",tags:\"HANDAN,邯郸市\",cityid:60},{name:\"葫芦岛市\",tags:\"HULUDAO,葫芦岛市\",cityid:70},{name:\"衡水市\",tags:\"HENGSHUI,衡水市\",cityid:80},{name:\"海口市\",tags:\"HAIKOU,海口市\",cityid:83},{name:\"湖州市\",tags:\"HUZHOU,湖州市\",cityid:90},{name:\"淮安市\",tags:\"HUAIAN,淮安市\",cityid:97},{name:\"衡阳市\",tags:\"HENGYANG,衡阳市\",cityid:105},{name:\"汉中市\",tags:\"HANZHONG,汉中市\",cityid:115},{name:\"菏泽市\",tags:\"HEZE,菏泽市\",cityid:124},{name:\"惠州市\",tags:\"HUIZHOU,惠州市\",cityid:133},{name:\"黄山市\",tags:\"HUANGSHAN,黄山市\",cityid:141},{name:\"淮南市\",tags:\"HUAINAN,淮南市\",cityid:150},{name:\"淮北市\",tags:\"HUAIBEI,淮北市\",cityid:183},{name:\"呼伦贝尔市\",tags:\"HULUNBEIER,呼伦贝尔市\",cityid:198},{name:\"鹤岗市\",tags:\"HEGANG,鹤岗市\",cityid:212},{name:\"黑河市\",tags:\"HEIHE,黑河市\",cityid:217},{name:\"黄石市\",tags:\"HUANGSHI,黄石市\",cityid:227},{name:\"黄冈市\",tags:\"HUANGGANG,黄冈市\",cityid:232},{name:\"怀化市\",tags:\"HUAIHUA,怀化市\",cityid:244},{name:\"鹤壁市\",tags:\"HEBI,鹤壁市\",cityid:247},{name:\"河源市\",tags:\"HEYUAN,河源市\",cityid:254},{name:\"贺州市\",tags:\"HEZHOU,贺州市\",cityid:264},{name:\"河池市\",tags:\"HECHI,河池市\",cityid:265},{name:\"红河州\",tags:\"HONGHEZHOU,红河州\",cityid:306},{name:\"海东地区\",tags:\"HAIDONGDIQU,海东地区\",cityid:338},{name:\"海北州\",tags:\"HAIBEIZHOU,海北州\",cityid:339},{name:\"黄南州\",tags:\"HUANGNANZHOU,黄南州\",cityid:340},{name:\"海南州\",tags:\"HAINANZHOU,海南州\",cityid:341},{name:\"海西州\",tags:\"HAIXIZHOU,海西州\",cityid:344},{name:\"哈密地区\",tags:\"HAMIDIQU,哈密地区\",cityid:346},{name:\"和田地区\",tags:\"HETIANDIQU,和田地区\",cityid:347}]},{name:\"J\",cities:[{name:\"济南市\",tags:\"JINAN,济南市\",cityid:12},{name:\"锦州市\",tags:\"JINZHOU,锦州市\",cityid:68},{name:\"晋中市\",tags:\"JINZHONG,晋中市\",cityid:71},{name:\"吉林市\",tags:\"JILIN,吉林市\",cityid:74},{name:\"济宁市\",tags:\"JINING,济宁市\",cityid:79},{name:\"金华市\",tags:\"JINHUA,金华市\",cityid:86},{name:\"嘉兴市\",tags:\"JIAXING,嘉兴市\",cityid:88},{name:\"九江市\",tags:\"JIUJIANG,九江市\",cityid:101},{name:\"荆州市\",tags:\"JINGZHOU,荆州市\",cityid:109},{name:\"景德镇市\",tags:\"JINGDEZHEN,景德镇市\",cityid:151},{name:\"江门市\",tags:\"JIANGMEN,江门市\",cityid:153},{name:\"揭阳市\",tags:\"JIEYANG,揭阳市\",cityid:154},{name:\"焦作市\",tags:\"JIAOZUO,焦作市\",cityid:175},{name:\"晋城市\",tags:\"JINCHENG,晋城市\",cityid:190},{name:\"鸡西市\",tags:\"JIXI,鸡西市\",cityid:211},{name:\"佳木斯市\",tags:\"JIAMUSI,佳木斯市\",cityid:215},{name:\"吉安市\",tags:\"JIAN,吉安市\",cityid:221},{name:\"荆门市\",tags:\"JINGMEN,荆门市\",cityid:229},{name:\"济源市\",tags:\"JIYUAN,济源市\",cityid:252},{name:\"金昌市\",tags:\"JINCHANG,金昌市\",cityid:322},{name:\"嘉峪关市\",tags:\"JIAYUGUAN,嘉峪关市\",cityid:324},{name:\"酒泉市\",tags:\"JIUQUAN,酒泉市\",cityid:328}]},{name:\"K\",cities:[{name:\"昆明市\",tags:\"KUNMING,昆明市\",cityid:19},{name:\"开封市\",tags:\"KAIFENG,开封市\",cityid:110},{name:\"喀什地区\",tags:\"KASHIDIQU,喀什地区\",cityid:179},{name:\"克拉玛依市\",tags:\"KELAMAYI,克拉玛依市\",cityid:180},{name:\"克孜勒苏柯州\",tags:\"KEZILESUKEZHOU,克孜勒苏柯州\",cityid:349}]},{name:\"L\",cities:[{name:\"洛阳市\",tags:\"LUOYANG,洛阳市\",cityid:27},{name:\"兰州市\",tags:\"LANZHOU,兰州市\",cityid:30},{name:\"廊坊市\",tags:\"LANGFANG,廊坊市\",cityid:46},{name:\"临沂市\",tags:\"LINYI,临沂市\",cityid:58},{name:\"辽阳市\",tags:\"LIAOYANG,辽阳市\",cityid:75},{name:\"连云港市\",tags:\"LIANYUNGANG,连云港市\",cityid:96},{name:\"泸州市\",tags:\"LUZHOU,泸州市\",cityid:117},{name:\"莱芜市\",tags:\"LAIWU,莱芜市\",cityid:122},{name:\"聊城市\",tags:\"LIAOCHENG,聊城市\",cityid:123},{name:\"柳州市\",tags:\"LIUZHOU,柳州市\",cityid:134},{name:\"丽江市\",tags:\"LIJIANG,丽江市\",cityid:137},{name:\"丽水市\",tags:\"LISHUI,丽水市\",cityid:139},{name:\"拉萨市\",tags:\"LASA,拉萨市\",cityid:178},{name:\"六安市\",tags:\"LIUAN,六安市\",cityid:186},{name:\"临汾市\",tags:\"LINFEN,临汾市\",cityid:193},{name:\"吕梁市\",tags:\"LVLIANG,吕梁市\",cityid:194},{name:\"辽源市\",tags:\"LIAOYUAN,辽源市\",cityid:206},{name:\"龙岩市\",tags:\"LONGYAN,龙岩市\",cityid:226},{name:\"娄底市\",tags:\"LOUDI,娄底市\",cityid:245},{name:\"漯河市\",tags:\"LUOHE,漯河市\",cityid:248},{name:\"来宾市\",tags:\"LAIBIN,来宾市\",cityid:266},{name:\"临高县\",tags:\"LINGAOXIAN,临高县\",cityid:277},{name:\"乐山市\",tags:\"LESHAN,乐山市\",cityid:283},{name:\"凉山州\",tags:\"LIANGSHANZHOU,凉山州\",cityid:292},{name:\"六盘水市\",tags:\"LIUPANSHUI,六盘水市\",cityid:293},{name:\"临沧市\",tags:\"LINCANG,临沧市\",cityid:304},{name:\"林芝地区\",tags:\"LINZHIDIQU,林芝地区\",cityid:317},{name:\"陇南市\",tags:\"LONGNAN,陇南市\",cityid:331},{name:\"临夏州\",tags:\"LINXIAZHOU,临夏州\",cityid:332}]},{name:\"M\",cities:[{name:\"绵阳市\",tags:\"MIANYANG,绵阳市\",cityid:50},{name:\"马鞍山市\",tags:\"MAANSHAN,马鞍山市\",cityid:99},{name:\"牡丹江市\",tags:\"MUDANJIANG,牡丹江市\",cityid:129},{name:\"茂名市\",tags:\"MAOMING,茂名市\",cityid:155},{name:\"梅州市\",tags:\"MEIZHOU,梅州市\",cityid:156},{name:\"眉山市\",tags:\"MEISHAN,眉山市\",cityid:286}]},{name:\"N\",cities:[{name:\"南京市\",tags:\"NANJING,南京市\",cityid:11},{name:\"宁波市\",tags:\"NINGBO,宁波市\",cityid:20},{name:\"南宁市\",tags:\"NANNING,南宁市\",cityid:33},{name:\"南昌市\",tags:\"NANCHANG,南昌市\",cityid:38},{name:\"南充市\",tags:\"NANCHONG,南充市\",cityid:53},{name:\"南通市\",tags:\"NANTONG,南通市\",cityid:92},{name:\"南阳市\",tags:\"NANYANG,南阳市\",cityid:113},{name:\"宁德市\",tags:\"NINGDE,宁德市\",cityid:144},{name:\"南平市\",tags:\"NANPING,南平市\",cityid:145},{name:\"内江市\",tags:\"NEIJIANG,内江市\",cityid:282},{name:\"怒江州\",tags:\"NUJIANGZHOU,怒江州\",cityid:310},{name:\"那曲地区\",tags:\"NAQUDIQU,那曲地区\",cityid:312}]},{name:\"P\",cities:[{name:\"平顶山市\",tags:\"PINGDINGSHAN,平顶山市\",cityid:103},{name:\"攀枝花市\",tags:\"PANZHIHUA,攀枝花市\",cityid:119},{name:\"莆田市\",tags:\"PUTIAN,莆田市\",cityid:143},{name:\"盘锦市\",tags:\"PANJIN,盘锦市\",cityid:165},{name:\"濮阳市\",tags:\"PUYANG,濮阳市\",cityid:176},{name:\"萍乡市\",tags:\"PINGXIANG,萍乡市\",cityid:219},{name:\"普洱市\",tags:\"PUER,普洱市\",cityid:303},{name:\"平凉市\",tags:\"PINGLIANG,平凉市\",cityid:327}]},{name:\"Q\",cities:[{name:\"青岛市\",tags:\"QINGDAO,青岛市\",cityid:13},{name:\"泉州市\",tags:\"QUANZHOU,泉州市\",cityid:35},{name:\"秦皇岛市\",tags:\"QINHUANGDAO,秦皇岛市\",cityid:61},{name:\"齐齐哈尔市\",tags:\"QIQIHAER,齐齐哈尔市\",cityid:65},{name:\"曲靖市\",tags:\"QUJING,曲靖市\",cityid:138},{name:\"衢州市\",tags:\"QUZHOU,衢州市\",cityid:140},{name:\"清远市\",tags:\"QINGYUAN,清远市\",cityid:157},{name:\"七台河市\",tags:\"QITAIHE,七台河市\",cityid:216},{name:\"潜江市\",tags:\"QIANJIANG,潜江市\",cityid:238},{name:\"钦州市\",tags:\"QINZHOU,钦州市\",cityid:261},{name:\"琼海市\",tags:\"QIONGHAI,琼海市\",cityid:269},{name:\"黔西南州\",tags:\"QIANXINANZHOU,黔西南州\",cityid:297},{name:\"黔东南州\",tags:\"QIANDONGNANZHOU,黔东南州\",cityid:298},{name:\"黔南州\",tags:\"QIANNANZHOU,黔南州\",cityid:299},{name:\"庆阳市\",tags:\"QINGYANG,庆阳市\",cityid:329}]},{name:\"R\",cities:[{name:\"日照市\",tags:\"RIZHAO,日照市\",cityid:167},{name:\"日喀则地区\",tags:\"RIKAZEDIQU,日喀则地区\",cityid:315}]},{name:\"S\",cities:[{name:\"深圳市\",tags:\"SHENZHEN,深圳市\",cityid:2},{name:\"上海市\",tags:\"SHANGHAI,上海市\",cityid:4},{name:\"沈阳市\",tags:\"SHENYANG,沈阳市\",cityid:8},{name:\"石家庄市\",tags:\"SHIJIAZHUANG,石家庄市\",cityid:22},{name:\"苏州市\",tags:\"SUZHOU,苏州市\",cityid:23},{name:\"三亚市\",tags:\"SANYA,三亚市\",cityid:37},{name:\"绍兴市\",tags:\"SHAOXING,绍兴市\",cityid:89},{name:\"绥化市\",tags:\"SUIHUA,绥化市\",cityid:128},{name:\"四平市\",tags:\"SIPING,四平市\",cityid:130},{name:\"宿迁市\",tags:\"SUQIAN,宿迁市\",cityid:147},{name:\"汕头市\",tags:\"SHANTOU,汕头市\",cityid:158},{name:\"商丘市\",tags:\"SHANGQIU,商丘市\",cityid:177},{name:\"石河子市\",tags:\"SHIHEZI,石河子市\",cityid:181},{name:\"宿州市\",tags:\"SUZHOU,宿州市\",cityid:185},{name:\"朔州市\",tags:\"SHUOZHOU,朔州市\",cityid:191},{name:\"松原市\",tags:\"SONGYUAN,松原市\",cityid:209},{name:\"双鸭山市\",tags:\"SHUANGYASHAN,双鸭山市\",cityid:213},{name:\"上饶市\",tags:\"SHANGRAO,上饶市\",cityid:224},{name:\"三明市\",tags:\"SANMING,三明市\",cityid:225},{name:\"十堰市\",tags:\"SHIYAN,十堰市\",cityid:228},{name:\"随州市\",tags:\"SUIZHOU,随州市\",cityid:234},{name:\"神农架林区\",tags:\"SHENNONGJIALINQU,神农架林区\",cityid:239},{name:\"邵阳市\",tags:\"SHAOYANG,邵阳市\",cityid:240},{name:\"三门峡市\",tags:\"SANMENXIA,三门峡市\",cityid:249},{name:\"韶关市\",tags:\"SHAOGUAN,韶关市\",cityid:253},{name:\"汕尾市\",tags:\"SHANWEI,汕尾市\",cityid:255},{name:\"遂宁市\",tags:\"SUINING,遂宁市\",cityid:281},{name:\"山南地区\",tags:\"SHANNANDIQU,山南地区\",cityid:314},{name:\"商洛市\",tags:\"SHANGLUO,商洛市\",cityid:321},{name:\"石嘴山市\",tags:\"SHIZUISHAN,石嘴山市\",cityid:334}]},{name:\"T\",cities:[{name:\"天津市\",tags:\"TIANJIN,天津市\",cityid:7},{name:\"太原市\",tags:\"TAIYUAN,太原市\",cityid:26},{name:\"唐山市\",tags:\"TANGSHAN,唐山市\",cityid:40},{name:\"铁岭市\",tags:\"TIELING,铁岭市\",cityid:69},{name:\"台州市\",tags:\"TAIZHOU,台州市\",cityid:87},{name:\"泰州市\",tags:\"TAIZHOU,泰州市\",cityid:95},{name:\"泰安市\",tags:\"TAIAN,泰安市\",cityid:121},{name:\"天水市\",tags:\"TIANSHUI,天水市\",cityid:169},{name:\"铜陵市\",tags:\"TONGLING,铜陵市\",cityid:184},{name:\"通辽市\",tags:\"TONGLIAO,通辽市\",cityid:197},{name:\"通化市\",tags:\"TONGHUA,通化市\",cityid:207},{name:\"天门市\",tags:\"TIANMEN,天门市\",cityid:237},{name:\"屯昌县\",tags:\"TUNCHANGXIAN,屯昌县\",cityid:276},{name:\"铜仁地区\",tags:\"TONGRENDIQU,铜仁地区\",cityid:295},{name:\"铜川市\",tags:\"TONGCHUAN,铜川市\",cityid:318},{name:\"吐鲁番地区\",tags:\"TULUFANDIQU,吐鲁番地区\",cityid:345},{name:\"塔城地区\",tags:\"TACHENGDIQU,塔城地区\",cityid:354}]},{name:\"W\",cities:[{name:\"武汉市\",tags:\"WUHAN,武汉市\",cityid:6},{name:\"威海市\",tags:\"WEIHAI,威海市\",cityid:42},{name:\"无锡市\",tags:\"WUXI,无锡市\",cityid:47},{name:\"乌鲁木齐市\",tags:\"WULUMUQI,乌鲁木齐市\",cityid:52},{name:\"潍坊市\",tags:\"WEIFANG,潍坊市\",cityid:81},{name:\"温州市\",tags:\"WENZHOU,温州市\",cityid:85},{name:\"芜湖市\",tags:\"WUHU,芜湖市\",cityid:98},{name:\"乌海市\",tags:\"WUHAI,乌海市\",cityid:195},{name:\"乌兰察布市\",tags:\"WULANCHABU,乌兰察布市\",cityid:200},{name:\"梧州市\",tags:\"WUZHOU,梧州市\",cityid:259},{name:\"五指山市\",tags:\"WUZHISHAN,五指山市\",cityid:268},{name:\"文昌市\",tags:\"WENCHANG,文昌市\",cityid:271},{name:\"万宁市\",tags:\"WANNING,万宁市\",cityid:272},{name:\"文山州\",tags:\"WENSHANZHOU,文山州\",cityid:305},{name:\"渭南市\",tags:\"WEINAN,渭南市\",cityid:319},{name:\"武威市\",tags:\"WUWEI,武威市\",cityid:325},{name:\"吴忠市\",tags:\"WUZHONG,吴忠市\",cityid:335}]},{name:\"X\",cities:[{name:\"西安市\",tags:\"XIAN,西安市\",cityid:10},{name:\"西宁市\",tags:\"XINING,西宁市\",cityid:28},{name:\"厦门市\",tags:\"XIAMEN,厦门市\",cityid:32},{name:\"徐州市\",tags:\"XUZHOU,徐州市\",cityid:39},{name:\"湘潭市\",tags:\"XIANGTAN,湘潭市\",cityid:55},{name:\"邢台市\",tags:\"XINGTAI,邢台市\",cityid:67},{name:\"襄阳市\",tags:\"XIANGYANG,襄阳市\",cityid:108},{name:\"新乡市\",tags:\"XINXIANG,新乡市\",cityid:111},{name:\"许昌市\",tags:\"XUCHANG,许昌市\",cityid:112},{name:\"咸阳市\",tags:\"XIANYANG,咸阳市\",cityid:116},{name:\"新余市\",tags:\"XINYU,新余市\",cityid:152},{name:\"宣城市\",tags:\"XUANCHENG,宣城市\",cityid:182},{name:\"忻州市\",tags:\"XINZHOU,忻州市\",cityid:192},{name:\"锡林郭勒盟\",tags:\"XILINGUOLEMENG,锡林郭勒盟\",cityid:201},{name:\"兴安盟\",tags:\"XINGANMENG,兴安盟\",cityid:203},{name:\"孝感市\",tags:\"XIAOGAN,孝感市\",cityid:231},{name:\"咸宁市\",tags:\"XIANNING,咸宁市\",cityid:233},{name:\"仙桃市\",tags:\"XIANTAO,仙桃市\",cityid:236},{name:\"湘西州\",tags:\"XIANGXIZHOU,湘西州\",cityid:246},{name:\"信阳市\",tags:\"XINYANG,信阳市\",cityid:250},{name:\"西双版纳州\",tags:\"XISHUANGBANNAZHOU,西双版纳州\",cityid:307}]},{name:\"Y\",cities:[{name:\"烟台市\",tags:\"YANTAI,烟台市\",cityid:29},{name:\"银川市\",tags:\"YINCHUAN,银川市\",cityid:49},{name:\"宜昌市\",tags:\"YICHANG,宜昌市\",cityid:51},{name:\"岳阳市\",tags:\"YUEYANG,岳阳市\",cityid:56},{name:\"营口市\",tags:\"YINGKOU,营口市\",cityid:76},{name:\"扬州市\",tags:\"YANGZHOU,扬州市\",cityid:91},{name:\"盐城市\",tags:\"YANCHENG,盐城市\",cityid:94},{name:\"运城市\",tags:\"YUNCHENG,运城市\",cityid:104},{name:\"宜宾市\",tags:\"YIBIN,宜宾市\",cityid:118},{name:\"阳泉市\",tags:\"YANGQUAN,阳泉市\",cityid:126},{name:\"延吉市\",tags:\"YANJI,延吉市\",cityid:131},{name:\"玉林市\",tags:\"YULIN,玉林市\",cityid:162},{name:\"延安市\",tags:\"YANAN,延安市\",cityid:171},{name:\"榆林市\",tags:\"YULIN,榆林市\",cityid:172},{name:\"伊春市\",tags:\"YICHUN,伊春市\",cityid:214},{name:\"鹰潭市\",tags:\"YINGTAN,鹰潭市\",cityid:220},{name:\"宜春市\",tags:\"YICHUN,宜春市\",cityid:222},{name:\"益阳市\",tags:\"YIYANG,益阳市\",cityid:242},{name:\"永州市\",tags:\"YONGZHOU,永州市\",cityid:243},{name:\"阳江市\",tags:\"YANGJIANG,阳江市\",cityid:256},{name:\"云浮市\",tags:\"YUNFU,云浮市\",cityid:258},{name:\"雅安市\",tags:\"YAAN,雅安市\",cityid:287},{name:\"玉溪市\",tags:\"YUXI,玉溪市\",cityid:300},{name:\"玉树州\",tags:\"YUSHUZHOU,玉树州\",cityid:343},{name:\"伊犁州\",tags:\"YILIZHOU,伊犁州\",cityid:353}]},{name:\"Z\",cities:[{name:\"郑州市\",tags:\"ZHENGZHOU,郑州市\",cityid:9},{name:\"遵义市\",tags:\"ZUNYI,遵义市\",cityid:44},{name:\"株洲市\",tags:\"ZHUZHOU,株洲市\",cityid:54},{name:\"淄博市\",tags:\"ZIBO,淄博市\",cityid:57},{name:\"张家口市\",tags:\"ZHANGJIAKOU,张家口市\",cityid:78},{name:\"珠海市\",tags:\"ZHUHAI,珠海市\",cityid:84},{name:\"镇江市\",tags:\"ZHENJIANG,镇江市\",cityid:93},{name:\"周口市\",tags:\"ZHOUKOU,周口市\",cityid:114},{name:\"中山市\",tags:\"ZHONGSHAN,中山市\",cityid:132},{name:\"漳州市\",tags:\"ZHANGZHOU,漳州市\",cityid:142},{name:\"舟山市\",tags:\"ZHOUSHAN,舟山市\",cityid:146},{name:\"湛江市\",tags:\"ZHANJIANG,湛江市\",cityid:159},{name:\"肇庆市\",tags:\"ZHAOQING,肇庆市\",cityid:160},{name:\"枣庄市\",tags:\"ZAOZHUANG,枣庄市\",cityid:168},{name:\"张家界市\",tags:\"ZHANGJIAJIE,张家界市\",cityid:241},{name:\"驻马店市\",tags:\"ZHUMADIAN,驻马店市\",cityid:251},{name:\"自贡市\",tags:\"ZIGONG,自贡市\",cityid:279},{name:\"资阳市\",tags:\"ZIYANG,资阳市\",cityid:289},{name:\"昭通市\",tags:\"ZHAOTONG,昭通市\",cityid:302},{name:\"张掖市\",tags:\"ZHANGYE,张掖市\",cityid:326},{name:\"中卫市\",tags:\"ZHONGWEI,中卫市\",cityid:337}]}]";
        JSONArray jsonArray = JSONUtil.parseArray(jsonStr);

        List<CityData> cityDatas = JSONUtil.toList(jsonArray, CityData.class);
        NewCity newCity2 = new NewCity();
        newCity2.setCity(new ArrayList<NewTitle>());
        for(CityData cityData : cityDatas) {
            char c = cityData.getName().charAt(0);
            if(c >= 'A' && c <= 'Z') {
                NewTitle newTitle = new NewTitle();
                newTitle.setLists(new ArrayList<NewData>());
                for(CityItem cityItem : cityData.getCities()) {
                    List<SysRegion> sysRegions = new ArrayList<SysRegion>();
                    for(int i = 1; i < 4; i++) {
                        sysRegions = sysRegionBiz.selectByExample(
                                Example.builder(SysRegion.class).where(
                                        WeekendSqls.<SysRegion>custom().andLike(SysRegion::getName, "%"+ cityItem.getName()+ "%").andEqualTo(SysRegion::getType, i)
                                ).build()
                        );
                        if(sysRegions.size() > 0) {
                            break;
                        }
                    }

                    NewData newData;
                    if(sysRegions.size() > 0) {
                        List<SysRegion> finalSysRegions = sysRegions;
                        newData = new NewData(){{
                            setId(finalSysRegions.get(0).getId());
                            setName(cityItem.getName());
                        }};
                    }else {
                        newData = new NewData(){{
                            setId(-1L);
                            setName(cityItem.getName());
                        }};
                    }
                    newTitle.getLists().add(newData);
                }
                newCity2.getCity().add(newTitle);
            }
        }
        FileWriter writer = new FileWriter("/Users/zhoujianwei/opt/xxfc/"+ DateUtil.currentSeconds()+ "test.properties");
        writer.write(JSONUtil.toJsonStr(newCity2));
        System.out.println("test");
    }

    @Test
    public void testReg2(){
        StringBuilder sb = new StringBuilder();
        sb.append("[[\"A\",[{\"id\":151,\"name\":\"鞍山\",\"pinyin\":\"anshan\",\"acronym\":\"as\",\"rank\":\"C\",\"firstChar\":\"A\"},{\"id\":197,\"name\":\"安庆\"\"pinyin\":\"anqing\",\"acronym\":\"anqing\",\"rank\":\"D\",\"firstChar\":\"A\"},{\"id\":238,\"name\":\"安阳\",\"pinyin\":\"anyang\",\"acronym\":\"ay\",\"rank\":\"D\",\"firstChar\":\"A\"},{\"id\":324,\"name\":\"安顺\",\"pinyin\":\"anshun\",\"acronym\":\"anshun\",\"rank\":\"E\",\"firstChar\":\"A\"},{\"id\":359,\"name\":\"安康\",\"pinyin\":\"ankang\",\"acronym\":\"ankang\",\"rank\":\"E\",\"firstChar\":\"A\"},{\"id\":588,\"name\":\"安丘\",\"pinyin\":\"anqiu\",\"acronym\":\"aq\",\"rank\":\"E\",\"firstChar\":\"A\"},{\"id\":699,\"name\":\"安岳\",\"pinyin\":\"anyue\",\"acronym\":\"anyue\",\"rank\":\"F\",\"firstChar\":\"A\"},{\"id\":1245,\"name\":\"安陆市\",\"pinyin\":\"anlushi\",\"acronym\":\"anlushi\",\"rank\":\"F\",\"firstChar\":\"A\"},{\"id\":394,\"name\":\"阿克苏\",\"pinyin\":\"akesu\",\"acronym\":\"aks\",\"rank\":\"F\",\"firstChar\":\"A\"},{\"id\":1212,\"name\":\"安州区\",\"pinyin\":\"anzhouqu\",\"acronym\":\"anzhouqu\",\"rank\":\"F\",\"firstChar\":\"A\"},{\"id\":1190,\"name\":\"阿图什市\",\"pinyin\":\"atushishi\",\"acronym\":\"atushishi\",\"rank\":\"F\",\"firstChar\":\"A\"},{\"id\":490,\"name\":\"安吉\",\"pinyin\":\"anji\",\"acronym\":\"aj\",\"rank\":\"F\",\"firstChar\":\"A\"},{\"id\":150,\"name\":\"阿拉善盟\",\"pinyin\":\"alashanmeng\",\"acronym\":\"als\",\"rank\":\"F\",\"firstChar\":\"A\"},{\"id\":1229,\"name\":\"阿荣旗\",\"pinyin\":\"arongqi\",\"acronym\":\"arongqi\",\"rank\":\"F\",\"firstChar\":\"A\"},{\"id\":807,\"name\":\"安平\",\"pinyin\":\"anping\",\"acronym\":\"anping\",\"rank\":\"F\",\"firstChar\":\"A\"},{\"id\":844,\"name\":\"安溪\",\"pinyin\":\"anxi\",\"acronym\":\"anxi\",\"rank\":\"F\",\"firstChar\":\"A\"},{\"id\":873,\"name\":\"安宁\",\"pinyin\":\"anning\",\"acronym\":\"anning\",\"rank\":\"F\",\"firstChar\":\"A\"},{\"id\":1008,\"name\":\"安化\",\"pinyin\":\"anhua\",\"acronym\":\"anhua\",\"rank\":\"F\",\"firstChar\":\"A\"},{\"id\":1016,\"name\":\"阿拉尔\",\"pinyin\":\"alaer\",\"acronym\":\"alaer\",\"rank\":\"F\",\"firstChar\":\"A\"},{\"id\":1068,\"name\":\"安福\",\"pinyin\":\"anfu\",\"acronym\":\"anfu\",\"rank\":\"F\",\"firstChar\":\"A\"},{\"id\":1126,\"name\":\"阿勒泰市\",\"pinyin\":\"aletaishi\",\"acronym\":\"aletaishi\",\"rank\":\"F\",\"firstChar\":\"A\"},{\"id\":1280,\"name\":\"阿城区\",\"pinyin\":\"achengqu\",\"acronym\":\"achengqu\",\"rank\":\"F\",\"firstChar\":\"A\"},{\"id\":402,\"name\":\"澳门\",\"pinyin\":\"aomen\",\"acronym\":\"am\",\"rank\":\"Z\",\"firstChar\":\"A\"},{\"id\":400,\"name\":\"阿勒泰\",\"pinyin\":\"aletai\",\"acronym\":\"alt\",\"rank\":\"Z\",\"firstChar\":\"A\"},{\"id\":350,\"name\":\"阿里\",\"pinyin\":\"ali\",\"acronym\":\"al\",\"rank\":\"Z\",\"firstChar\":\"A\"},{\"id\":319,\"name\":\"阿坝\",\"pinyin\":\"aba\",\"acronym\":\"ab\",\"rank\":\"Z\",\"firstChar\":\"A\"}]],[\"B\",[{\"id\":1,\"name\":\"北京\",\"pinyin\":\"beijing\",\"acronym\":\"bj\",\"rank\":\"S\",\"firstChar\":\"B\"},{\"id\":140,\"name\":\"包头\",\"pinyin\":\"baotou\",\"acronym\":\"bt\",\"rank\":\"C\",\"firstChar\":\"B\"},{\"id\":84,\"name\":\"保定\",\"pinyin\":\"baoding\",\"acronym\":\"bd\",\"rank\":\"C\",\"firstChar\":\"B\"},{\"id\":88,\"name\":\"蚌埠\",\"pinyin\":\"bengbu\",\"acronym\":\"bengbu\",\"rank\":\"D\",\"firstChar\":\"B\"},{\"id\":204,\"name\":\"亳州\",\"pinyin\":\"bozhou\",\"acronym\":\"bozhou\",\"rank\":\"D\",\"firstChar\":\"B\"},{\"id\":233,\"name\":\"滨州\",\"pinyin\":\"binzhou\",\"acronym\":\"bz\",\"rank\":\"D\",\"firstChar\":\"B\"},{\"id\":353,\"name\":\"宝鸡\",\"pinyin\":\"baoji\",\"acronym\":\"baoji\",\"rank\":\"D\",\"firstChar\":\"B\"},{\"id\":167,\"name\":\"白城\",\"pinyin\":\"baicheng\",\"acronym\":\"bc\",\"rank\":\"E\",\"firstChar\":\"B\"},{\"id\":575,\"name\":\"霸州\",\"pinyin\":\"hbbazhou\",\"acronym\":\"hbbazhou\",\"rank\":\"E\",\"firstChar\":\"B\"},{\"id\":146,\"name\":\"巴彦淖尔\",\"pinyin\":\"bayannaoer\",\"acronym\":\"byne\",\"rank\":\"E\",\"firstChar\":\"B\"},{\"id\":292,\"name\":\"北海\",\"pinyin\":\"beihai\",\"acronym\":\"bh\",\"rank\":\"E\",\"firstChar\":\"B\"},{\"id\":297,\"name\":\"百色\",\"pinyin\":\"baise\",\"acronym\":\"baise\",\"rank\":\"E\",\"firstChar\":\"B\"},{\"id\":317,\"name\":\"巴中\",\"pinyin\":\"bazhong\",\"acronym\":\"bazhong\",\"rank\":\"E\",\"firstChar\":\"B\"},{\"id\":327,\"name\":\"毕节\",\"pinyin\":\"bijiediqu\",\"acronym\":\"bijie\",\"rank\":\"E\",\"firstChar\":\"B\"},{\"id\":332,\"name\":\"保山\",\"pinyin\":\"baoshan\",\"acronym\":\"bs\",\"rank\":\"E\",\"firstChar\":\"B\"},{\"id\":153,\"name\":\"本溪\",\"pinyin\":\"benxi\",\"acronym\":\"benxi\",\"rank\":\"E\",\"firstChar\":\"B\"},{\"id\":363,\"name\":\"白银\",\"pinyin\":\"baiyin\",\"acronym\":\"by\",\"rank\":\"E\",\"firstChar\":\"B\"},{\"id\":165,\"name\":\"白山\",\"pinyin\":\"baishan\",\"acronym\":\"baishan\",\"rank\":\"E\",\"firstChar\":\"B\"},{\"id\":946,\"name\":\"璧山\",\"pinyin\":\"bishan\",\"acronym\":\"bishan\",\"rank\":\"F\",\"firstChar\":\"B\"},{\"id\":1278,\"name\":\"拜泉县\",\"pinyin\":\"baiquanxian\",\"acronym\":\"baiquanxian\",\"rank\":\"F\",\"firstChar\":\"B\"},{\"id\":1257,\"name\":\"拜城县\",\"pinyin\":\"baichengxian\",\"acronym\":\"baichengxian\",\"rank\":\"F\",\"firstChar\":\"B\"},{\"id\":602,\"name\":\"宝应\",\"pinyin\":\"baoying\",\"acronym\":\"baoying\",\"rank\":\"F\",\"firstChar\":\"B\"},{\"id\":681,\"name\":\"北流\",\"pinyin\":\"beiliu\",\"acronym\":\"beiliu\",\"rank\":\"F\",\"firstChar\":\"B\"},{\"id\":698,\"name\":\"博爱\",\"pinyin\":\"boai\",\"acronym\":\"boai\",\"rank\":\"F\",\"firstChar\":\"B\"},{\"id\":1237,\"name\":\"巴楚县\",\"pinyin\":\"bachuxian\",\"acronym\":\"bachuxian\",\"rank\":\"F\",\"firstChar\":\"B\"},{\"id\":783,\"name\":\"宝丰\",\"pinyin\":\"baofeng\",\"acronym\":\"baofeng\",\"rank\":\"F\",\"firstChar\":\"B\"},{\"id\":852,\"name\":\"博兴\",\"pinyin\":\"boxing\",\"acronym\":\"boxing\",\"rank\":\"F\",\"firstChar\":\"B\"},{\"id\":887,\"name\":\"泌阳\",\"pinyin\":\"biyang\",\"acronym\":\"biyang\",\"rank\":\"F\",\"firstChar\":\"B\"},{\"id\":915,\"name\":\"彬州市\",\"pinyin\":\"binzhoushi\",\"acronym\":\"binxian\",\"rank\":\"F\",\"firstChar\":\"B\"},{\"id\":1193,\"name\":\"巴彦县\",\"pinyin\":\"bayanxian\",\"acronym\":\"bayanxian\",\"rank\":\"F\",\"firstChar\":\"B\"},{\"id\":952,\"name\":\"博山\",\"pinyin\":\"boshan\",\"acronym\":\"boshan\",\"rank\":\"F\",\"firstChar\":\"B\"},{\"id\":994,\"name\":\"宾阳\",\"pinyin\":\"binyang\",\"acronym\":\"binyang\",\"rank\":\"F\",\"firstChar\":\"B\"},{\"id\":1074,\"name\":\"泊头市\",\"pinyin\":\"botou\",\"acronym\":\"botou\",\"rank\":\"F\",\"firstChar\":\"B\"},{\"id\":1098,\"name\":\"博罗县\",\"pinyin\":\"boluoxian\",\"acronym\":\"boluoxian\",\"rank\":\"F\",\"firstChar\":\"B\"},{\"id\":1102,\"name\":\"博白县\",\"pinyin\":\"bobaixian\",\"acronym\":\"bobaixian\",\"rank\":\"F\",\"firstChar\":\"B\"},{\"id\":1141,\"name\":\"北镇市\",\"pinyin\":\"beizhenshi\",\"acronym\":\"beizhenshi\",\"rank\":\"F\",\"firstChar\":\"B\"},{\"id\":1165,\"name\":\"北安市\",\"pinyin\":\"beianshi\",\"acronym\":\"beianshi\",\"rank\":\"F\",\"firstChar\":\"B\"},{\"id\":533,\"name\":\"滨海\",\"pinyin\":\"binhai\",\"acronym\":\"binhai\",\"rank\":\"Z\",\"firstChar\":\"B\"},{\"id\":731,\"name\":\"北碚\",\"pinyin\":\"beipei\",\"acronym\":\"beipei\",\"rank\":\"Z\",\"firstChar\":\"B\"},{\"id\":392,\"name\":\"博尔塔拉\",\"pinyin\":\"boertala\",\"acronym\":\"betl\",\"rank\":\"Z\",\"firstChar\":\"B\"},{\"id\":393,\"name\":\"巴州\",\"pinyin\":\"bazhou\",\"acronym\":\"baz\",\"rank\":\"Z\",\"firstChar\":\"B\"}]],[\"C\",[{\"id\":45,\"name\":\"重庆\",\"pinyin\":\"chongqing\",\"acronym\":\"cq\",\"rank\":\"A\",\"firstChar\":\"C\"},{\"id\":59,\"name\":\"成都\",\"pinyin\":\"chengdu\",\"acronym\":\"cd\",\"rank\":\"A\",\"firstChar\":\"C\"},{\"id\":89,\"name\":\"常州\",\"pinyin\":\"changzhou\",\"acronym\":\"cz\",\"rank\":\"B\",\"firstChar\":\"C\"},{\"id\":116,\"name\":\"长春\",\"pinyin\":\"changchun\",\"acronym\":\"cc\",\"rank\":\"B\",\"firstChar\":\"C\"},{\"id\":70,\"name\":\"长沙\",\"pinyin\":\"changsha\",\"acronym\":\"chs\",\"rank\":\"B\",\"firstChar\":\"C\"},{\"id\":127,\"name\":\"沧州\",\"pinyin\":\"cangzhou\",\"acronym\":\"cangzhou\",\"rank\":\"D\",\"firstChar\":\"C\"},{\"id\":131,\"name\":\"长治\",\"pinyin\":\"changzhi\",\"acronym\":\"changzhi\",\"rank\":\"D\",\"firstChar\":\"C\"},{\"id\":451,\"name\":\"慈溪\",\"pinyin\":\"cixi\",\"acronym\":\"cixi\",\"rank\":\"D\",\"firstChar\":\"C\"},{\"id\":199,\"name\":\"滁州\",\"pinyin\":\"chuzhou\",\"acronym\":\"chuzhou\",\"rank\":\"D\",\"firstChar\":\"C\"},{\"id\":268,\"name\":\"常德\",\"pinyin\":\"changde\",\"acronym\":\"changde\",\"rank\":\"D\",\"firstChar\":\"C\"},{\"id\":271,\"name\":\"郴州\",\"pinyin\":\"chenzhou\",\"acronym\":\"chenzhou\",\"rank\":\"D\",\"firstChar\":\"C\"},{\"id\":126,\"name\":\"承德\",\"pinyin\":\"chengde\",\"acronym\":\"chengde\",\"rank\":\"D\",\"firstChar\":\"C\"},{\"id\":422,\"name\":\"常熟\",\"pinyin\":\"changshu\",\"acronym\":\"changshu\",\"rank\":\"D\",\"firstChar\":\"C\"},{\"id\":142,\"name\":\"赤峰\",\"pinyin\":\"chifeng\",\"acronym\":\"chifeng\",\"rank\":\"D\",\"firstChar\":\"C\"},{\"id\":1291,\"name\":\"昌江黎族自治县\",\"pinyin\":\"changjianglizuzizhixian\",\"acronym\":\"changjiangxian\",\"rank\":\"E\",\"firstChar\":\"C\"},{\"id\":287,\"name\":\"潮州\",\"pinyin\":\"chaozhou\",\"acronym\":\"chaozhou\",\"rank\":\"E\",\"firstChar\":\"C\"},{\"id\":202,\"name\":\"巢湖\",\"pinyin\":\"chaohu\",\"acronym\":\"ch\",\"rank\":\"E\",\"firstChar\":\"C\"},{\"id\":627,\"name\":\"长葛\",\"pinyin\":\"changge\",\"acronym\":\"cg\",\"rank\":\"E\",\"firstChar\":\"C\"},{\"id\":624,\"name\":\"苍南\",\"pinyin\":\"cangnan\",\"acronym\":\"cangnan\",\"rank\":\"E\",\"firstChar\":\"C\"},{\"id\":527,\"name\":\"昌邑\",\"pinyin\":\"changyi\",\"acronym\":\"changyi\",\"rank\":\"E\",\"firstChar\":\"C\"},{\"id\":421,\"name\":\"从化\",\"pinyin\":\"conghua\",\"acronym\":\"conghua\",\"rank\":\"E\",\"firstChar\":\"C\"},{\"id\":205,\"name\":\"池州\",\"pinyin\":\"chizhou\",\"acronym\":\"chizhou\",\"rank\":\"E\",\"firstChar\":\"C\"},{\"id\":160,\"name\":\"朝阳\",\"pinyin\":\"chaoyang\",\"acronym\":\"cy\",\"rank\":\"E\",\"firstChar\":\"C\"},{\"id\":452,\"name\":\"长兴\",\"pinyin\":\"changxing\",\"acronym\":\"chx\",\"rank\":\"E\",\"firstChar\":\"C\"},{\"id\":909,\"name\":\"城固\",\"pinyin\":\"chenggu\",\"acronym\":\"chenggu\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":463,\"name\":\"长乐\",\"pinyin\":\"changle\",\"acronym\":\"changle\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":1269,\"name\":\"澄迈县\",\"pinyin\":\"chengmaixian\",\"acronym\":\"cmx\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":337,\"name\":\"楚雄\",\"pinyin\":\"chuxiong\",\"acronym\":\"cx\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":646,\"name\":\"崇州\",\"pinyin\":\"chongzhou\",\"acronym\":\"chongzhou\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":301,\"name\":\"崇左\",\"pinyin\":\"chongzuo\",\"acronym\":\"chongzuo\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":660,\"name\":\"淳安\",\"pinyin\":\"chunan\",\"acronym\":\"ca\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":700,\"name\":\"承德县\",\"pinyin\":\"chengdexian\",\"acronym\":\"chengdexian\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":737,\"name\":\"昌乐\",\"pinyin\":\"changlecl\",\"acronym\":\"changlecl\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":746,\"name\":\"曹妃甸\",\"pinyin\":\"caofeidian\",\"acronym\":\"caofeidian\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":767,\"name\":\"磁县\",\"pinyin\":\"cixian\",\"acronym\":\"cixian\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":795,\"name\":\"长垣\",\"pinyin\":\"changyuan\",\"acronym\":\"changyuan\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":798,\"name\":\"成安\",\"pinyin\":\"chengan\",\"acronym\":\"chengan\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":801,\"name\":\"昌黎\",\"pinyin\":\"changli\",\"acronym\":\"changli\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":811,\"name\":\"岑溪\",\"pinyin\":\"cenxi\",\"acronym\":\"cenxi\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":877,\"name\":\"茌平\",\"pinyin\":\"chiping\",\"acronym\":\"chiping\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":883,\"name\":\"曹县\",\"pinyin\":\"caoxian\",\"acronym\":\"caoxian\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":391,\"name\":\"昌吉\",\"pinyin\":\"changji\",\"acronym\":\"changji\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":954,\"name\":\"长汀\",\"pinyin\":\"changting\",\"acronym\":\"changting\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":970,\"name\":\"潮安\",\"pinyin\":\"chaoan\",\"acronym\":\"chaoan\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":981,\"name\":\"长寿\",\"pinyin\":\"changshou\",\"acronym\":\"changshou\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":993,\"name\":\"常山\",\"pinyin\":\"changshan\",\"acronym\":\"changshan\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":1018,\"name\":\"赤水\",\"pinyin\":\"chishui\",\"acronym\":\"chishui\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":1078,\"name\":\"慈利\",\"pinyin\":\"cili\",\"acronym\":\"cili\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":1092,\"name\":\"常宁市\",\"pinyin\":\"changningshi\",\"acronym\":\"changningshi\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":1097,\"name\":\"茶陵\",\"pinyin\":\"chalingxian\",\"acronym\":\"chalingxian\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":1100,\"name\":\"长丰县\",\"pinyin\":\"changfengxian\",\"acronym\":\"changfengxian\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":1150,\"name\":\"苍溪县\",\"pinyin\":\"cangxixian\",\"acronym\":\"cangxixian\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":1157,\"name\":\"长清区\",\"pinyin\":\"changqingqu\",\"acronym\":\"changqingqu\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":1164,\"name\":\"崇明区\",\"pinyin\":\"chongmingqu\",\"acronym\":\"chongmingqu\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":1201,\"name\":\"成武县\",\"pinyin\":\"chengwuxian\",\"acronym\":\"chengwuxian\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":1205,\"name\":\"澄江县\",\"pinyin\":\"chengjiangxian\",\"acronym\":\"chengjiangxian\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":653,\"name\":\"赤壁\",\"pinyin\":\"chibi\",\"acronym\":\"cb\",\"rank\":\"F\",\"firstChar\":\"C\"},{\"id\":346,\"name\":\"昌都\",\"pinyin\":\"changdu\",\"acronym\":\"changdu\",\"rank\":\"Z\",\"firstChar\":\"C\"}]],[\"D\",[{\"id\":65,\"name\":\"大连\",\"pinyin\":\"dalian\",\"acronym\":\"dl\",\"rank\":\"B\",\"firstChar\":\"D\"},{\"id\":91,\"name\":\"东莞\",\"pinyin\":\"dongguan\",\"acronym\":\"dg\",\"rank\":\"B\",\"firstChar\":\"D\"},{\"id\":129,\"name\":\"大同\",\"pinyin\":\"datong\",\"acronym\":\"dt\",\"rank\":\"C\",\"firstChar\":\"D\"},{\"id\":90,\"name\":\"大庆\",\"pinyin\":\"daqing\",\"acronym\":\"dq\",\"rank\":\"C\",\"firstChar\":\"D\"},{\"id\":154,\"name\":\"丹东\",\"pinyin\":\"dandong\",\"acronym\":\"dandong\",\"rank\":\"D\",\"firstChar\":\"D\"},{\"id\":223,\"name\":\"东营\",\"pinyin\":\"dongying\",\"acronym\":\"dy\",\"rank\":\"D\",\"firstChar\":\"D\"},{\"id\":231,\"name\":\"德州\",\"pinyin\":\"dezhou\",\"acronym\":\"dz\",\"rank\":\"D\",\"firstChar\":\"D\"},{\"id\":305,\"name\":\"德阳\",\"pinyin\":\"deyang\",\"acronym\":\"deyang\",\"rank\":\"D\",\"firstChar\":\"D\"},{\"id\":315,\"name\":\"达州\",\"pinyin\":\"dazhou\",\"acronym\":\"dazhou\",\"rank\":\"D\",\"firstChar\":\"D\"},{\"id\":662,\"name\":\"邓州\",\"pinyin\":\"dengzhou\",\"acronym\":\"dengzhou\",\"rank\":\"E\",\"firstChar\":\"D\"},{\"id\":341,\"name\":\"大理\",\"pinyin\":\"dali\",\"acronym\":\"dali\",\"rank\":\"E\",\"firstChar\":\"D\"},{\"id\":599,\"name\":\"大石桥\",\"pinyin\":\"dashiqiao\",\"acronym\":\"dsq\",\"rank\":\"E\",\"firstChar\":\"D\"},{\"id\":576,\"name\":\"都江堰\",\"pinyin\":\"dujiangyan\",\"acronym\":\"djy\",\"rank\":\"E\",\"firstChar\":\"D\"},{\"id\":370,\"name\":\"定西\",\"pinyin\":\"dingxi\",\"acronym\":\"dx\",\"rank\":\"E\",\"firstChar\":\"D\"},{\"id\":431,\"name\":\"丹阳\",\"pinyin\":\"danyang\",\"acronym\":\"danyang\",\"rank\":\"E\",\"firstChar\":\"D\"},{\"id\":571,\"name\":\"儋州\",\"pinyin\":\"danzhou\",\"acronym\":\"danzhou\",\"rank\":\"E\",\"firstChar\":\"D\"},{\"id\":455,\"name\":\"东阳\",\"pinyin\":\"dongyang\",\"acronym\":\"dongyang\",\"rank\":\"E\",\"firstChar\":\"D\"},{\"id\":552,\"name\":\"登封\",\"pinyin\":\"dengfeng\",\"acronym\":\"dengfeng\",\"rank\":\"E\",\"firstChar\":\"D\"},{\"id\":477,\"name\":\"大丰\",\"pinyin\":\"dafeng\",\"acronym\":\"df\",\"rank\":\"E\",\"firstChar\":\"D\"},{\"id\":478,\"name\":\"东台\",\"pinyin\":\"dongtai\",\"acronym\":\"dongtai\",\"rank\":\"E\",\"firstChar\":\"D\"},{\"id\":910,\"name\":\"大竹\",\"pinyin\":\"dazhu\",\"acronym\":\"dazhu\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":491,\"name\":\"当阳\",\"pinyin\":\"dangyang\",\"acronym\":\"dangyang\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":467,\"name\":\"德清\",\"pinyin\":\"deqing\",\"acronym\":\"deqing\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":1275,\"name\":\"东坑镇\",\"pinyin\":\"dongkengzhen\",\"acronym\":\"dongkengzhen\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":1271,\"name\":\"德惠市\",\"pinyin\":\"dehuishi\",\"acronym\":\"dehuishi\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":1268,\"name\":\"大足区\",\"pinyin\":\"dazuqu\",\"acronym\":\"dazuqu\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":600,\"name\":\"大冶\",\"pinyin\":\"daye\",\"acronym\":\"daye\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":635,\"name\":\"东兴\",\"pinyin\":\"dongxing\",\"acronym\":\"dongxing\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":642,\"name\":\"调兵山\",\"pinyin\":\"diaobingshan\",\"acronym\":\"dbs\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":651,\"name\":\"灯塔\",\"pinyin\":\"dengta\",\"acronym\":\"dengta\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":1243,\"name\":\"大悟县\",\"pinyin\":\"dawuxia\",\"acronym\":\"dawuxia\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":679,\"name\":\"大通\",\"pinyin\":\"datongshi\",\"acronym\":\"datongshi\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":686,\"name\":\"东方\",\"pinyin\":\"dongfang\",\"acronym\":\"dongfang\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":738,\"name\":\"东平\",\"pinyin\":\"dongping\",\"acronym\":\"dongping\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":750,\"name\":\"电白\",\"pinyin\":\"dianbai\",\"acronym\":\"dianbai\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":754,\"name\":\"东海\",\"pinyin\":\"donghai\",\"acronym\":\"donghai\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":765,\"name\":\"定州\",\"pinyin\":\"dingzhou\",\"acronym\":\"dingzhou\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":835,\"name\":\"郸城\",\"pinyin\":\"dancheng\",\"acronym\":\"dancheng\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":836,\"name\":\"大荔\",\"pinyin\":\"dalixian\",\"acronym\":\"dalixian\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":874,\"name\":\"达拉特旗\",\"pinyin\":\"dalateqi\",\"acronym\":\"dalateqi\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":539,\"name\":\"东港\",\"pinyin\":\"donggang\",\"acronym\":\"donggang\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":945,\"name\":\"大洼\",\"pinyin\":\"dawa\",\"acronym\":\"dawa\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":971,\"name\":\"大邑\",\"pinyin\":\"dayi\",\"acronym\":\"dayi\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":974,\"name\":\"砀山\",\"pinyin\":\"dangshan\",\"acronym\":\"dangshan\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":978,\"name\":\"敦化\",\"pinyin\":\"dunhua\",\"acronym\":\"dunhua\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":999,\"name\":\"东光\",\"pinyin\":\"dongguang\",\"acronym\":\"dongguang\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":1035,\"name\":\"道县\",\"pinyin\":\"daoxian\",\"acronym\":\"daoxian\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":1076,\"name\":\"大安市\",\"pinyin\":\"daanshi\",\"acronym\":\"daanshi\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":1168,\"name\":\"定安县\",\"pinyin\":\"dinganxian\",\"acronym\":\"dinganxian\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":1177,\"name\":\"垫江\",\"pinyin\":\"dianjiang\",\"acronym\":\"dianjiang\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":1203,\"name\":\"东明县\",\"pinyin\":\"dongmingxian\",\"acronym\":\"dongmingxian\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":1204,\"name\":\"定陶区\",\"pinyin\":\"dingtaoqu\",\"acronym\":\"dingtaoqu\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":1208,\"name\":\"定边县\",\"pinyin\":\"dingbianxian\",\"acronym\":\"dingbianxian\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":1233,\"name\":\"大厂回族自治县\",\"pinyin\":\"dachangzizhixian\",\"acronym\":\"dachangzizhixian\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":1242,\"name\":\"定远县\",\"pinyin\":\"dingyuanxian\",\"acronym\":\"dingyuanxian\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":1285,\"name\":\"东阿县\",\"pinyin\":\"dongexian\",\"acronym\":\"dongexian\",\"rank\":\"F\",\"firstChar\":\"D\"},{\"id\":178,\"name\":\"大兴安岭\",\"pinyin\":\"daxinganling\",\"acronym\":\"dxal\",\"rank\":\"Z\",\"firstChar\":\"D\"},{\"id\":342,\"name\":\"德宏\",\"pinyin\":\"dehong\",\"acronym\":\"dh\",\"rank\":\"Z\",\"firstChar\":\"D\"},{\"id\":344,\"name\":\"迪庆\",\"pinyin\":\"diqing\",\"acronym\":\"diqing\",\"rank\":\"Z\",\"firstChar\":\"D\"},{\"id\":434,\"name\":\"敦煌\",\"pinyin\":\"dunhuang\",\"acronym\":\"dunhuang\",\"rank\":\"Z\",\"firstChar\":\"D\"}]],[\"E\",[{\"id\":144,\"name\":\"鄂尔多斯\",\"pinyin\":\"eerduosi\",\"acronym\":\"erds\",\"rank\":\"E\",\"firstChar\":\"E\"},{\"id\":254,\"name\":\"鄂州\",\"pinyin\":\"ezhou\",\"acronym\":\"ez\",\"rank\":\"E\",\"firstChar\":\"E\"},{\"id\":261,\"name\":\"恩施\",\"pinyin\":\"enshi\",\"acronym\":\"es\",\"rank\":\"E\",\"firstChar\":\"E\"},{\"id\":989,\"name\":\"恩平\",\"pinyin\":\"enping\",\"acronym\":\"enping\",\"rank\":\"E\",\"firstChar\":\"E\"},{\"id\":417,\"name\":\"峨眉山\",\"pinyin\":\"emeishan\",\"acronym\":\"ems\",\"rank\":\"F\",\"firstChar\":\"E\"},{\"id\":1172,\"name\":\"额敏县\",\"pinyin\":\"eminxian\",\"acronym\":\"eminxian\",\"rank\":\"F\",\"firstChar\":\"E\"},{\"id\":568,\"name\":\"额尔古纳\",\"pinyin\":\"eerguna\",\"acronym\":\"eegn\",\"rank\":\"Z\",\"firstChar\":\"E\"}]],[\"F\",[{\"id\":44,\"name\":\"福州\",\"pinyin\":\"fuzhou\",\"acronym\":\"fz\",\"rank\":\"B\",\"firstChar\":\"F\"},{\"id\":92,\"name\":\"佛山\",\"pinyin\":\"foshan\",\"acronym\":\"fs\",\"rank\":\"B\",\"firstChar\":\"F\"},{\"id\":200,\"name\":\"阜阳\",\"pinyin\":\"fuyang\",\"acronym\":\"fy\",\"rank\":\"D\",\"firstChar\":\"F\"},{\"id\":220,\"name\":\"抚州\",\"pinyin\":\"fuzhoufz\",\"acronym\":\"fuz\",\"rank\":\"D\",\"firstChar\":\"F\"},{\"id\":152,\"name\":\"抚顺\",\"pinyin\":\"fushun\",\"acronym\":\"fushun\",\"rank\":\"D\",\"firstChar\":\"F\"},{\"id\":156,\"name\":\"阜新\",\"pinyin\":\"fuxin\",\"acronym\":\"fx\",\"rank\":\"E\",\"firstChar\":\"F\"},{\"id\":427,\"name\":\"涪陵\",\"pinyin\":\"fuling\",\"acronym\":\"fl\",\"rank\":\"E\",\"firstChar\":\"F\"},{\"id\":462,\"name\":\"福清\",\"pinyin\":\"fuqing\",\"acronym\":\"fuqing\",\"rank\":\"E\",\"firstChar\":\"F\"},{\"id\":540,\"name\":\"奉化\",\"pinyin\":\"fenghua\",\"acronym\":\"fenghua\",\"rank\":\"E\",\"firstChar\":\"F\"},{\"id\":545,\"name\":\"肥城\",\"pinyin\":\"feicheng\",\"acronym\":\"fc\",\"rank\":\"E\",\"firstChar\":\"F\"},{\"id\":416,\"name\":\"富阳\",\"pinyin\":\"fuyangfy\",\"acronym\":\"fuyangfy\",\"rank\":\"E\",\"firstChar\":\"F\"},{\"id\":535,\"name\":\"阜宁\",\"pinyin\":\"funing\",\"acronym\":\"fn\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":293,\"name\":\"防城港\",\"pinyin\":\"fangchenggang\",\"acronym\":\"fcg\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":1253,\"name\":\"富民\",\"pinyin\":\"fuminxian\",\"acronym\":\"fuminxian\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":665,\"name\":\"凤城\",\"pinyin\":\"fengcheng\",\"acronym\":\"fengcheng\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":677,\"name\":\"汾阳\",\"pinyin\":\"fenyang\",\"acronym\":\"fenyang\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":689,\"name\":\"阜康\",\"pinyin\":\"fukang\",\"acronym\":\"fukang\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":735,\"name\":\"丰城\",\"pinyin\":\"fch\",\"acronym\":\"fch\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":742,\"name\":\"范县\",\"pinyin\":\"fanxian\",\"acronym\":\"fanxian\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":774,\"name\":\"繁昌\",\"pinyin\":\"fanchang\",\"acronym\":\"fanchang\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":792,\"name\":\"肥乡区\",\"pinyin\":\"feixiangqu\",\"acronym\":\"feixiang\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":827,\"name\":\"封丘\",\"pinyin\":\"fengqiu\",\"acronym\":\"fengqiu\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":861,\"name\":\"扶风\",\"pinyin\":\"fufeng\",\"acronym\":\"fufeng\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":480,\"name\":\"凤凰\",\"pinyin\":\"fenghuang\",\"acronym\":\"fh\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":869,\"name\":\"抚松\",\"pinyin\":\"fusong\",\"acronym\":\"fusong\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":888,\"name\":\"富顺\",\"pinyin\":\"fushunxian\",\"acronym\":\"fushunxian\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":916,\"name\":\"费县\",\"pinyin\":\"feixian\",\"acronym\":\"feixian\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":921,\"name\":\"佛冈\",\"pinyin\":\"fogang\",\"acronym\":\"fogang\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":924,\"name\":\"丰宁\",\"pinyin\":\"fengning\",\"acronym\":\"fengning\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":937,\"name\":\"扶沟\",\"pinyin\":\"fugou\",\"acronym\":\"fugou\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":980,\"name\":\"凤台\",\"pinyin\":\"fengtai\",\"acronym\":\"fengtai\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":1031,\"name\":\"奉新\",\"pinyin\":\"fengxin\",\"acronym\":\"fengxin\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":1052,\"name\":\"方城\",\"pinyin\":\"fangcheng\",\"acronym\":\"fangcheng\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":1066,\"name\":\"富源县\",\"pinyin\":\"fuyuanxian\",\"acronym\":\"fuyuanxian\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":1070,\"name\":\"分宜\",\"pinyin\":\"fenyi\",\"acronym\":\"fenyi\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":1084,\"name\":\"扶绥县\",\"pinyin\":\"fusuixian\",\"acronym\":\"fusuixian\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":1142,\"name\":\"肥西县\",\"pinyin\":\"feixixian\",\"acronym\":\"feixixian\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":1148,\"name\":\"繁峙县\",\"pinyin\":\"fanzhixian\",\"acronym\":\"fanzhixian\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":1152,\"name\":\"凤翔县\",\"pinyin\":\"fengxiangxian\",\"acronym\":\"fengxiangxian\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":1195,\"name\":\"福安\",\"pinyin\":\"fuan\",\"acronym\":\"fuan\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":1202,\"name\":\"福鼎市\",\"pinyin\":\"fudingshi\",\"acronym\":\"fudingshi\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":1209,\"name\":\"府谷县\",\"pinyin\":\"fuguxian\",\"acronym\":\"fuguxian\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":1230,\"name\":\"奉节\",\"pinyin\":\"fengjie\",\"acronym\":\"fengjie\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":1231,\"name\":\"丰都\",\"pinyin\":\"fengdu\",\"acronym\":\"fengdu\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":1241,\"name\":\"肥东县\",\"pinyin\":\"feidongxian\",\"acronym\":\"feidongxian\",\"rank\":\"F\",\"firstChar\":\"F\"},{\"id\":862,\"name\":\"丰县\",\"pinyin\":\"fengxian\",\"acronym\":\"fengxian\",\"rank\":\"F\",\"firstChar\":\"F\"}]],[\"G\",[{\"id\":20,\"name\":\"广州\",\"pinyin\":\"guangzhou\",\"acronym\":\"gz\",\"rank\":\"A\",\"firstChar\":\"G\"},{\"id\":107,\"name\":\"贵阳\",\"pinyin\":\"guiyang\",\"acronym\":\"gy\",\"rank\":\"B\",\"firstChar\":\"G\"},{\"id\":217,\"name\":\"赣州\",\"pinyin\":\"ganzhou\",\"acronym\":\"ganzhou\",\"rank\":\"D\",\"firstChar\":\"G\"},{\"id\":295,\"name\":\"贵港\",\"pinyin\":\"guigang\",\"acronym\":\"gg\",\"rank\":\"D\",\"firstChar\":\"G\"},{\"id\":93,\"name\":\"桂林\",\"pinyin\":\"guilin\",\"acronym\":\"gl\",\"rank\":\"D\",\"firstChar\":\"G\"},{\"id\":314,\"name\":\"广安\",\"pinyin\":\"guangan\",\"acronym\":\"ga\",\"rank\":\"E\",\"firstChar\":\"G\"},{\"id\":631,\"name\":\"高州\",\"pinyin\":\"gaozhou\",\"acronym\":\"gaozhou\",\"rank\":\"E\",\"firstChar\":\"G\"},{\"id\":553,\"name\":\"巩义\",\"pinyin\":\"gongyishi\",\"acronym\":\"gongyishi\",\"rank\":\"E\",\"firstChar\":\"G\"},{\"id\":589,\"name\":\"高密\",\"pinyin\":\"gaomi\",\"acronym\":\"gm\",\"rank\":\"E\",\"firstChar\":\"G\"},{\"id\":629,\"name\":\"高碑店\",\"pinyin\":\"gaobeidian\",\"acronym\":\"gbd\",\"rank\":\"E\",\"firstChar\":\"G\"},{\"id\":307,\"name\":\"广元\",\"pinyin\":\"guangyuan\",\"acronym\":\"guangyuan\",\"rank\":\"E\",\"firstChar\":\"G\"},{\"id\":521,\"name\":\"高邮\",\"pinyin\":\"gaoyou\",\"acronym\":\"gaoyou\",\"rank\":\"E\",\"firstChar\":\"G\"},{\"id\":541,\"name\":\"广饶\",\"pinyin\":\"guangrao\",\"acronym\":\"gr\",\"rank\":\"F\",\"firstChar\":\"G\"},{\"id\":1274,\"name\":\"固安县\",\"pinyin\":\"guanxian\",\"acronym\":\"guanxian\",\"rank\":\"F\",\"firstChar\":\"G\"},{\"id\":570,\"name\":\"桂平\",\"pinyin\":\"guiping\",\"acronym\":\"gp\",\"rank\":\"F\",\"firstChar\":\"G\"},{\"id\":581,\"name\":\"公主岭\",\"pinyin\":\"gongzhuling\",\"acronym\":\"gzl\",\"rank\":\"F\",\"firstChar\":\"G\"},{\"id\":1239,\"name\":\"光山县\",\"pinyin\":\"guangshanxian\",\"acronym\":\"guangshanxian\",\"rank\":\"F\",\"firstChar\":\"G\"},{\"id\":593,\"name\":\"广汉\",\"pinyin\":\"guanghan\",\"acronym\":\"gh\",\"rank\":\"F\",\"firstChar\":\"G\"},{\"id\":595,\"name\":\"藁城\",\"pinyin\":\"gaocheng\",\"acronym\":\"gc\",\"rank\":\"F\",\"firstChar\":\"G\"},{\"id\":601,\"name\":\"高平\",\"pinyin\":\"gaoping\",\"acronym\":\"gaoping\",\"rank\":\"F\",\"firstChar\":\"G\"},{\"id\":1174,\"name\":\"光泽\",\"pinyin\":\"guangze\",\"acronym\":\"guangze\",\"rank\":\"F\",\"firstChar\":\"G\"},{\"id\":385,\"name\":\"固原\",\"pinyin\":\"guyuan\",\"acronym\":\"guyuan\",\"rank\":\"F\",\"firstChar\":\"G\"},{\"id\":1290,\"name\":\"高淳区\",\"pinyin\":\"gaochunqu\",\"acronym\":\"gaochunqu\",\"rank\":\"F\",\"firstChar\":\"G\"},{\"id\":638,\"name\":\"盖州\",\"pinyin\":\"gaizhou\",\"acronym\":\"gaizhou\",\"rank\":\"F\",\"firstChar\":\"G\"},{\"id\":691,\"name\":\"古交\",\"pinyin\":\"gujiao\",\"acronym\":\"gujiao\",\"rank\":\"F\",\"firstChar\":\"G\"},{\"id\":702,\"name\":\"格尔木\",\"pinyin\":\"geermu\",\"acronym\":\"geermu\",\"rank\":\"F\",\"firstChar\":\"G\"},{\"id\":1104,\"name\":\"固始县\",\"pinyin\":\"gushixian\",\"acronym\":\"gushixian\",\"rank\":\"F\",\"firstChar\":\"G\"},{\"id\":751,\"name\":\"灌云\",\"pinyin\":\"guanyun\",\"acronym\":\"guanyun\",\"rank\":\"F\",\"firstChar\":\"G\"},{\"id\":752,\"name\":\"灌南\",\"pinyin\":\"guannan\",\"acronym\":\"guannan\",\"rank\":\"F\",\"firstChar\":\"G\"},{\"id\":753,\"name\":\"赣榆\",\"pinyin\":\"ganyu\",\"acronym\":\"ganyu\",\"rank\":\"F\",\"firstChar\":\"G\"},{\"id\":771,\"name\":\"高安\",\"pinyin\":\"gaoan\",\"acronym\":\"gaoan\",\"rank\":\"F\",\"firstChar\":\"G\"},{\"id\":780,\"name\":\"广德\",\"pinyin\":\"guangde\",\"acronym\":\"guangde\",\"rank\":\"F\",\"firstChar\":\"G\"},{\"id\":787,\"name\":\"共青城\",\"pinyin\":\"gongqingcheng\",\"acronym\":\"gongqingcheng\",\"rank\":\"F\",\"firstChar\":\"G\"},{\"id\":854,\"name\":\"高阳\",\"pinyin\":\"gaoyang\",\"acronym\":\"gaoyang\",\"rank\":\"F\",\"firstChar\":\"G\"},{\"id\":866,\"name\":\"高陵\",\"pinyin\":\"gaoling\",\"acronym\":\"gaoling\",\"rank\":\"F\",\"firstChar\":\"G\"},{\"id\":911,\"name\":\"公安\",\"pinyin\":\"gongan\",\"acronym\":\"gongan\",\"rank\":\"F\",\"firstChar\":\"G\"},{\"id\":630,\"name\":\"个旧\",\"pinyin\":\"gejiu\",\"acronym\":\"gj\",\"rank\":\"F\",\"firstChar\":\"G\"},{\"id\":933,\"name\":\"鼓浪屿\",\"pinyin\":\"gulangyu\",\"acronym\":\"gulangyu\",\"rank\":\"Z\",\"firstChar\":\"G\"},{\"id\":707,\"name\":\"高雄\",\"pinyin\":\"gaoxiong\",\"acronym\":\"gaoxiong\",\"rank\":\"Z\",\"firstChar\":\"G\"},{\"id\":379,\"name\":\"果洛\",\"pinyin\":\"guoluo\",\"acronym\":\"guoluo\",\"rank\":\"Z\",\"firstChar\":\"G\"},{\"id\":373,\"name\":\"甘南\",\"pinyin\":\"gannan\",\"acronym\":\"gn\",\"rank\":\"Z\",\"firstChar\":\"G\"},{\"id\":320,\"name\":\"甘孜\",\"pinyin\":\"ganzi\",\"acronym\":\"ganzi\",\"rank\":\"Z\",\"firstChar\":\"G\"}]],[\"H\",[{\"id\":50,\"name\":\"杭州\",\"pinyin\":\"hangzhou\",\"acronym\":\"hz\",\"rank\":\"A\",\"firstChar\":\"H\"},{\"id\":56,\"name\":\"合肥\",\"pinyin\":\"hefei\",\"acronym\":\"hf\",\"rank\":\"B\",\"firstChar\":\"H\"},{\"id\":105,\"name\":\"哈尔滨\",\"pinyin\":\"haerbin\",\"acronym\":\"hrb\",\"rank\":\"B\",\"firstChar\":\"H\"},{\"id\":265,\"name\":\"衡阳\",\"pinyin\":\"hengyang\",\"acronym\":\"hy\",\"rank\":\"C\",\"firstChar\":\"H\"},{\"id\":123,\"name\":\"邯郸\",\"pinyin\":\"handan\",\"acronym\":\"hd\",\"rank\":\"C\",\"firstChar\":\"H\"},{\"id\":281,\"name\":\"惠州\",\"pinyin\":\"huizhou\",\"acronym\":\"huizhou\",\"rank\":\"C\",\"firstChar\":\"H\"},{\"id\":139,\"name\":\"呼和浩特\",\"pinyin\":\"huhehaote\",\"acronym\":\"hu\",\"rank\":\"C\",\"firstChar\":\"H\"},{\"id\":94,\"name\":\"海口\",\"pinyin\":\"haikou\",\"acronym\":\"haikou\",\"rank\":\"C\",\"firstChar\":\"H\"},{\"id\":186,\"name\":\"湖州\",\"pinyin\":\"huzhou\",\"acronym\":\"huzhou\",\"rank\":\"C\",\"firstChar\":\"H\"},{\"id\":180,\"name\":\"淮安\",\"pinyin\":\"huaian\",\"acronym\":\"ha\",\"rank\":\"C\",\"firstChar\":\"H\"},{\"id\":193,\"name\":\"淮南\",\"pinyin\":\"huainan\",\"acronym\":\"hn\",\"rank\":\"D\",\"firstChar\":\"H\"},{\"id\":234,\"name\":\"菏泽\",\"pinyin\":\"heze\",\"acronym\":\"heze\",\"rank\":\"D\",\"firstChar\":\"H\"},{\"id\":250,\"name\":\"黄石\",\"pinyin\":\"huangshi\",\"acronym\":\"hshi\",\"rank\":\"D\",\"firstChar\":\"H\"},{\"id\":258,\"name\":\"黄冈\",\"pinyin\":\"huanggang\",\"acronym\":\"hg\",\"rank\":\"D\",\"firstChar\":\"H\"},{\"id\":273,\"name\":\"怀化\",\"pinyin\":\"huaihua\",\"acronym\":\"hh\",\"rank\":\"D\",\"firstChar\":\"H\"},{\"id\":128,\"name\":\"衡水\",\"pinyin\":\"hengshui\",\"acronym\":\"hs\",\"rank\":\"D\",\"firstChar\":\"H\"},{\"id\":95,\"name\":\"葫芦岛\",\"pinyin\":\"huludao\",\"acronym\":\"hld\",\"rank\":\"D\",\"firstChar\":\"H\"},{\"id\":299,\"name\":\"河池\",\"pinyin\":\"hechi\",\"acronym\":\"hc\",\"rank\":\"E\",\"firstChar\":\"H\"},{\"id\":198,\"name\":\"黄山\",\"pinyin\":\"huangshan\",\"acronym\":\"huangshan\",\"rank\":\"E\",\"firstChar\":\"H\"},{\"id\":145,\"name\":\"呼伦贝尔\",\"pinyin\":\"hulunbeier\",\"acronym\":\"hlbe\",\"rank\":\"E\",\"firstChar\":\"H\"},{\"id\":176,\"name\":\"黑河\",\"pinyin\":\"heihe\",\"acronym\":\"heihe\",\"rank\":\"E\",\"firstChar\":\"H\"},{\"id\":239,\"name\":\"鹤壁\",\"pinyin\":\"hebi\",\"acronym\":\"hb\",\"rank\":\"E\",\"firstChar\":\"H\"},{\"id\":284,\"name\":\"河源\",\"pinyin\":\"heyuan\",\"acronym\":\"heyuan\",\"rank\":\"E\",\"firstChar\":\"H\"},{\"id\":298,\"name\":\"贺州\",\"pinyin\":\"hezhou\",\"acronym\":\"hezhou\",\"rank\":\"E\",\"firstChar\":\"H\"},{\"id\":170,\"name\":\"鹤岗\",\"pinyin\":\"hegang\",\"acronym\":\"hegang\",\"rank\":\"E\",\"firstChar\":\"H\"},{\"id\":338,\"name\":\"红河\",\"pinyin\":\"honghe\",\"acronym\":\"honghe\",\"rank\":\"E\",\"firstChar\":\"H\"},{\"id\":357,\"name\":\"汉中\",\"pinyin\":\"hanzhong\",\"acronym\":\"hanzhong\",\"rank\":\"E\",\"firstChar\":\"H\"},{\"id\":424,\"name\":\"海宁\",\"pinyin\":\"haining\",\"acronym\":\"haining\",\"rank\":\"E\",\"firstChar\":\"H\"},{\"id\":471,\"name\":\"惠东\",\"pinyin\":\"huidong\",\"acronym\":\"huidong\",\"rank\":\"E\",\"firstChar\":\"H\"},{\"id\":472,\"name\":\"惠阳\",\"pinyin\":\"huiyang\",\"acronym\":\"huiyang\",\"rank\":\"E\",\"firstChar\":\"H\"},{\"id\":506,\"name\":\"海城\",\"pinyin\":\"haicheng\",\"acronym\":\"haicheng\",\"rank\":\"E\",\"firstChar\":\"H\"},{\"id\":519,\"name\":\"海门\",\"pinyin\":\"haimen\",\"acronym\":\"hm\",\"rank\":\"E\",\"firstChar\":\"H\"},{\"id\":573,\"name\":\"海阳\",\"pinyin\":\"haiyang\",\"acronym\":\"haiyang\",\"rank\":\"E\",\"firstChar\":\"H\"},{\"id\":195,\"name\":\"淮北\",\"pinyin\":\"huaibei\",\"acronym\":\"huaibei\",\"rank\":\"E\",\"firstChar\":\"H\"},{\"id\":623,\"name\":\"海安\",\"pinyin\":\"haian\",\"acronym\":\"haian\",\"rank\":\"E\",\"firstChar\":\"H\"},{\"id\":672,\"name\":\"化州\",\"pinyin\":\"huazhou\",\"acronym\":\"huazhou\",\"rank\":\"E\",\"firstChar\":\"H\"},{\"id\":732,\"name\":\"合川\",\"pinyin\":\"hechuan\",\"acronym\":\"hechuan\",\"rank\":\"E\",\"firstChar\":\"H\"},{\"id\":851,\"name\":\"横店\",\"pinyin\":\"hengdian\",\"acronym\":\"hengdian\",\"rank\":\"E\",\"firstChar\":\"H\"},{\"id\":375,\"name\":\"海东\",\"pinyin\":\"haidong\",\"acronym\":\"haidong\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":504,\"name\":\"鹤山\",\"pinyin\":\"heshan\",\"acronym\":\"heshan\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":505,\"name\":\"桦甸\",\"pinyin\":\"huadian\",\"acronym\":\"huadian\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":1221,\"name\":\"桦川县\",\"pinyin\":\"huachuanxian\",\"acronym\":\"huachuanxian\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":1206,\"name\":\"黄陵县\",\"pinyin\":\"huanglingxian\",\"acronym\":\"huanglingxian\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":564,\"name\":\"华阴\",\"pinyin\":\"huayin\",\"acronym\":\"huayin\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":1185,\"name\":\"环县\",\"pinyin\":\"huanxian\",\"acronym\":\"huanxian\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":579,\"name\":\"侯马\",\"pinyin\":\"houma\",\"acronym\":\"houma\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":1145,\"name\":\"合江县\",\"pinyin\":\"hejiangxian\",\"acronym\":\"hejiangxian\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":390,\"name\":\"哈密\",\"pinyin\":\"hami\",\"acronym\":\"hami\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":645,\"name\":\"霍州\",\"pinyin\":\"huozhou\",\"acronym\":\"huozhou\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":650,\"name\":\"黄骅\",\"pinyin\":\"huanghua\",\"acronym\":\"huanghua\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":1130,\"name\":\"海伦市\",\"pinyin\":\"hailunshi\",\"acronym\":\"hailunshi\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":685,\"name\":\"海林\",\"pinyin\":\"hailin\",\"acronym\":\"hl\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":1124,\"name\":\"汉南区\",\"pinyin\":\"hannanqu\",\"acronym\":\"hannanqu\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":1105,\"name\":\"贺兰县\",\"pinyin\":\"helanxian\",\"acronym\":\"helanxian\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":726,\"name\":\"海盐\",\"pinyin\":\"haiyan\",\"acronym\":\"haiyan\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":1234,\"name\":\"横山区\",\"pinyin\":\"hengshanqu\",\"acronym\":\"hengshanqu\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":758,\"name\":\"淮阳\",\"pinyin\":\"huaiyang\",\"acronym\":\"huaiyang\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":772,\"name\":\"汉阴\",\"pinyin\":\"hanyin\",\"acronym\":\"hanyin\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":793,\"name\":\"含山\",\"pinyin\":\"hanshan\",\"acronym\":\"hanshan\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":794,\"name\":\"和县\",\"pinyin\":\"hexian\",\"acronym\":\"hexian\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":799,\"name\":\"户县\",\"pinyin\":\"huxian\",\"acronym\":\"huxian\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":800,\"name\":\"辉县\",\"pinyin\":\"huixian\",\"acronym\":\"huixian\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":806,\"name\":\"怀仁市\",\"pinyin\":\"huairenxian\",\"acronym\":\"huairen\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":816,\"name\":\"滑县\",\"pinyin\":\"huaxian\",\"acronym\":\"huaxian\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":825,\"name\":\"惠安\",\"pinyin\":\"huian\",\"acronym\":\"huian\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":832,\"name\":\"韩城\",\"pinyin\":\"hancheng\",\"acronym\":\"hancheng\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":8001,\"name\":\"华容\",\"pinyin\":\"huarong\",\"acronym\":\"huarong\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":856,\"name\":\"华亭市\",\"pinyin\":\"huatingshi\",\"acronym\":\"huating\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":867,\"name\":\"洪洞\",\"pinyin\":\"hongtong\",\"acronym\":\"hongtong\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":881,\"name\":\"河口\",\"pinyin\":\"hekou\",\"acronym\":\"hekou\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":894,\"name\":\"辉南\",\"pinyin\":\"huinan\",\"acronym\":\"huinan\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":928,\"name\":\"洪湖\",\"pinyin\":\"honghu\",\"acronym\":\"honghu\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":964,\"name\":\"海沧\",\"pinyin\":\"haicang\",\"acronym\":\"haicang\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":975,\"name\":\"霍邱\",\"pinyin\":\"huoqiu\",\"acronym\":\"huoqiu\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":977,\"name\":\"珲春\",\"pinyin\":\"hunchun\",\"acronym\":\"hunchun\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":1005,\"name\":\"怀宁\",\"pinyin\":\"huaining\",\"acronym\":\"huaining\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":1042,\"name\":\"怀远县\",\"pinyin\":\"huaiyuanxian\",\"acronym\":\"huaiyuanxian\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":1065,\"name\":\"会泽县\",\"pinyin\":\"huizexian\",\"acronym\":\"huizexian\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":1080,\"name\":\"河间市\",\"pinyin\":\"hejianshi\",\"acronym\":\"hejianshi\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":1086,\"name\":\"合浦县\",\"pinyin\":\"hepuxian\",\"acronym\":\"hepuxian\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":1088,\"name\":\"衡阳县\",\"pinyin\":\"hengyangxian\",\"acronym\":\"hengyangxian\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":1090,\"name\":\"衡山县\",\"pinyin\":\"hengshanxian\",\"acronym\":\"hengshanxian\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":1091,\"name\":\"衡东县\",\"pinyin\":\"hengdongxian\",\"acronym\":\"hengdongxian\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":1103,\"name\":\"潢川县\",\"pinyin\":\"huangchuanxian\",\"acronym\":\"huangchuanxian\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":598,\"name\":\"河津\",\"pinyin\":\"hejin\",\"acronym\":\"hj\",\"rank\":\"F\",\"firstChar\":\"H\"},{\"id\":712,\"name\":\"恒春\",\"pinyin\":\"hengchun\",\"acronym\":\"hengchun\",\"rank\":\"Z\",\"firstChar\":\"H\"},{\"id\":710,\"name\":\"花莲\",\"pinyin\":\"hualian\",\"acronym\":\"hualian\",\"rank\":\"Z\",\"firstChar\":\"H\"},{\"id\":397,\"name\":\"和田\",\"pinyin\":\"hetian\",\"acronym\":\"ht\",\"rank\":\"Z\",\"firstChar\":\"H\"},{\"id\":381,\"name\":\"海西\",\"pinyin\":\"haixi\",\"acronym\":\"hx\",\"rank\":\"Z\",\"firstChar\":\"H\"},{\"id\":378,\"name\":\"海南州\",\"pinyin\":\"hainanzhou\",\"acronym\":\"hnz\",\"rank\":\"Z\",\"firstChar\":\"H\"},{\"id\":377,\"namef\":\"黄南\",\"pinyin\":\"huangnan\",\"acronym\":\"huangnan\",\"rank\":\"Z\",\"firstChar\":\"H\"},{\"id\":376,\"name\":\"海北\",\"pinyin\":\"haibei\",\"acronym\":\"haibei\",\"rank\":\"Z\",\"firstChar\":\"H\"},{\"id\":118,\"name\":\"香港\",\"pinyin\":\"xianggang\",\"acronym\":\"hk\",\"rank\":\"Z\",\"firstChar\":\"H\"}]],[\"J\",[{\"id\":96,\"name\":\"济南\",\"pinyin\":\"jinan\",\"acronym\":\"jn\",\"rank\":\"B\",\"firstChar\":\"J\"},{\"id\":161,\"name\":\"吉林\",\"pinyin\":\"jilin\",\"acronym\":\"jl\",\"rank\":\"C\",\"firstChar\":\"J\"},{\"id\":404,\"name\":\"江阴\",\"pinyin\":\"jiangyin\",\"acronym\":\"jiangyin\",\"rank\":\"C\",\"firstChar\":\"J\"},{\"id\":185,\"name\":\"嘉兴\",\"pinyin\":\"jiaxing\",\"acronym\":\"jx\",\"rank\":\"C\",\"firstChar\":\"J\"},{\"id\":188,\"name\":\"金华\",\"pinyin\":\"jinhua\",\"acronym\":\"jh\",\"rank\":\"C\",\"firstChar\":\"J\"},{\"id\":277,\"name\":\"江门\",\"pinyin\":\"jiangmen\",\"acronym\":\"jm\",\"rank\":\"C\",\"firstChar\":\"J\"},{\"id\":225,\"name\":\"济宁\",\"pinyin\":\"jining\",\"acronym\":\"jining\",\"rank\":\"C\",\"firstChar\":\"J\"},{\"id\":257,\"name\":\"荆州\",\"pinyin\":\"jingzhou\",\"acronym\":\"jingzhou\",\"rank\":\"C\",\"firstChar\":\"J\"},{\"id\":97,\"name\":\"焦作\",\"pinyin\":\"jiaozuo\",\"acronym\":\"jiaozuo\",\"rank\":\"D\",\"firstChar\":\"J\"},{\"id\":420,\"name\":\"晋江市\",\"pinyin\":\"jinjiangshi\",\"acronym\":\"jinjiang\",\"rank\":\"D\",\"firstChar\":\"J\"},{\"id\":288,\"name\":\"揭阳\",\"pinyin\":\"jieyang\",\"acronym\":\"jy\",\"rank\":\"D\",\"firstChar\":\"J\"},{\"id\":255,\"name\":\"荆门\",\"pinyin\":\"jingmen\",\"acronym\":\"jingmen\",\"rank\":\"D\",\"firstChar\":\"J\"},{\"id\":115,\"name\":\"九江\",\"pinyin\":\"jiujiang\",\"acronym\":\"jj\",\"rank\":\"D\",\"firstChar\":\"J\"},{\"id\":173,\"name\":\"佳木斯\",\"pinyin\":\"jiamusi\",\"acronym\":\"jms\",\"rank\":\"D\",\"firstChar\":\"J\"},{\"id\":98,\"name\":\"锦州\",\"pinyin\":\"jinzhou\",\"acronym\":\"jinzhou\",\"rank\":\"D\",\"firstChar\":\"J\"},{\"id\":460,\"name\":\"金坛\",\"pinyin\":\"jintan\",\"acronym\":\"jintan\",\"rank\":\"E\",\"firstChar\":\"J\"},{\"id\":249,\"name\":\"济源\",\"pinyin\":\"jiyuan\",\"acronym\":\"jiyuan\",\"rank\":\"E\",\"firstChar\":\"J\"},{\"id\":213,\"name\":\"景德镇\",\"pinyin\":\"jingdezhen\",\"acronym\":\"jdz\",\"rank\":\"E\",\"firstChar\":\"J\"},{\"id\":368,\"name\":\"酒泉\",\"pinyin\":\"jiuquan\",\"acronym\":\"jq\",\"rank\":\"E\",\"firstChar\":\"J\"},{\"id\":169,\"name\":\"鸡西\",\"pinyin\":\"jixi\",\"acronym\":\"jixi\",\"rank\":\"E\",\"firstChar\":\"J\"},{\"id\":134,\"name\":\"晋中\",\"pinyin\":\"jinzhong\",\"acronym\":\"jz\",\"rank\":\"E\",\"firstChar\":\"J\"},{\"id\":439,\"name\":\"靖江\",\"pinyin\":\"jingjiang\",\"acronym\":\"jingjiang\",\"rank\":\"E\",\"firstChar\":\"J\"},{\"id\":218,\"name\":\"吉安\",\"pinyin\":\"jian\",\"acronym\":\"ja\",\"rank\":\"E\",\"firstChar\":\"J\"},{\"id\":489,\"name\":\"嘉善\",\"pinyin\":\"jiashan\",\"acronym\":\"js\",\"rank\":\"E\",\"firstChar\":\"J\"},{\"id\":515,\"name\":\"句容\",\"pinyin\":\"jurong\",\"acronym\":\"jr\",\"rank\":\"E\",\"firstChar\":\"J\"},{\"id\":583,\"name\":\"胶州\",\"pinyin\":\"jiaozhou\",\"acronym\":\"jiaozhou\",\"rank\":\"E\",\"firstChar\":\"J\"},{\"id\":664,\"name\":\"即墨\",\"pinyin\":\"jimo\",\"acronym\":\"jimo\",\"rank\":\"E\",\"firstChar\":\"J\"},{\"id\":132,\"name\":\"晋城\",\"pinyin\":\"jincheng\",\"acronym\":\"jincheng\",\"rank\":\"E\",\"firstChar\":\"J\"},{\"id\":948,\"name\":\"江都\",\"pinyin\":\"jiangdu\",\"acronym\":\"jiangdu\",\"rank\":\"E\",\"firstChar\":\"J\"},{\"id\":510,\"name\":\"江山\",\"pinyin\":\"jiangshan\",\"acronym\":\"jiangshan\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":362,\"name\":\"金昌\",\"pinyin\":\"jinchang\",\"acronym\":\"jinchang\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":536,\"name\":\"建湖\",\"pinyin\":\"jianhu\",\"acronym\":\"jianhu\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":544,\"name\":\"晋州\",\"pinyin\":\"jinzhoushi\",\"acronym\":\"jinzhoushi\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":409,\"name\":\"嘉峪关\",\"pinyin\":\"jiayuguan\",\"acronym\":\"jyg\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":594,\"name\":\"建德\",\"pinyin\":\"jiande\",\"acronym\":\"jd\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":605,\"name\":\"简阳\",\"pinyin\":\"jianyang\",\"acronym\":\"jianyang\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":636,\"name\":\"介休\",\"pinyin\":\"jiexiu\",\"acronym\":\"jiexiu\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":1279,\"name\":\"景东彝族自治县\",\"pinyin\":\"jingdongyizuzizhixian\",\"acronym\":\"jingdongyizuzizh\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":1263,\"name\":\"九台\",\"pinyin\":\"jiutai\",\"acronym\":\"jiutai\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":1252,\"name\":\"景谷\",\"pinyin\":\"jingguxian\",\"acronym\":\"jingguxian\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":1197,\"name\":\"靖西市\",\"pinyin\":\"jingxixian\",\"acronym\":\"jingxixian\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":725,\"name\":\"蛟河\",\"pinyin\":\"jiaohe\",\"acronym\":\"jiaohe\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":756,\"name\":\"建阳\",\"pinyin\":\"jianyangjy\",\"acronym\":\"jianyangjy\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":785,\"name\":\"郏县\",\"pinyin\":\"jiaxian\",\"acronym\":\"jiaxian\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":788,\"name\":\"金堂\",\"pinyin\":\"jintang\",\"acronym\":\"jintang\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":831,\"name\":\"监利\",\"pinyin\":\"jianli\",\"acronym\":\"jianli\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":871,\"name\":\"江津\",\"pinyin\":\"jiangjin\",\"acronym\":\"jiangjin\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":882,\"name\":\"巨野\",\"pinyin\":\"juye\",\"acronym\":\"juye\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":899,\"name\":\"嘉祥\",\"pinyin\":\"jiaxiang\",\"acronym\":\"jiaxiang\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":900,\"name\":\"金乡\",\"pinyin\":\"jinxiang\",\"acronym\":\"jinxiang\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":913,\"name\":\"缙云\",\"pinyin\":\"jinyun\",\"acronym\":\"jinyun\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":918,\"name\":\"京山市\",\"pinyin\":\"jingshanshi\",\"acronym\":\"jingshan\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":927,\"name\":\"江油\",\"pinyin\":\"jiangyou\",\"acronym\":\"jiangyou\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":941,\"name\":\"莒南\",\"pinyin\":\"junan\",\"acronym\":\"junan\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":1288,\"name\":\"泾阳县\",\"pinyin\":\"jingyangxian\",\"acronym\":\"jingyangxian\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":956,\"name\":\"金湖\",\"pinyin\":\"jinhu\",\"acronym\":\"jinhu\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":963,\"name\":\"集美\",\"pinyin\":\"jimei\",\"acronym\":\"jimei\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":1001,\"name\":\"金沙\",\"pinyin\":\"jinsha\",\"acronym\":\"jinsha\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":1003,\"name\":\"泾县\",\"pinyin\":\"jingxian\",\"acronym\":\"jingxian\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":1028,\"name\":\"吉安县\",\"pinyin\":\"jianxian\",\"acronym\":\"jianxian\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":1029,\"name\":\"吉水县\",\"pinyin\":\"jishuixian\",\"acronym\":\"jishuixian\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":1032,\"name\":\"江川县\",\"pinyin\":\"jiangchuanxian\",\"acronym\":\"jiangchuanxian\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":1038,\"name\":\"江华瑶族自治县\",\"pinyin\":\"jianghuayaozuzizhixian\",\"acronym\":\"jianghuayaozuziz\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":1059,\"name\":\"晋宁区\",\"pinyin\":\"jinningqu\",\"acronym\":\"jinningxian\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":1061,\"name\":\"江永\",\"pinyin\":\"jiangyong\",\"acronym\":\"jiangyong\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":1085,\"name\":\"建水县\",\"pinyin\":\"jianshuixian\",\"acronym\":\"jianshuixian\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":1134,\"name\":\"鄄城县\",\"pinyin\":\"juanchengxian\",\"acronym\":\"juanchengxian\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":1146,\"name\":\"靖边\",\"pinyin\":\"jingbian\",\"acronym\":\"jingbian\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":1153,\"name\":\"嘉鱼县\",\"pinyin\":\"jiayuxian\",\"acronym\":\"jiayuxian\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":1188,\"name\":\"祁县\",\"pinyin\":\"qixianjz\",\"acronym\":\"jzqixian\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":1194,\"name\":\"精河县\",\"pinyin\":\"jinghexian\",\"acronym\":\"jinghexian\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":678,\"name\":\"集安\",\"pinyin\":\"jianshi\",\"acronym\":\"jianshi\",\"rank\":\"F\",\"firstChar\":\"J\"},{\"id\":719,\"name\":\"嘉义市\",\"pinyin\":\"jiayi\",\"acronym\":\"jiayi\",\"rank\":\"Z\",\"firstChar\":\"J\"},{\"id\":715,\"name\":\"基隆\",\"pinyin\":\"jilong\",\"acronym\":\"jilong\",\"rank\":\"Z\",\"firstChar\":\"J\"},{\"id\":485,\"name\":\"井冈山\",\"pinyin\":\"jinggangshan\",\"acronym\":\"jgs\",\"rank\":\"Z\",\"firstChar\":\"J\"},{\"id\":483,\"name\":\"九寨沟\",\"pinyin\":\"jiuzhaigou\",\"acronym\":\"jzg\",\"rank\":\"Z\",\"firstChar\":\"J\"}]],[\"K\",[{\"id\":114,\"name\":\"昆明\",\"pinyin\":\"kunming\",\"acronym\":\"km\",\"rank\":\"B\",\"firstChar\":\"K\"},{\"id\":403,\"name\":\"昆山\",\"pinyin\":\"kunshan\",\"acronym\":\"kunshan\",\"rank\":\"C\",\"firstChar\":\"K\"},{\"id\":235,\"name\":\"开封\",\"pinyin\":\"kaifeng\",\"acronym\":\"kaifeng\",\"rank\":\"D\",\"firstChar\":\"K\"},{\"id\":388,\"name\":\"克拉玛依\",\"pinyin\":\"kelamayi\",\"acronym\":\"klmy\",\"rank\":\"E\",\"firstChar\":\"K\"},{\"id\":990,\"name\":\"开化\",\"pinyin\":\"kaihua\",\"acronym\":\"kaihua\",\"rank\":\"E\",\"firstChar\":\"K\"},{\"id\":502,\"name\":\"开平\",\"pinyin\":\"kaiping\",\"acronym\":\"kp\",\"rank\":\"E\",\"firstChar\":\"K\"},{\"id\":603,\"name\":\"库尔勒\",\"pinyin\":\"kuerle\",\"acronym\":\"krl\",\"rank\":\"E\",\"firstChar\":\"K\"},{\"id\":1002,\"name\":\"开阳\",\"pinyin\":\"kaiyang\",\"acronym\":\"kaiyang\",\"rank\":\"F\",\"firstChar\":\"K\"},{\"id\":643,\"name\":\"奎屯\",\"pinyin\":\"kuitun\",\"acronym\":\"kt\",\"rank\":\"F\",\"firstChar\":\"K\"},{\"id\":1227,\"name\":\"康县\",\"pinyin\":\"kangxian\",\"acronym\":\"kangxian\",\"rank\":\"F\",\"firstChar\":\"K\"},{\"id\":748,\"name\":\"开州区\",\"pinyin\":\"kaizhouqu\",\"acronym\":\"kaizhouqu\",\"rank\":\"F\",\"firstChar\":\"K\"},{\"id\":880,\"name\":\"垦利\",\"pinyin\":\"kenli\",\"acronym\":\"kenli\",\"rank\":\"F\",\"firstChar\":\"K\"},{\"id\":925,\"name\":\"宽城\",\"pinyin\":\"kuancheng\",\"acronym\":\"kuancheng\",\"rank\":\"F\",\"firstChar\":\"K\"},{\"id\":984,\"name\":\"库车\",\"pinyin\":\"kuche\",\"acronym\":\"kuche\",\"rank\":\"F\",\"firstChar\":\"K\"},{\"id\":473,\"name\":\"凯里\",\"pinyin\":\"kaili\",\"acronym\":\"kl\",\"rank\":\"Z\",\"firstChar\":\"K\"},{\"id\":396,\"name\":\"喀什地区\",\"pinyin\":\"kashi\",\"acronym\":\"ks\",\"rank\":\"Z\",\"firstChar\":\"K\"},{\"id\":395,\"name\":\"克州\",\"pinyin\":\"kezhou\",\"acronym\":\"kz\",\"rank\":\"Z\",\"firstChar\":\"K\"},{\"id\":1238,\"name\":\"垦丁\",\"pinyin\":\"kending\",\"acronym\":\"kending\",\"rank\":\"Z\",\"firstChar\":\"K\"}]],[\"L\",[{\"id\":179,\"name\":\"连云港\",\"pinyin\":\"lianyungang\",\"acronym\":\"lyg\",\"rank\":\"C\",\"firstChar\":\"L\"},{\"id\":230,\"name\":\"临沂\",\"pinyin\":\"linyi\",\"acronym\":\"linyi\",\"rank\":\"C\",\"firstChar\":\"L\"},{\"id\":236,\"name\":\"洛阳\",\"pinyin\":\"luoyang\",\"acronym\":\"luoyang\",\"rank\":\"C\",\"firstChar\":\"L\"},{\"id\":290,\"name\":\"柳州\",\"pinyin\":\"liuzhou\",\"acronym\":\"liuzhou\",\"rank\":\"C\",\"firstChar\":\"L\"},{\"id\":361,\"name\":\"兰州\",\"pinyin\":\"lanzhou\",\"acronym\":\"lz\",\"rank\":\"C\",\"firstChar\":\"L\"},{\"id\":232,\"name\":\"聊城\",\"pinyin\":\"liaocheng\",\"acronym\":\"lc\",\"rank\":\"D\",\"firstChar\":\"L\"},{\"id\":106,\"name\":\"廊坊\",\"pinyin\":\"langfang\",\"acronym\":\"lf\",\"rank\":\"D\",\"firstChar\":\"L\"},{\"id\":157,\"name\":\"辽阳\",\"pinyin\":\"liaoyang\",\"acronym\":\"liaoyang\",\"rank\":\"D\",\"firstChar\":\"L\"},{\"id\":192,\"name\":\"丽水\",\"pinyin\":\"lishui\",\"acronym\":\"lishui\",\"rank\":\"D\",\"firstChar\":\"L\"},{\"id\":203,\"name\":\"六安\",\"pinyin\":\"liuan\",\"acronym\":\"la\",\"rank\":\"D\",\"firstChar\":\"L\"},{\"id\":310,\"name\":\"乐山\",\"pinyin\":\"leshan\",\"acronym\":\"ls\",\"rank\":\"D\",\"firstChar\":\"L\"},{\"id\":345,\"name\":\"拉萨\",\"pinyin\":\"lasa\",\"acronym\":\"lasa\",\"rank\":\"D\",\"firstChar\":\"L\"},{\"id\":211,\"name\":\"龙岩\",\"pinyin\":\"longyan\",\"acronym\":\"ly\",\"rank\":\"D\",\"firstChar\":\"L\"},{\"id\":137,\"name\":\"临汾\",\"pinyin\":\"linfen\",\"acronym\":\"linfen\",\"rank\":\"D\",\"firstChar\":\"L\"},{\"id\":815,\"name\":\"林州\",\"pinyin\":\"linzhou\",\"acronym\":\"linzhou\",\"rank\":\"E\",\"firstChar\":\"L\"},{\"id\":300,\"name\":\"来宾\",\"pinyin\":\"laibin\",\"acronym\":\"lb\",\"rank\":\"E\",\"firstChar\":\"L\"},{\"id\":304,\"name\":\"泸州\",\"pinyin\":\"luzhou\",\"acronym\":\"luzhou\",\"rank\":\"E\",\"firstChar\":\"L\"},{\"id\":163,\"name\":\"辽源\",\"pinyin\":\"liaoyuan\",\"acronym\":\"liaoyuan\",\"rank\":\"E\",\"firstChar\":\"L\"},{\"id\":138,\"name\":\"吕梁\",\"pinyin\":\"lvliang\",\"acronym\":\"lvliang\",\"rank\":\"E\",\"firstChar\":\"L\"},{\"id\":322,\"name\":\"六盘水\",\"pinyin\":\"liupanshui\",\"acronym\":\"lps\",\"rank\":\"E\",\"firstChar\":\"L\"},{\"id\":334,\"name\":\"丽江\",\"pinyin\":\"lijiang\",\"acronym\":\"lj\",\"rank\":\"E\",\"firstChar\":\"L\"},{\"id\":229,\"name\":\"莱芜\",\"pinyin\":\"laiwu\",\"acronym\":\"lw\",\"rank\":\"E\",\"firstChar\":\"L\"},{\"id\":242,\"name\":\"漯河\",\"pinyin\":\"luohe\",\"acronym\":\"luohe\",\"rank\":\"E\",\"firstChar\":\"L\"},{\"id\":450,\"name\":\"溧阳\",\"pinyin\":\"liyang\",\"acronym\":\"liyang\",\"rank\":\"E\",\"firstChar\":\"L\"},{\"id\":461,\"name\":\"临海\",\"pinyin\":\"linhai\",\"acronym\":\"linhai\",\"rank\":\"E\",\"firstChar\":\"L\"},{\"id\":476,\"name\":\"兰溪\",\"pinyin\":\"lanxi\",\"acronym\":\"lx\",\"rank\":\"E\",\"firstChar\":\"L\"},{\"id\":492,\"name\":\"龙口\",\"pinyin\":\"longkou\",\"acronym\":\"lk\",\"rank\":\"E\",\"firstChar\":\"L\"},{\"id\":509,\"name\":\"耒阳\",\"pinyin\":\"leiyang\",\"acronym\":\"leiyang\",\"rank\":\"E\",\"firstChar\":\"L\"},{\"id\":529,\"name\":\"莱州\",\"pinyin\":\"laizhou\",\"acronym\":\"laizhou\",\"rank\":\"E\",\"firstChar\":\"L\"},{\"id\":542,\"name\":\"临安\",\"pinyin\":\"linan\",\"acronym\":\"linan\",\"rank\":\"E\",\"firstChar\":\"L\"},{\"id\":561,\"name\":\"莱阳\",\"pinyin\":\"laiyang\",\"acronym\":\"laiyang\",\"rank\":\"E\",\"firstChar\":\"L\"},{\"id\":567,\"name\":\"陆丰\",\"pinyin\":\"lufeng\",\"acronym\":\"lufeng\",\"rank\":\"E\",\"firstChar\":\"L\"},{\"id\":617,\"name\":\"浏阳\",\"pinyin\":\"liuyang\",\"acronym\":\"liuyang\",\"rank\":\"E\",\"firstChar\":\"L\"},{\"id\":628,\"name\":\"廉江\",\"pinyin\":\"lianjiang\",\"acronym\":\"lianjiang\",\"rank\":\"E\",\"firstChar\":\"L\"},{\"id\":274,\"name\":\"娄底\",\"pinyin\":\"loudi\",\"acronym\":\"ld\",\"rank\":\"E\",\"firstChar\":\"L\"},{\"id\":321,\"name\":\"凉山\",\"pinyin\":\"liangshan\",\"acronym\":\"liangshan\",\"rank\":\"E\",\"firstChar\":\"L\"},{\"id\":1254,\"name\":\"禄劝彝族苗族自治县\",\"pinyin\":\"luquanxian\",\"acronym\":\"luquanxian\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":336,\"name\":\"临沧\",\"pinyin\":\"lincang\",\"acronym\":\"lincang\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1247,\"name\":\"临泉县\",\"pinyin\":\"linquanxian\",\"acronym\":\"linquanxian\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":596,\"name\":\"灵宝\",\"pinyin\":\"lingbao\",\"acronym\":\"lingbao\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":606,\"name\":\"冷水江\",\"pinyin\":\"lengshuijiang\",\"acronym\":\"lsj\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":611,\"name\":\"乐陵\",\"pinyin\":\"laoling\",\"acronym\":\"ll\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":372,\"name\":\"临夏\",\"pinyin\":\"linxia\",\"acronym\":\"linxia\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":618,\"name\":\"龙海\",\"pinyin\":\"longhai\",\"acronym\":\"lh\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":619,\"name\":\"醴陵\",\"pinyin\":\"liling\",\"acronym\":\"liling\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":620,\"name\":\"莱西\",\"pinyin\":\"laixi\",\"acronym\":\"laixi\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":513,\"name\":\"乐昌\",\"pinyin\":\"lechang\",\"acronym\":\"lechang\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":632,\"name\":\"乐平\",\"pinyin\":\"leping\",\"acronym\":\"lp\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":634,\"name\":\"阆中\",\"pinyin\":\"langzhong\",\"acronym\":\"langzhong\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":652,\"name\":\"鹿泉\",\"pinyin\":\"luquan\",\"acronym\":\"luquan\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":655,\"name\":\"利川\",\"pinyin\":\"lichuan\",\"acronym\":\"lichuan\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":659,\"name\":\"老河口\",\"pinyin\":\"laohekou\",\"acronym\":\"lhk\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":670,\"name\":\"凌海\",\"pinyin\":\"linghai\",\"acronym\":\"linghai\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":674,\"name\":\"滦南\",\"pinyin\":\"luannan\",\"acronym\":\"luannan\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":675,\"name\":\"灵山\",\"pinyin\":\"lingshan\",\"acronym\":\"lingshan\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":683,\"name\":\"连州\",\"pinyin\":\"lianzhou\",\"acronym\":\"lianzhou\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":688,\"name\":\"陵水\",\"pinyin\":\"lingshui\",\"acronym\":\"lingshui\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1281,\"name\":\"灵武市\",\"pinyin\":\"lingwushi\",\"acronym\":\"lingwushi\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":724,\"name\":\"连江\",\"pinyin\":\"lianjiangxian\",\"acronym\":\"lianjiangxian\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":739,\"name\":\"临朐\",\"pinyin\":\"linqu\",\"acronym\":\"linqu\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":744,\"name\":\"乐亭\",\"pinyin\":\"laoting\",\"acronym\":\"laoting\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":745,\"name\":\"滦州市\",\"pinyin\":\"luanzhoushi\",\"acronym\":\"luanxian\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":766,\"name\":\"栾城\",\"pinyin\":\"luancheng\",\"acronym\":\"luancheng\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":786,\"name\":\"鲁山\",\"pinyin\":\"lushanls\",\"acronym\":\"lushanls\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":789,\"name\":\"灵石\",\"pinyin\":\"lingshi\",\"acronym\":\"lingshi\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":791,\"name\":\"临漳\",\"pinyin\":\"linzhang\",\"acronym\":\"linzhang\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":808,\"name\":\"临潼\",\"pinyin\":\"lintong\",\"acronym\":\"lintong\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":809,\"name\":\"蓝田\",\"pinyin\":\"lantian\",\"acronym\":\"lantian\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":537,\"name\":\"临清\",\"pinyin\":\"linqing\",\"acronym\":\"lq\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":823,\"name\":\"隆昌市\",\"pinyin\":\"longchangshi\",\"acronym\":\"longchang\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":839,\"name\":\"鹿邑\",\"pinyin\":\"luyi\",\"acronym\":\"luyi\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":868,\"name\":\"柳河\",\"pinyin\":\"liuhe\",\"acronym\":\"liuhe\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":889,\"name\":\"临猗\",\"pinyin\":\"linyixian\",\"acronym\":\"linyixian\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":896,\"name\":\"梁山\",\"pinyin\":\"liangshanxian\",\"acronym\":\"liangshanxian\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":902,\"name\":\"利津\",\"pinyin\":\"lijin\",\"acronym\":\"lijin\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":905,\"name\":\"临邑\",\"pinyin\":\"linyily\",\"acronym\":\"linyily\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":912,\"name\":\"龙泉\",\"pinyin\":\"longquan\",\"acronym\":\"longquan\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":919,\"name\":\"陵川\",\"pinyin\":\"lingchuan\",\"acronym\":\"lingchuan\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":930,\"name\":\"隆尧\",\"pinyin\":\"longyao\",\"acronym\":\"longyao\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":934,\"name\":\"雷州\",\"pinyin\":\"leizhou\",\"acronym\":\"leizhou\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":935,\"name\":\"栾川\",\"pinyin\":\"luanchuan\",\"acronym\":\"luanchuan\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":938,\"name\":\"龙游\",\"pinyin\":\"longyou\",\"acronym\":\"longyou\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":939,\"name\":\"兰陵\",\"pinyin\":\"lanling\",\"acronym\":\"lanling\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":951,\"name\":\"临沭\",\"pinyin\":\"linshu\",\"acronym\":\"linshu\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":976,\"name\":\"涟水\",\"pinyin\":\"lianshui\",\"acronym\":\"lianshui\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1010,\"name\":\"澧县\",\"pinyin\":\"lixian\",\"acronym\":\"lixian\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1011,\"name\":\"辽中\",\"pinyin\":\"liaozhong\",\"acronym\":\"liaozhong\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1034,\"name\":\"罗平县\",\"pinyin\":\"luopingxian\",\"acronym\":\"luopingxian\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1037,\"name\":\"涟源市\",\"pinyin\":\"lianyuanshi\",\"acronym\":\"lianyuanshi\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1040,\"name\":\"庐江县\",\"pinyin\":\"lujiangxian\",\"acronym\":\"lujiangxian\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1056,\"name\":\"临颍\",\"pinyin\":\"linying\",\"acronym\":\"linying\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1060,\"name\":\"蓝山\",\"pinyin\":\"lanshan\",\"acronym\":\"lanshan\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1064,\"name\":\"隆回\",\"pinyin\":\"longhui\",\"acronym\":\"longhui\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1073,\"name\":\"芦溪\",\"pinyin\":\"luxi\",\"acronym\":\"luxi\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1079,\"name\":\"卢氏县\",\"pinyin\":\"lushixian\",\"acronym\":\"lushixian\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1083,\"name\":\"隆化县\",\"pinyin\":\"longhuaxian\",\"acronym\":\"longhuaxian\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1087,\"name\":\"洛宁\",\"pinyin\":\"luoningxian\",\"acronym\":\"luoningxian\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1110,\"name\":\"兰考县\",\"pinyin\":\"lankaoxian\",\"acronym\":\"lankaoxian\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1119,\"name\":\"临澧\",\"pinyin\":\"linli\",\"acronym\":\"linli\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1121,\"name\":\"利辛\",\"pinyin\":\"lixin\",\"acronym\":\"lixin\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1133,\"name\":\"灵丘县\",\"pinyin\":\"lingqiuxian\",\"acronym\":\"lingqiuxian\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1138,\"name\":\"禄丰县\",\"pinyin\":\"lufengxian\",\"acronym\":\"lufengxian\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1143,\"name\":\"溧水区\",\"pinyin\":\"lishuiqu\",\"acronym\":\"lishuiqu\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1144,\"name\":\"泸县\",\"pinyin\":\"luxian\",\"acronym\":\"luxian\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1147,\"name\":\"洛川县\",\"pinyin\":\"luochuanxian\",\"acronym\":\"luochuanxian\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1163,\"name\":\"罗定市\",\"pinyin\":\"luodingshi\",\"acronym\":\"luodingshi\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1171,\"name\":\"乐东\",\"pinyin\":\"ledong\",\"acronym\":\"ledong\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1178,\"name\":\"梁平\",\"pinyin\":\"liangping\",\"acronym\":\"liangping\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1183,\"name\":\"临高县\",\"pinyin\":\"lingaoxian\",\"acronym\":\"lingaoxian\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1184,\"name\":\"罗源县\",\"pinyin\":\"luoyuanxian\",\"acronym\":\"luoyuanxian\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":1225,\"name\":\"陆川县\",\"pinyin\":\"luchuanxian\",\"acronym\":\"luchuanxian\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":690,\"name\":\"临江\",\"pinyin\":\"linjiang\",\"acronym\":\"linjiang\",\"rank\":\"F\",\"firstChar\":\"L\"},{\"id\":371,\"name\":\"陇南\",\"pinyin\":\"longnan\",\"acronym\":\"ln\",\"rank\":\"Z\",\"firstChar\":\"L\"},{\"id\":351,\"name\":\"林芝\",\"pinyin\":\"linzhi\",\"acronym\":\"linzhi\",\"rank\":\"Z\",\"firstChar\":\"L\"}]],[\"M\",[{\"id\":306,\"name\":\"绵阳\",\"pinyin\":\"mianyang\",\"acronym\":\"my\",\"rank\":\"C\",\"firstChar\":\"M\"},{\"id\":175,\"name\":\"牡丹江\",\"pinyin\":\"mudanjiang\",\"acronym\":\"mdj\",\"rank\":\"D\",\"firstChar\":\"M\"},{\"id\":279,\"name\":\"茂名\",\"pinyin\":\"maoming\",\"acronym\":\"mm\",\"rank\":\"D\",\"firstChar\":\"M\"},{\"id\":194,\"name\":\"马鞍山\",\"pinyin\":\"maanshan\",\"acronym\":\"mas\",\"rank\":\"D\",\"firstChar\":\"M\"},{\"id\":282,\"name\":\"梅州\",\"pinyin\":\"meizhou\",\"acronym\":\"mz\",\"rank\":\"E\",\"firstChar\":\"M\"},{\"id\":312,\"name\":\"眉山\",\"pinyin\":\"meishan\",\"acronym\":\"ms\",\"rank\":\"E\",\"firstChar\":\"M\"},{\"id\":1283,\"name\":\"门头沟区\",\"pinyin\":\"mentougouqu\",\"acronym\":\"mentougouqu\",\"rank\":\"F\",\"firstChar\":\"M\"},{\"id\":566,\"name\":\"密山\",\"pinyin\":\"mishan\",\"acronym\":\"mishan\",\"rank\":\"F\",\"firstChar\":\"M\"},{\"id\":572,\"name\":\"满洲里\",\"pinyin\":\"manzhouli\",\"acronym\":\"mzl\",\"rank\":\"F\",\"firstChar\":\"M\"},{\"id\":584,\"name\":\"梅河口\",\"pinyin\":\"meihekou\",\"acronym\":\"mhk\",\"rank\":\"F\",\"firstChar\":\"M\"},{\"id\":590,\"name\":\"汨罗\",\"pinyin\":\"miluo\",\"acronym\":\"ml\",\"rank\":\"F\",\"firstChar\":\"M\"},{\"id\":610,\"name\":\"明光\",\"pinyin\":\"mingguang\",\"acronym\":\"mg\",\"rank\":\"F\",\"firstChar\":\"M\"},{\"id\":668,\"name\":\"麻城\",\"pinyin\":\"macheng\",\"acronym\":\"mc\",\"rank\":\"F\",\"firstChar\":\"M\"},{\"id\":694,\"name\":\"孟州\",\"pinyin\":\"mengzhou\",\"acronym\":\"mengzhou\",\"rank\":\"F\",\"firstChar\":\"M\"},{\"id\":1222,\"name\":\"明水县\",\"pinyin\":\"mingshuixian\",\"acronym\":\"mingshuixian\",\"rank\":\"F\",\"firstChar\":\"M\"},{\"id\":838,\"name\":\"孟津\",\"pinyin\":\"mengjin\",\"acronym\":\"mengjin\",\"rank\":\"F\",\"firstChar\":\"M\"},{\"id\":846,\"name\":\"牟平\",\"pinyin\":\"muping\",\"acronym\":\"muping\",\"rank\":\"F\",\"firstChar\":\"M\"},{\"id\":848,\"name\":\"眉县\",\"pinyin\":\"meixian\",\"acronym\":\"meixian\",\"rank\":\"F\",\"firstChar\":\"M\"},{\"id\":860,\"name\":\"民权\",\"pinyin\":\"minquan\",\"acronym\":\"minquan\",\"rank\":\"F\",\"firstChar\":\"M\"},{\"id\":872,\"name\":\"渑池\",\"pinyin\":\"mianchi\",\"acronym\":\"mianchi\",\"rank\":\"F\",\"firstChar\":\"M\"},{\"id\":906,\"name\":\"绵竹\",\"pinyin\":\"mianzhu\",\"acronym\":\"mianzhu\",\"rank\":\"F\",\"firstChar\":\"M\"},{\"id\":944,\"name\":\"蒙阴\",\"pinyin\":\"mengyin\",\"acronym\":\"mengyin\",\"rank\":\"F\",\"firstChar\":\"M\"},{\"id\":1116,\"name\":\"蒙自市\",\"pinyin\":\"mengzishi\",\"acronym\":\"mengzishi\",\"rank\":\"F\",\"firstChar\":\"M\"},{\"id\":1122,\"name\":\"蒙城\",\"pinyin\":\"mengcheng\",\"acronym\":\"mengcheng\",\"rank\":\"F\",\"firstChar\":\"M\"},{\"id\":1210,\"name\":\"勐腊县\",\"pinyin\":\"menglaxian\",\"acronym\":\"menglaxian\",\"rank\":\"F\",\"firstChar\":\"M\"},{\"id\":1216,\"name\":\"米易县\",\"pinyin\":\"miyixian\",\"acronym\":\"miyixian\",\"rank\":\"F\",\"firstChar\":\"M\"},{\"id\":1219,\"name\":\"闽侯县\",\"pinyin\":\"minhouxian\",\"acronym\":\"minhouxian\",\"rank\":\"F\",\"firstChar\":\"M\"},{\"id\":713,\"name\":\"苗栗\",\"pinyin\":\"miaoli\",\"acronym\":\"miaoli\",\"rank\":\"Z\",\"firstChar\":\"M\"},{\"id\":563,\"name\":\"漠河\",\"pinyin\":\"mohe\",\"acronym\":\"mh\",\"rank\":\"Z\",\"firstChar\":\"M\"},{\"id\":8000,\"name\":\"冥王星\",\"pinyin\":\"mingwangxing\",\"acronym\":\"mingwangxing\",\"rank\":\"Z\",\"firstChar\":\"M\"}]]");

        sb.append(",[\"N\",[{\"id\":55,\"name\":\"南京\",\"pinyin\":\"nanjing\",\"acronym\":\"nj\",\"rank\":\"A\",\"firstChar\":\"N\"},{\"id\":51,\"name\":\"宁波\",\"pinyin\":\"ningbo\",\"acronym\":\"nb\",\"rank\":\"B\",\"firstChar\":\"N\"},{\"id\":99,\"name\":\"南宁\",\"pinyin\":\"nanning\",\"acronym\":\"nn\",\"rank\":\"B\",\"firstChar\":\"N\"},{\"id\":83,\"name\":\"南昌\",\"pinyin\":\"nanchang\",\"acronym\":\"nc\",\"rank\":\"C\",\"firstChar\":\"N\"},{\"id\":82,\"name\":\"南通\",\"pinyin\":\"nantong\",\"acronym\":\"nt\",\"rank\":\"C\",\"firstChar\":\"N\"},{\"id\":244,\"name\":\"南阳\",\"pinyin\":\"nanyang\",\"acronym\":\"ny\",\"rank\":\"C\",\"firstChar\":\"N\"},{\"id\":212,\"name\":\"宁德\",\"pinyin\":\"ningde\",\"acronym\":\"nd\",\"rank\":\"D\",\"firstChar\":\"N\"},{\"id\":311,\"name\":\"南充\",\"pinyin\":\"nanchong\",\"acronym\":\"nanchong\",\"rank\":\"D\",\"firstChar\":\"N\"},{\"id\":210,\"name\":\"南平\",\"pinyin\":\"nanping\",\"acronym\":\"np\",\"rank\":\"E\",\"firstChar\":\"N\"},{\"id\":309,\"name\":\"内江\",\"pinyin\":\"neijiang\",\"acronym\":\"scnj\",\"rank\":\"E\",\"firstChar\":\"N\"},{\"id\":512,\"name\":\"宁海\",\"pinyin\":\"ninghai\",\"acronym\":\"nh\",\"rank\":\"E\",\"firstChar\":\"N\"},{\"id\":621,\"name\":\"南安\",\"pinyin\":\"nanan\",\"acronym\":\"na\",\"rank\":\"E\",\"firstChar\":\"N\"},{\"id\":1264,\"name\":\"南川\",\"pinyin\":\"nanchuan\",\"acronym\":\"nanchuan\",\"rank\":\"F\",\"firstChar\":\"N\"},{\"id\":520,\"name\":\"宁乡\",\"pinyin\":\"ningxiang\",\"acronym\":\"nx\",\"rank\":\"F\",\"firstChar\":\"N\"},{\"id\":547,\"name\":\"南沙\",\"pinyin\":\"nansha\",\"acronym\":\"ns\",\"rank\":\"F\",\"firstChar\":\"N\"},{\"id\":1224,\"name\":\"宁远县\",\"pinyin\":\"ningyuanxian\",\"acronym\":\"ningyuanxian\",\"rank\":\"F\",\"firstChar\":\"N\"},{\"id\":682,\"name\":\"讷河\",\"pinyin\":\"nehe\",\"acronym\":\"nehe\",\"rank\":\"F\",\"firstChar\":\"N\"},{\"id\":687,\"name\":\"南雄\",\"pinyin\":\"nanxiong\",\"acronym\":\"nanxiong\",\"rank\":\"F\",\"firstChar\":\"N\"},{\"id\":1166,\"name\":\"嫩江县\",\"pinyin\":\"nenjiangxian\",\"acronym\":\"nenjiangxian\",\"rank\":\"F\",\"firstChar\":\"N\"},{\"id\":741,\"name\":\"南乐\",\"pinyin\":\"nanle\",\"acronym\":\"nanle\",\"rank\":\"F\",\"firstChar\":\"N\"},{\"id\":775,\"name\":\"南陵\",\"pinyin\":\"nanling\",\"acronym\":\"nanling\",\"rank\":\"F\",\"firstChar\":\"N\"},{\"id\":779,\"name\":\"宁阳\",\"pinyin\":\"ningyang\",\"acronym\":\"ningyang\",\"rank\":\"F\",\"firstChar\":\"N\"},{\"id\":781,\"name\":\"宁国\",\"pinyin\":\"ningguo\",\"acronym\":\"ningguo\",\"rank\":\"F\",\"firstChar\":\"N\"},{\"id\":813,\"name\":\"宁晋\",\"pinyin\":\"ningjin\",\"acronym\":\"ningjin\",\"rank\":\"F\",\"firstChar\":\"N\"},{\"id\":820,\"name\":\"宁津\",\"pinyin\":\"ningjinnj\",\"acronym\":\"ningjinnj\",\"rank\":\"F\",\"firstChar\":\"N\"},{\"id\":931,\"name\":\"内丘\",\"pinyin\":\"neiqiu\",\"acronym\":\"neiqiu\",\"rank\":\"F\",\"firstChar\":\"N\"},{\"id\":932,\"name\":\"南宫\",\"pinyin\":\"nangong\",\"acronym\":\"nangong\",\"rank\":\"F\",\"firstChar\":\"N\"},{\"id\":979,\"name\":\"内黄\",\"pinyin\":\"neihuang\",\"acronym\":\"neihuang\",\"rank\":\"F\",\"firstChar\":\"N\"},{\"id\":1013,\"name\":\"南和\",\"pinyin\":\"nanhe\",\"acronym\":\"nanhe\",\"rank\":\"F\",\"firstChar\":\"N\"},{\"id\":1053,\"name\":\"南部县\",\"pinyin\":\"nanbuxian\",\"acronym\":\"nanbuxian\",\"rank\":\"F\",\"firstChar\":\"N\"},{\"id\":1075,\"name\":\"南皮县\",\"pinyin\":\"nanpixian\",\"acronym\":\"nanpixian\",\"rank\":\"F\",\"firstChar\":\"N\"},{\"id\":1112,\"name\":\"宁陵\",\"pinyin\":\"ninglingxian\",\"acronym\":\"ninglingxian\",\"rank\":\"F\",\"firstChar\":\"N\"},{\"id\":1125,\"name\":\"南郑区\",\"pinyin\":\"nanzhengxian\",\"acronym\":\"nanzhengxian\",\"rank\":\"F\",\"firstChar\":\"N\"},{\"id\":1161,\"name\":\"宁蒗彝族自治县\",\"pinyin\":\"ninglangyizuzizhixian\",\"acronym\":\"ninglangyizuzizh\",\"rank\":\"F\",\"firstChar\":\"N\"},{\"id\":349,\"name\":\"那曲\",\"pinyin\":\"naqu\",\"acronym\":\"nq\",\"rank\":\"Z\",\"firstChar\":\"N\"},{\"id\":343,\"name\":\"怒江\",\"pinyin\":\"nujiang\",\"acronym\":\"nujiang\",\"rank\":\"Z\",\"firstChar\":\"N\"},{\"id\":711,\"name\":\"南投\",\"pinyin\":\"nantou\",\"acronym\":\"nantou\",\"rank\":\"Z\",\"firstChar\":\"N\"}]],[\"P\",[{\"id\":207,\"name\":\"莆田\",\"pinyin\":\"putian\",\"acronym\":\"pt\",\"rank\":\"C\",\"firstChar\":\"P\"},{\"id\":158,\"name\":\"盘锦\",\"pinyin\":\"panjin\",\"acronym\":\"pj\",\"rank\":\"D\",\"firstChar\":\"P\"},{\"id\":237,\"name\":\"平顶山\",\"pinyin\":\"pingdingshan\",\"acronym\":\"pds\",\"rank\":\"D\",\"firstChar\":\"P\"},{\"id\":240,\"name\":\"濮阳\",\"pinyin\":\"puyang\",\"acronym\":\"puyang\",\"rank\":\"D\",\"firstChar\":\"P\"},{\"id\":303,\"name\":\"攀枝花\",\"pinyin\":\"panzhihua\",\"acronym\":\"panzhihua\",\"rank\":\"E\",\"firstChar\":\"P\"},{\"id\":335,\"name\":\"普洱\",\"pinyin\":\"puer\",\"acronym\":\"pe\",\"rank\":\"E\",\"firstChar\":\"P\"},{\"id\":367,\"name\":\"平凉\",\"pinyin\":\"pingliang\",\"acronym\":\"pl\",\"rank\":\"E\",\"firstChar\":\"P\"},{\"id\":493,\"name\":\"邳州\",\"pinyin\":\"pizhou\",\"acronym\":\"pz\",\"rank\":\"E\",\"firstChar\":\"P\"},{\"id\":214,\"name\":\"萍乡\",\"pinyin\":\"pingxiang\",\"acronym\":\"px\",\"rank\":\"E\",\"firstChar\":\"P\"},{\"id\":546,\"name\":\"普宁\",\"pinyin\":\"puning\",\"acronym\":\"pn\",\"rank\":\"E\",\"firstChar\":\"P\"},{\"id\":582,\"name\":\"平度\",\"pinyin\":\"pingdu\",\"acronym\":\"pd\",\"rank\":\"E\",\"firstChar\":\"P\"},{\"id\":585,\"name\":\"彭州\",\"pinyin\":\"pengzhou\",\"acronym\":\"pengzhou\",\"rank\":\"E\",\"firstChar\":\"P\"},{\"id\":587,\"name\":\"蓬莱\",\"pinyin\":\"penglai\",\"acronym\":\"penglai\",\"rank\":\"E\",\"firstChar\":\"P\"},{\"id\":972,\"name\":\"平阳\",\"pinyin\":\"pingyang\",\"acronym\":\"pingyang\",\"rank\":\"E\",\"firstChar\":\"P\"},{\"id\":833,\"name\":\"沛县\",\"pinyin\":\"peixian\",\"acronym\":\"peixian\",\"rank\":\"E\",\"firstChar\":\"P\"},{\"id\":524,\"name\":\"平湖\",\"pinyin\":\"pinghu\",\"acronym\":\"ph\",\"rank\":\"E\",\"firstChar\":\"P\"},{\"id\":730,\"name\":\"浦江\",\"pinyin\":\"pujiang\",\"acronym\":\"pujiang\",\"rank\":\"F\",\"firstChar\":\"P\"},{\"id\":761,\"name\":\"磐石\",\"pinyin\":\"panshi\",\"acronym\":\"panshi\",\"rank\":\"F\",\"firstChar\":\"P\"},{\"id\":777,\"name\":\"平原\",\"pinyin\":\"pingyuan\",\"acronym\":\"pingyuan\",\"rank\":\"F\",\"firstChar\":\"P\"},{\"id\":1258,\"name\":\"普兰店\",\"pinyin\":\"pulandian\",\"acronym\":\"pulandian\",\"rank\":\"F\",\"firstChar\":\"P\"},{\"id\":701,\"name\":\"鄱阳\",\"pinyin\":\"poyang\",\"acronym\":\"poyang\",\"rank\":\"F\",\"firstChar\":\"P\"},{\"id\":837,\"name\":\"蒲城\",\"pinyin\":\"pucheng\",\"acronym\":\"pucheng\",\"rank\":\"F\",\"firstChar\":\"P\"},{\"id\":842,\"name\":\"盘州市\",\"pinyin\":\"panzhoushi\",\"acronym\":\"panxian\",\"rank\":\"F\",\"firstChar\":\"P\"},{\"id\":847,\"name\":\"平江\",\"pinyin\":\"pingjiang\",\"acronym\":\"pingjiang\",\"rank\":\"F\",\"firstChar\":\"P\"},{\"id\":849,\"name\":\"濮阳县\",\"pinyin\":\"puyangxian\",\"acronym\":\"puyangxian\",\"rank\":\"F\",\"firstChar\":\"P\"},{\"id\":893,\"name\":\"平山\",\"pinyin\":\"pingshan\",\"acronym\":\"pingshan\",\"rank\":\"F\",\"firstChar\":\"P\"},{\"id\":923,\"name\":\"平泉市\",\"pinyin\":\"pingquanshi\",\"acronym\":\"pingquan\",\"rank\":\"F\",\"firstChar\":\"P\"},{\"id\":950,\"name\":\"平邑\",\"pinyin\":\"pingyi\",\"acronym\":\"pingyi\",\"rank\":\"F\",\"firstChar\":\"P\"},{\"id\":960,\"name\":\"平舆\",\"pinyin\":\"pingyu\",\"acronym\":\"pingyu\",\"rank\":\"F\",\"firstChar\":\"P\"},{\"id\":1232,\"name\":\"彭水苗族土家族自治县\",\"pinyin\":\"pengshuizizhixian\",\"acronym\":\"pengshuizizhixia\",\"rank\":\"F\",\"firstChar\":\"P\"},{\"id\":987,\"name\":\"平遥\",\"pinyin\":\"pingyao\",\"acronym\":\"pingyao\",\"rank\":\"F\",\"firstChar\":\"P\"},{\"id\":991,\"name\":\"平果\",\"pinyin\":\"pingguo\",\"acronym\":\"pingguo\",\"rank\":\"F\",\"firstChar\":\"P\"},{\"id\":1106,\"name\":\"平罗县\",\"pinyin\":\"pingluoxian\",\"acronym\":\"pingluoxian\",\"rank\":\"F\",\"firstChar\":\"P\"},{\"id\":1156,\"name\":\"平阴县\",\"pinyin\":\"pingyinxian\",\"acronym\":\"pingyinxian\",\"rank\":\"F\",\"firstChar\":\"P\"},{\"id\":1175,\"name\":\"平陆县\",\"pinyin\":\"pingluxian\",\"acronym\":\"pingluxian\",\"rank\":\"F\",\"firstChar\":\"P\"},{\"id\":1214,\"name\":\"平昌县\",\"pinyin\":\"pingchangxian\",\"acronym\":\"pingchangxian\",\"rank\":\"F\",\"firstChar\":\"P\"},{\"id\":1226,\"name\":\"平南县\",\"pinyin\":\"pingnanxian\",\"acronym\":\"pingnanxian\",\"rank\":\"F\",\"firstChar\":\"P\"},{\"id\":805,\"name\":\"平潭\",\"pinyin\":\"pingtan\",\"acronym\":\"pingtan\",\"rank\":\"F\",\"firstChar\":\"P\"},{\"id\":722,\"name\":\"澎湖\",\"pinyin\":\"penghu\",\"acronym\":\"penghu\",\"rank\":\"Z\",\"firstChar\":\"P\"}]],[\"Q\",[{\"id\":60,\"name\":\"青岛\",\"pinyin\":\"qingdao\",\"acronym\":\"qd\",\"rank\":\"B\",\"firstChar\":\"Q\"},{\"id\":122,\"name\":\"秦皇岛\",\"pinyin\":\"qinhuangdao\",\"acronym\":\"qhd\",\"rank\":\"C\",\"firstChar\":\"Q\"},{\"id\":110,\"name\":\"泉州\",\"pinyin\":\"quanzhou\",\"acronym\":\"qz\",\"rank\":\"C\",\"firstChar\":\"Q\"},{\"id\":330,\"name\":\"曲靖\",\"pinyin\":\"qujing\",\"acronym\":\"qj\",\"rank\":\"D\",\"firstChar\":\"Q\"},{\"id\":189,\"name\":\"衢州\",\"pinyin\":\"quzhou\",\"acronym\":\"quzhou\",\"rank\":\"D\",\"firstChar\":\"Q\"},{\"id\":286,\"name\":\"清远\",\"pinyin\":\"qingyuan\",\"acronym\":\"qingyuan\",\"rank\":\"D\",\"firstChar\":\"Q\"},{\"id\":109,\"name\":\"齐齐哈尔\",\"pinyin\":\"qiqihaer\",\"acronym\":\"qqhr\",\"rank\":\"D\",\"firstChar\":\"Q\"},{\"id\":294,\"name\":\"钦州\",\"pinyin\":\"qinzhou\",\"acronym\":\"qinzhou\",\"rank\":\"E\",\"firstChar\":\"Q\"},{\"id\":174,\"name\":\"七台河\",\"pinyin\":\"qitaihe\",\"acronym\":\"qth\",\"rank\":\"E\",\"firstChar\":\"Q\"},{\"id\":369,\"name\":\"庆阳\",\"pinyin\":\"qingyang\",\"acronym\":\"qingyang\",\"rank\":\"E\",\"firstChar\":\"Q\"},{\"id\":430,\"name\":\"迁安\",\"pinyin\":\"qianan\",\"acronym\":\"qa\",\"rank\":\"E\",\"firstChar\":\"Q\"},{\"id\":496,\"name\":\"青州\",\"pinyin\":\"qingzhou\",\"acronym\":\"qingzhou\",\"rank\":\"E\",\"firstChar\":\"Q\"},{\"id\":500,\"name\":\"启东\",\"pinyin\":\"qidong\",\"acronym\":\"qidong\",\"rank\":\"E\",\"firstChar\":\"Q\"},{\"id\":550,\"name\":\"潜江\",\"pinyin\":\"qianjiang\",\"acronym\":\"qianjiang\",\"rank\":\"E\",\"firstChar\":\"Q\"},{\"id\":328,\"name\":\"黔东南\",\"pinyin\":\"qiandongnan\",\"acronym\":\"qdn\",\"rank\":\"E\",\"firstChar\":\"Q\"},{\"id\":326,\"name\":\"黔西南\",\"pinyin\":\"qianxinan\",\"acronym\":\"qxn\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":1287,\"name\":\"黔江区\",\"pinyin\":\"qianjiangqu\",\"acronym\":\"qianjiangqu\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":1284,\"name\":\"青铜峡市\",\"pinyin\":\"qingtongxiashi\",\"acronym\":\"qingtongxiashi\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":418,\"name\":\"琼海\",\"pinyin\":\"qionghai\",\"acronym\":\"qh\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":644,\"name\":\"沁阳\",\"pinyin\":\"qinyang\",\"acronym\":\"qy\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":647,\"name\":\"邛崃\",\"pinyin\":\"qionglai\",\"acronym\":\"ql\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":727,\"name\":\"齐河\",\"pinyin\":\"qihe\",\"acronym\":\"qihe\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":329,\"name\":\"黔南\",\"pinyin\":\"qiannan\",\"acronym\":\"qn\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":864,\"name\":\"淇县\",\"pinyin\":\"qixian\",\"acronym\":\"qixian\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":865,\"name\":\"全椒\",\"pinyin\":\"quanjiao\",\"acronym\":\"quanjiao\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":914,\"name\":\"栖霞\",\"pinyin\":\"qixia\",\"acronym\":\"qixia\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":922,\"name\":\"青田\",\"pinyin\":\"qingtian\",\"acronym\":\"qingtian\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":929,\"name\":\"清河\",\"pinyin\":\"qinghe\",\"acronym\":\"qinghe\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":998,\"name\":\"庆云\",\"pinyin\":\"qingyun\",\"acronym\":\"qingyun\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":1004,\"name\":\"潜山市\",\"pinyin\":\"qianshanshi\",\"acronym\":\"qianshan\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":1020,\"name\":\"青县\",\"pinyin\":\"qingxian\",\"acronym\":\"qingxian\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":1089,\"name\":\"祁东县\",\"pinyin\":\"qidongxian\",\"acronym\":\"qidongxian\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":1107,\"name\":\"庆安县\",\"pinyin\":\"qinganxian\",\"acronym\":\"qinganxian\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":1115,\"name\":\"杞县\",\"pinyin\":\"qixiankaifeng\",\"acronym\":\"qixiankaifeng\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":1131,\"name\":\"青冈县\",\"pinyin\":\"qinggangxian\",\"acronym\":\"qinggangxian\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":1139,\"name\":\"岐山县\",\"pinyin\":\"qishanxian\",\"acronym\":\"qishanxian\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":1170,\"name\":\"琼中\",\"pinyin\":\"qiongzhong\",\"acronym\":\"qiongzhong\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":1220,\"name\":\"青阳县\",\"pinyin\":\"qingyangxian\",\"acronym\":\"qingyangxian\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":1260,\"name\":\"清镇\",\"pinyin\":\"qingzhen\",\"acronym\":\"qingzhen\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":1265,\"name\":\"綦江\",\"pinyin\":\"qijiang\",\"acronym\":\"qijiang\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":1266,\"name\":\"清徐\",\"pinyin\":\"qingxu\",\"acronym\":\"qingxu\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":1267,\"name\":\"迁西县\",\"pinyin\":\"qianxixian\",\"acronym\":\"qianxixian\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":1276,\"name\":\"企石镇\",\"pinyin\":\"qishizhen\",\"acronym\":\"qishizhen\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":740,\"name\":\"清丰\",\"pinyin\":\"qingfeng\",\"acronym\":\"qingfeng\",\"rank\":\"F\",\"firstChar\":\"Q\"},{\"id\":507,\"name\":\"曲阜\",\"pinyin\":\"qufu\",\"acronym\":\"qf\",\"rank\":\"Z\",\"firstChar\":\"Q\"}]],[\"R\",[{\"id\":228,\"name\":\"日照\",\"pinyin\":\"rizhao\",\"acronym\":\"rizhao\",\"rank\":\"D\",\"firstChar\":\"R\"},{\"id\":469,\"name\":\"瑞安\",\"pinyin\":\"ruian\",\"acronym\":\"ruian\",\"rank\":\"E\",\"firstChar\":\"R\"},{\"id\":497,\"name\":\"荣成\",\"pinyin\":\"rongcheng\",\"acronym\":\"rc\",\"rank\":\"E\",\"firstChar\":\"R\"},{\"id\":499,\"name\":\"乳山\",\"pinyin\":\"rushan\",\"acronym\":\"rs\",\"rank\":\"E\",\"firstChar\":\"R\"},{\"id\":501,\"name\":\"如皋\",\"pinyin\":\"rugao\",\"acronym\":\"rg\",\"rank\":\"E\",\"firstChar\":\"R\"},{\"id\":616,\"name\":\"汝州\",\"pinyin\":\"ruzhou\",\"acronym\":\"rz\",\"rank\":\"E\",\"firstChar\":\"R\"},{\"id\":988,\"name\":\"如东\",\"pinyin\":\"rudong\",\"acronym\":\"rudong\",\"rank\":\"E\",\"firstChar\":\"R\"},{\"id\":475,\"name\":\"仁怀\",\"pinyin\":\"renhuai\",\"acronym\":\"rh\",\"rank\":\"F\",\"firstChar\":\"R\"},{\"id\":639,\"name\":\"瑞金\",\"pinyin\":\"ruijin\",\"acronym\":\"rj\",\"rank\":\"F\",\"firstChar\":\"R\"},{\"id\":1114,\"name\":\"荣昌区\",\"pinyin\":\"rongchangqu\",\"acronym\":\"rongchangqu\",\"rank\":\"F\",\"firstChar\":\"R\"},{\"id\":749,\"name\":\"仁寿\",\"pinyin\":\"renshou\",\"acronym\":\"renshou\",\"rank\":\"F\",\"firstChar\":\"R\"},{\"id\":917,\"name\":\"任丘\",\"pinyin\":\"renqiu\",\"acronym\":\"renqiu\",\"rank\":\"F\",\"firstChar\":\"R\"},{\"id\":966,\"name\":\"汝阳\",\"pinyin\":\"ruyang\",\"acronym\":\"ruyang\",\"rank\":\"F\",\"firstChar\":\"R\"},{\"id\":1262,\"name\":\"瑞丽\",\"pinyin\":\"ruili\",\"acronym\":\"ruili\",\"rank\":\"F\",\"firstChar\":\"R\"},{\"id\":1012,\"name\":\"任县\",\"pinyin\":\"renxian\",\"acronym\":\"renxian\",\"rank\":\"F\",\"firstChar\":\"R\"},{\"id\":1095,\"name\":\"汝城县\",\"pinyin\":\"ruchengxian\",\"acronym\":\"ruchengxian\",\"rank\":\"F\",\"firstChar\":\"R\"},{\"id\":1101,\"name\":\"容县\",\"pinyin\":\"rongxian\",\"acronym\":\"rongxian\",\"rank\":\"F\",\"firstChar\":\"R\"},{\"id\":657,\"name\":\"瑞昌\",\"pinyin\":\"ruichang\",\"acronym\":\"ruichang\",\"rank\":\"F\",\"firstChar\":\"R\"},{\"id\":348,\"name\":\"日喀则\",\"pinyin\":\"rikaze\",\"acronym\":\"rkz\",\"rank\":\"Z\",\"firstChar\":\"R\"}]],[\"S\",[{\"id\":10,\"name\":\"上海\",\"pinyin\":\"shanghai\",\"acronym\":\"sh\",\"rank\":\"S\",\"firstChar\":\"S\"},{\"id\":30,\"name\":\"深圳\",\"pinyin\":\"shenzhen\",\"acronym\":\"sz\",\"rank\":\"A\",\"firstChar\":\"S\"},{\"id\":76,\"name\":\"石家庄\",\"pinyin\":\"shijiazhuang\",\"acronym\":\"sjz\",\"rank\":\"B\",\"firstChar\":\"S\"},{\"id\":80,\"name\":\"苏州\",\"pinyin\":\"suzhou\",\"acronym\":\"su\",\"rank\":\"B\",\"firstChar\":\"S\"},{\"id\":66,\"name\":\"沈阳\",\"pinyin\":\"shenyang\",\"acronym\":\"sy\",\"rank\":\"B\",\"firstChar\":\"S\"},{\"id\":111,\"name\":\"三亚\",\"pinyin\":\"sanya\",\"acronym\":\"sanya\",\"rank\":\"C\",\"firstChar\":\"S\"},{\"id\":117,\"name\":\"汕头\",\"pinyin\":\"shantou\",\"acronym\":\"st\",\"rank\":\"C\",\"firstChar\":\"S\"},{\"id\":187,\"name\":\"绍兴\",\"pinyin\":\"shaoxing\",\"acronym\":\"sx\",\"rank\":\"C\",\"firstChar\":\"S\"},{\"id\":166,\"name\":\"松原\",\"pinyin\":\"songyuan\",\"acronym\":\"songyuan\",\"rank\":\"D\",\"firstChar\":\"S\"},{\"id\":276,\"name\":\"韶关\",\"pinyin\":\"shaoguan\",\"acronym\":\"sg\",\"rank\":\"D\",\"firstChar\":\"S\"},{\"id\":266,\"name\":\"邵阳\",\"pinyin\":\"shaoyang\",\"acronym\":\"shaoyang\",\"rank\":\"D\",\"firstChar\":\"S\"},{\"id\":184,\"name\":\"宿迁\",\"pinyin\":\"suqian\",\"acronym\":\"suqian\",\"rank\":\"D\",\"firstChar\":\"S\"},{\"id\":251,\"name\":\"十堰\",\"pinyin\":\"shiyan\",\"acronym\":\"shiyan\",\"rank\":\"D\",\"firstChar\":\"S\"},{\"id\":201,\"name\":\"宿州\",\"pinyin\":\"suzhousz\",\"acronym\":\"suzhousz\",\"rank\":\"D\",\"firstChar\":\"S\"},{\"id\":406,\"name\":\"顺德\",\"pinyin\":\"shunde\",\"acronym\":\"sd\",\"rank\":\"D\",\"firstChar\":\"S\"},{\"id\":221,\"name\":\"上饶\",\"pinyin\":\"shangrao\",\"acronym\":\"sr\",\"rank\":\"D\",\"firstChar\":\"S\"},{\"id\":245,\"name\":\"商丘\",\"pinyin\":\"shangqiu\",\"acronym\":\"sq\",\"rank\":\"D\",\"firstChar\":\"S\"},{\"id\":408,\"name\":\"石河子\",\"pinyin\":\"shihezi\",\"acronym\":\"shz\",\"rank\":\"E\",\"firstChar\":\"S\"},{\"id\":243,\"name\":\"三门峡\",\"pinyin\":\"sanmenxia\",\"acronym\":\"smx\",\"rank\":\"E\",\"firstChar\":\"S\"},{\"id\":260,\"name\":\"随州\",\"pinyin\":\"suizhou\",\"acronym\":\"suizhou\",\"rank\":\"E\",\"firstChar\":\"S\"},{\"id\":177,\"name\":\"绥化\",\"pinyin\":\"suihua\",\"acronym\":\"suihua\",\"rank\":\"E\",\"firstChar\":\"S\"},{\"id\":171,\"name\":\"双鸭山\",\"pinyin\":\"shuangyashan\",\"acronym\":\"sys\",\"rank\":\"E\",\"firstChar\":\"S\"},{\"id\":283,\"name\":\"汕尾\",\"pinyin\":\"shanwei\",\"acronym\":\"sw\",\"rank\":\"E\",\"firstChar\":\"S\"},{\"id\":308,\"name\":\"遂宁\",\"pinyin\":\"suining\",\"acronym\":\"suining\",\"rank\":\"E\",\"firstChar\":\"S\"},{\"id\":360,\"name\":\"商洛\",\"pinyin\":\"shangluo\",\"acronym\":\"sl\",\"rank\":\"E\",\"firstChar\":\"S\"},{\"id\":383,\"name\":\"石嘴山\",\"pinyin\":\"shizuishan\",\"acronym\":\"szs\",\"rank\":\"E\",\"firstChar\":\"S\"},{\"id\":162,\"name\":\"四平\",\"pinyin\":\"siping\",\"acronym\":\"sp\",\"rank\":\"E\",\"firstChar\":\"S\"},{\"id\":208,\"name\":\"三明\",\"pinyin\":\"sanming\",\"acronym\":\"sm\",\"rank\":\"E\",\"firstChar\":\"S\"},{\"id\":440,\"name\":\"石狮\",\"pinyin\":\"shishi\",\"acronym\":\"ss\",\"rank\":\"E\",\"firstChar\":\"S\"},{\"id\":456,\"name\":\"上虞\",\"pinyin\":\"shangyu\",\"acronym\":\"shangyu\",\"rank\":\"E\",\"firstChar\":\"S\"},{\"id\":495,\"name\":\"寿光\",\"pinyin\":\"shouguang\",\"acronym\":\"shouguang\",\"rank\":\"E\",\"firstChar\":\"S\"},{\"id\":530,\"name\":\"嵊州\",\"pinyin\":\"shengzhou\",\"acronym\":\"shengzhou\",\"rank\":\"E\",\"firstChar\":\"S\"},{\"id\":531,\"name\":\"沭阳\",\"pinyin\":\"shuyang\",\"acronym\":\"shuyang\",\"rank\":\"E\",\"firstChar\":\"S\"},{\"id\":532,\"name\":\"射阳\",\"pinyin\":\"sheyang\",\"acronym\":\"sheyang\",\"rank\":\"E\",\"firstChar\":\"S\"},{\"id\":538,\"name\":\"三河\",\"pinyin\":\"sanhe\",\"acronym\":\"sanhe\",\"rank\":\"E\",\"firstChar\":\"S\"},{\"id\":133,\"name\":\"朔州\",\"pinyin\":\"shuozhou\",\"acronym\":\"shuozhou\",\"rank\":\"E\",\"firstChar\":\"S\"},{\"id\":982,\"name\":\"舒城\",\"pinyin\":\"shucheng\",\"acronym\":\"shucheng\",\"rank\":\"E\",\"firstChar\":\"S\"},{\"id\":1272,\"name\":\"石林彝族自治县\",\"pinyin\":\"shilinxian\",\"acronym\":\"shilinxian\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1270,\"name\":\"嵩明县\",\"pinyin\":\"songmingxian\",\"acronym\":\"songmingxian\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1251,\"name\":\"沙雅\",\"pinyin\":\"shaya\",\"acronym\":\"shaya\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":569,\"name\":\"韶山\",\"pinyin\":\"shaoshan\",\"acronym\":\"shaoshan\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":613,\"name\":\"沙河\",\"pinyin\":\"shahe\",\"acronym\":\"shahe\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":633,\"name\":\"四会\",\"pinyin\":\"sihui\",\"acronym\":\"sihui\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":648,\"name\":\"松滋\",\"pinyin\":\"songzi\",\"acronym\":\"songzi\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":669,\"name\":\"舒兰\",\"pinyin\":\"shulan\",\"acronym\":\"shulan\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":736,\"name\":\"邵东\",\"pinyin\":\"shaodong\",\"acronym\":\"shaodong\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":755,\"name\":\"睢县\",\"pinyin\":\"suixian\",\"acronym\":\"suixian\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":760,\"name\":\"泗阳\",\"pinyin\":\"siyang\",\"acronym\":\"siyang\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":762,\"name\":\"沙湾\",\"pinyin\":\"shawan\",\"acronym\":\"shawan\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":768,\"name\":\"涉县\",\"pinyin\":\"shexian\",\"acronym\":\"shexian\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1289,\"name\":\"三原县\",\"pinyin\":\"sanyuanxian\",\"acronym\":\"sanyuanxian\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":797,\"name\":\"绥中\",\"pinyin\":\"suizhong\",\"acronym\":\"suizhong\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":804,\"name\":\"上高\",\"pinyin\":\"shanggao\",\"acronym\":\"shanggao\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":819,\"name\":\"石泉\",\"pinyin\":\"shiquan\",\"acronym\":\"shiquan\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":824,\"name\":\"泗洪\",\"pinyin\":\"sihong\",\"acronym\":\"sihong\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":830,\"name\":\"单县\",\"pinyin\":\"shanxian\",\"acronym\":\"shanxian\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":840,\"name\":\"沈丘\",\"pinyin\":\"shenqiu\",\"acronym\":\"shenqiu\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":845,\"name\":\"三门\",\"pinyin\":\"sanmen\",\"acronym\":\"sanmen\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":875,\"name\":\"睢宁\",\"pinyin\":\"suiningxian\",\"acronym\":\"suiningxian\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":886,\"name\":\"上蔡\",\"pinyin\":\"shangcai\",\"acronym\":\"shangcai\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":895,\"name\":\"遂昌\",\"pinyin\":\"suichang\",\"acronym\":\"suichang\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":907,\"name\":\"石岛\",\"pinyin\":\"shidao\",\"acronym\":\"shidao\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":953,\"name\":\"什邡\",\"pinyin\":\"shifang\",\"acronym\":\"shifang\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":955,\"name\":\"上杭\",\"pinyin\":\"shanghang\",\"acronym\":\"shanghang\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":965,\"name\":\"嵩县\",\"pinyin\":\"songxian\",\"acronym\":\"songxian\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1286,\"name\":\"莘县\",\"pinyin\":\"shenxian\",\"acronym\":\"shenxian\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":992,\"name\":\"射洪\",\"pinyin\":\"shehong\",\"acronym\":\"shehong\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1015,\"name\":\"商河\",\"pinyin\":\"shanghe\",\"acronym\":\"shanghe\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1017,\"name\":\"泗水\",\"pinyin\":\"sishui\",\"acronym\":\"sishui\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1022,\"name\":\"社旗\",\"pinyin\":\"sheqi\",\"acronym\":\"sheqi\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1024,\"name\":\"泗县\",\"pinyin\":\"sixian\",\"acronym\":\"sixian\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1039,\"name\":\"深州市\",\"pinyin\":\"shenzhoushi\",\"acronym\":\"shenzhoushi\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1045,\"name\":\"上林县\",\"pinyin\":\"shanglinxian\",\"acronym\":\"shanglinxian\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1055,\"name\":\"商水县\",\"pinyin\":\"shangshuixian\",\"acronym\":\"shangshuixian\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1062,\"name\":\"双峰\",\"pinyin\":\"shuangfeng\",\"acronym\":\"shuangfeng\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1067,\"name\":\"遂川\",\"pinyin\":\"suichuan\",\"acronym\":\"suichuan\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1071,\"name\":\"上栗\",\"pinyin\":\"shangli\",\"acronym\":\"shangli\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1077,\"name\":\"莎车县\",\"pinyin\":\"shachexian\",\"acronym\":\"shachexian\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1081,\"name\":\"肃宁县\",\"pinyin\":\"suningxian\",\"acronym\":\"suningxian\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1108,\"name\":\"商城县\",\"pinyin\":\"shangchengxian\",\"acronym\":\"shangchengxian\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1113,\"name\":\"桑植\",\"pinyin\":\"sangzhi\",\"acronym\":\"sangzhi\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1118,\"name\":\"石门\",\"pinyin\":\"shimen\",\"acronym\":\"shimen\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1120,\"name\":\"鄯善县\",\"pinyin\":\"shanshanxian\",\"acronym\":\"shanshanxian\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1155,\"name\":\"绥德县\",\"pinyin\":\"suidexian\",\"acronym\":\"suidexian\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1158,\"name\":\"沙县\",\"pinyin\":\"shaxian\",\"acronym\":\"shaxian\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1176,\"name\":\"深泽县\",\"pinyin\":\"shenzexian\",\"acronym\":\"shenzexian\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1180,\"name\":\"石柱\",\"pinyin\":\"shizhu\",\"acronym\":\"shizhu\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1189,\"name\":\"邵武\",\"pinyin\":\"shaowu\",\"acronym\":\"shaowu\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1192,\"name\":\"寿县\",\"pinyin\":\"shouxian\",\"acronym\":\"shouxian\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1211,\"name\":\"三台县\",\"pinyin\":\"santaixian\",\"acronym\":\"santaixian\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1228,\"name\":\"山丹县\",\"pinyin\":\"shandanxian\",\"acronym\":\"shandanxian\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1236,\"name\":\"陕州区\",\"pinyin\":\"shanzhouqu\",\"acronym\":\"shanzhouqu\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1240,\"name\":\"绥宁县\",\"pinyin\":\"suiningxiansnx\",\"acronym\":\"suiningxiansnx\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1249,\"name\":\"双城\",\"pinyin\":\"shuangcheng\",\"acronym\":\"shuangcheng\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":1250,\"name\":\"遂平\",\"pinyin\":\"suiping\",\"acronym\":\"suiping\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":796,\"name\":\"神木市\",\"pinyin\":\"shenmushi\",\"acronym\":\"shenmu\",\"rank\":\"F\",\"firstChar\":\"S\"},{\"id\":488,\"name\":\"三清山\",\"pinyin\":\"sanqingshan\",\"acronym\":\"sqs\",\"rank\":\"Z\",\"firstChar\":\"S\"},{\"id\":487,\"name\":\"神农架\",\"pinyin\":\"shennongjia\",\"acronym\":\"snj\",\"rank\":\"Z\",\"firstChar\":\"S\"},{\"id\":347,\"name\":\"山南\",\"pinyin\":\"shannan\",\"acronym\":\"sn\",\"rank\":\"Z\",\"firstChar\":\"S\"},{\"id\":262,\"name\":\"三峡\",\"pinyin\":\"sanxia\",\"acronym\":\"sanx\",\"rank\":\"Z\",\"firstChar\":\"S\"}]],[\"T\",[{\"id\":40,\"name\":\"天津\",\"pinyin\":\"tianjin\",\"acronym\":\"tj\",\"rank\":\"A\",\"firstChar\":\"T\"},{\"id\":101,\"name\":\"太原\",\"pinyin\":\"taiyuan\",\"acronym\":\"ty\",\"rank\":\"B\",\"firstChar\":\"T\"},{\"id\":183,\"name\":\"泰州\",\"pinyin\":\"taizhou\",\"acronym\":\"taizhou\",\"rank\":\"C\",\"firstChar\":\"T\"},{\"id\":191,\"name\":\"台州\",\"pinyin\":\"taizhoutz\",\"acronym\":\"tz\",\"rank\":\"C\",\"firstChar\":\"T\"},{\"id\":121,\"name\":\"唐山\",\"pinyin\":\"tangshan\",\"acronym\":\"ts\",\"rank\":\"C\",\"firstChar\":\"T\"},{\"id\":226,\"name\":\"泰安\",\"pinyin\":\"taian\",\"acronym\":\"ta\",\"rank\":\"D\",\"firstChar\":\"T\"},{\"id\":425,\"name\":\"桐乡\",\"pinyin\":\"tongxiang\",\"acronym\":\"tx\",\"rank\":\"D\",\"firstChar\":\"T\"},{\"id\":432,\"name\":\"太仓\",\"pinyin\":\"taicang\",\"acronym\":\"taicang\",\"rank\":\"D\",\"firstChar\":\"T\"},{\"id\":364,\"name\":\"天水\",\"pinyin\":\"tianshui\",\"acronym\":\"tianshui\",\"rank\":\"E\",\"firstChar\":\"T\"},{\"id\":325,\"name\":\"铜仁\",\"pinyin\":\"tongrendiqu\",\"acronym\":\"tr\",\"rank\":\"E\",\"firstChar\":\"T\"},{\"id\":164,\"name\":\"通化\",\"pinyin\":\"tonghua\",\"acronym\":\"th\",\"rank\":\"E\",\"firstChar\":\"T\"},{\"id\":159,\"name\":\"铁岭\",\"pinyin\":\"tieling\",\"acronym\":\"tl\",\"rank\":\"E\",\"firstChar\":\"T\"},{\"id\":196,\"name\":\"铜陵\",\"pinyin\":\"tongling\",\"acronym\":\"tongling\",\"rank\":\"E\",\"firstChar\":\"T\"},{\"id\":143,\"name\":\"通辽\",\"pinyin\":\"tongliao\",\"acronym\":\"tongliao\",\"rank\":\"E\",\"firstChar\":\"T\"},{\"id\":503,\"name\":\"台山\",\"pinyin\":\"taishan\",\"acronym\":\"taishan\",\"rank\":\"E\",\"firstChar\":\"T\"},{\"id\":518,\"name\":\"泰兴\",\"pinyin\":\"taixing\",\"acronym\":\"taixing\",\"rank\":\"E\",\"firstChar\":\"T\"},{\"id\":549,\"name\":\"滕州\",\"pinyin\":\"tengzhou\",\"acronym\":\"tengzhou\",\"rank\":\"E\",\"firstChar\":\"T\"},{\"id\":578,\"name\":\"天门\",\"pinyin\":\"tianmen\",\"acronym\":\"tm\",\"rank\":\"E\",\"firstChar\":\"T\"},{\"id\":626,\"name\":\"天长\",\"pinyin\":\"tianchang\",\"acronym\":\"tianchang\",\"rank\":\"E\",\"firstChar\":\"T\"},{\"id\":352,\"name\":\"铜川\",\"pinyin\":\"tongchuan\",\"acronym\":\"tc\",\"rank\":\"E\",\"firstChar\":\"T\"},{\"id\":1191,\"name\":\"台湾\",\"pinyin\":\"taiwan\",\"acronym\":\"taiwan\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":1256,\"name\":\"屯昌县\",\"pinyin\":\"tunchangxian\",\"acronym\":\"tunchangxian\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":554,\"name\":\"桐庐\",\"pinyin\":\"tonglu\",\"acronym\":\"tonglu\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":1235,\"name\":\"通河县\",\"pinyin\":\"tonghexian\",\"acronym\":\"tonghexian\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":1173,\"name\":\"塔城市\",\"pinyin\":\"tachengshi\",\"acronym\":\"tachengshi\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":666,\"name\":\"洮南\",\"pinyin\":\"taonan\",\"acronym\":\"tn\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":673,\"name\":\"桐城\",\"pinyin\":\"tongcheng\",\"acronym\":\"tongcheng\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":1154,\"name\":\"同心县\",\"pinyin\":\"tongxinxian\",\"acronym\":\"tongxinxian\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":1215,\"name\":\"通江县\",\"pinyin\":\"tongjiangxian\",\"acronym\":\"tongjiangxian\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":1136,\"name\":\"唐河\",\"pinyin\":\"tanghe\",\"acronym\":\"tanghe\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":1135,\"name\":\"通榆县\",\"pinyin\":\"tongyuxian\",\"acronym\":\"tongyuxian\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":743,\"name\":\"台前\",\"pinyin\":\"taiqian\",\"acronym\":\"taiqian\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":759,\"name\":\"太和\",\"pinyin\":\"taihe\",\"acronym\":\"taihe\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":782,\"name\":\"天台\",\"pinyin\":\"tiantai\",\"acronym\":\"tiantai\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":790,\"name\":\"太谷\",\"pinyin\":\"taigu\",\"acronym\":\"taigu\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":812,\"name\":\"藤县\",\"pinyin\":\"tengxian\",\"acronym\":\"tengxian\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":817,\"name\":\"汤阴\",\"pinyin\":\"tangyin\",\"acronym\":\"tangyin\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":879,\"name\":\"土默特右旗\",\"pinyin\":\"tumoteyouqi\",\"acronym\":\"tmtyq\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":942,\"name\":\"郯城\",\"pinyin\":\"tancheng\",\"acronym\":\"tancheng\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":947,\"name\":\"铜梁\",\"pinyin\":\"tongliang\",\"acronym\":\"tongliang\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":962,\"name\":\"同安\",\"pinyin\":\"tongan\",\"acronym\":\"tongan\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":1009,\"name\":\"桃源\",\"pinyin\":\"taoyuanxian\",\"acronym\":\"taoyuanxian\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":1030,\"name\":\"泰和县\",\"pinyin\":\"taihexian\",\"acronym\":\"taihexian\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":1041,\"name\":\"铜鼓\",\"pinyin\":\"tonggu\",\"acronym\":\"tonggu\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":1044,\"name\":\"田东县\",\"pinyin\":\"tiandongxian\",\"acronym\":\"tiandongxian\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":1054,\"name\":\"太康县\",\"pinyin\":\"taikangxian\",\"acronym\":\"taikangxian\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":1111,\"name\":\"通许县\",\"pinyin\":\"tongxuxian\",\"acronym\":\"tongxuxian\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":1132,\"name\":\"通海县\",\"pinyin\":\"tonghaixian\",\"acronym\":\"tonghaixian\",\"rank\":\"F\",\"firstChar\":\"T\"},{\"id\":714,\"name\":\"桃园\",\"pinyin\":\"taoyuan\",\"acronym\":\"taoyuan\",\"rank\":\"Z\",\"firstChar\":\"T\"},{\"id\":708,\"name\":\"台东\",\"pinyin\":\"taidong\",\"acronym\":\"taidong\",\"rank\":\"Z\",\"firstChar\":\"T\"},{\"id\":705,\"name\":\"台中\",\"pinyin\":\"taizhong\",\"acronym\":\"taizhong\",\"rank\":\"Z\",\"firstChar\":\"T\"},{\"id\":482,\"name\":\"腾冲\",\"pinyin\":\"tengchong\",\"acronym\":\"tengchong\",\"rank\":\"Z\",\"firstChar\":\"T\"},{\"id\":401,\"name\":\"台北\",\"pinyin\":\"taibei\",\"acronym\":\"tb\",\"rank\":\"Z\",\"firstChar\":\"T\"},{\"id\":399,\"name\":\"塔城\",\"pinyin\":\"tacheng\",\"acronym\":\"tac\",\"rank\":\"Z\",\"firstChar\":\"T\"},{\"id\":389,\"name\":\"吐鲁番\",\"pinyin\":\"tulufan\",\"acronym\":\"tlf\",\"rank\":\"Z\",\"firstChar\":\"T\"},{\"id\":706,\"name\":\"台南\",\"pinyin\":\"tainan\",\"acronym\":\"tainan\",\"rank\":\"Z\",\"firstChar\":\"T\"}]],[\"W\",[{\"id\":57,\"name\":\"武汉\",\"pinyin\":\"wuhan\",\"acronym\":\"wh\",\"rank\":\"A\",\"firstChar\":\"W\"},{\"id\":52,\"name\":\"无锡\",\"pinyin\":\"wuxi\",\"acronym\":\"wx\",\"rank\":\"B\",\"firstChar\":\"W\"},{\"id\":112,\"name\":\"温州\",\"pinyin\":\"wenzhou\",\"acronym\":\"wz\",\"rank\":\"B\",\"firstChar\":\"W\"},{\"id\":224,\"name\":\"潍坊\",\"pinyin\":\"weifang\",\"acronym\":\"wf\",\"rank\":\"C\",\"firstChar\":\"W\"},{\"id\":227,\"name\":\"威海\",\"pinyin\":\"weihai\",\"acronym\":\"weihai\",\"rank\":\"C\",\"firstChar\":\"W\"},{\"id\":102,\"name\":\"芜湖\",\"pinyin\":\"wuhu\",\"acronym\":\"wuhu\",\"rank\":\"C\",\"firstChar\":\"W\"},{\"id\":387,\"name\":\"乌鲁木齐\",\"pinyin\":\"wulumuqi\",\"acronym\":\"xj\",\"rank\":\"C\",\"firstChar\":\"W\"},{\"id\":355,\"name\":\"渭南\",\"pinyin\":\"weinan\",\"acronym\":\"wn\",\"rank\":\"D\",\"firstChar\":\"W\"},{\"id\":433,\"name\":\"吴江\",\"pinyin\":\"wujiang\",\"acronym\":\"wj\",\"rank\":\"D\",\"firstChar\":\"W\"},{\"id\":457,\"name\":\"温岭\",\"pinyin\":\"wenling\",\"acronym\":\"wenling\",\"rank\":\"D\",\"firstChar\":\"W\"},{\"id\":141,\"name\":\"乌海\",\"pinyin\":\"wuhai\",\"acronym\":\"wuhai\",\"rank\":\"E\",\"firstChar\":\"W\"},{\"id\":428,\"name\":\"万州\",\"pinyin\":\"wanzhou\",\"acronym\":\"wanzhou\",\"rank\":\"E\",\"firstChar\":\"W\"},{\"id\":291,\"name\":\"梧州\",\"pinyin\":\"wuzhou\",\"acronym\":\"wuzhou\",\"rank\":\"E\",\"firstChar\":\"W\"},{\"id\":449,\"name\":\"武安\",\"pinyin\":\"wuan\",\"acronym\":\"wuan\",\"rank\":\"E\",\"firstChar\":\"W\"},{\"id\":147,\"name\":\"乌兰察布\",\"pinyin\":\"wulanchabu\",\"acronym\":\"wlcb\",\"rank\":\"E\",\"firstChar\":\"W\"},{\"id\":498,\"name\":\"文登\",\"pinyin\":\"wendeng\",\"acronym\":\"wd\",\"rank\":\"E\",\"firstChar\":\"W\"},{\"id\":592,\"name\":\"吴川\",\"pinyin\":\"wuchuan\",\"acronym\":\"wc\",\"rank\":\"E\",\"firstChar\":\"W\"},{\"id\":967,\"name\":\"瓦房店\",\"pinyin\":\"wafangdian\",\"acronym\":\"wafangdian\",\"rank\":\"E\",\"firstChar\":\"W\"},{\"id\":365,\"name\":\"武威\",\"pinyin\":\"wuwei\",\"acronym\":\"wuwei\",\"rank\":\"E\",\"firstChar\":\"W\"},{\"id\":479,\"name\":\"婺源\",\"pinyin\":\"wuyuan\",\"acronym\":\"wy\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":1223,\"name\":\"武冈市\",\"pinyin\":\"wugangshi\",\"acronym\":\"wugangshi\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":384,\"name\":\"吴忠\",\"pinyin\":\"wuzhong\",\"acronym\":\"wuzhong\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":1217,\"name\":\"望奎县\",\"pinyin\":\"wangkuixian\",\"acronym\":\"wangkuixian\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":443,\"name\":\"武夷山\",\"pinyin\":\"wuyishan\",\"acronym\":\"wys\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":607,\"name\":\"文昌\",\"pinyin\":\"wenchang\",\"acronym\":\"wenchang\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":667,\"name\":\"武穴\",\"pinyin\":\"wuxue\",\"acronym\":\"wuxue\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":680,\"name\":\"万宁\",\"pinyin\":\"wanning\",\"acronym\":\"wanning\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":684,\"name\":\"舞钢\",\"pinyin\":\"wugang\",\"acronym\":\"wg\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":1255,\"name\":\"武定\",\"pinyin\":\"wuding\",\"acronym\":\"wuding\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":697,\"name\":\"武陟\",\"pinyin\":\"wuzhi\",\"acronym\":\"wuzhi\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":747,\"name\":\"乌苏\",\"pinyin\":\"wusu\",\"acronym\":\"wusu\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":769,\"name\":\"无为\",\"pinyin\":\"wuweiww\",\"acronym\":\"wuweiww\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":773,\"name\":\"芜湖县\",\"pinyin\":\"wuhuxian\",\"acronym\":\"wuhuxian\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":826,\"name\":\"卫辉\",\"pinyin\":\"weihui\",\"acronym\":\"weihui\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":850,\"name\":\"乌拉特前旗\",\"pinyin\":\"wltqq\",\"acronym\":\"wltqq\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":897,\"name\":\"微山\",\"pinyin\":\"weishan\",\"acronym\":\"weishan\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":898,\"name\":\"汶上\",\"pinyin\":\"wenshang\",\"acronym\":\"wenshang\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":904,\"name\":\"武城\",\"pinyin\":\"wucheng\",\"acronym\":\"wucheng\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":926,\"name\":\"围场\",\"pinyin\":\"weichang\",\"acronym\":\"weichang\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":339,\"name\":\"文山\",\"pinyin\":\"wenshan\",\"acronym\":\"ws\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":973,\"name\":\"武义\",\"pinyin\":\"wuyi\",\"acronym\":\"wuyi\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":995,\"name\":\"武鸣\",\"pinyin\":\"wuming\",\"acronym\":\"wuming\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":1006,\"name\":\"威宁\",\"pinyin\":\"weining\",\"acronym\":\"weining\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":1014,\"name\":\"舞阳\",\"pinyin\":\"wuyang\",\"acronym\":\"wuyang\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":1019,\"name\":\"无极\",\"pinyin\":\"wuji\",\"acronym\":\"wuji\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":1023,\"name\":\"万荣\",\"pinyin\":\"wanrong\",\"acronym\":\"wanrong\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":1025,\"name\":\"万载\",\"pinyin\":\"wanzai\",\"acronym\":\"wanzai\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":1046,\"name\":\"威县\",\"pinyin\":\"weixian\",\"acronym\":\"weixian\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":1049,\"name\":\"武平县\",\"pinyin\":\"wupingxian\",\"acronym\":\"wupingxian\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":1109,\"name\":\"尉氏县\",\"pinyin\":\"weishixian\",\"acronym\":\"weishixian\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":1128,\"name\":\"武隆县\",\"pinyin\":\"wulongxian\",\"acronym\":\"wulongxian\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":1187,\"name\":\"五常市\",\"pinyin\":\"wuchangshi\",\"acronym\":\"wuchangshi\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":1207,\"name\":\"旺苍县\",\"pinyin\":\"wangcangxian\",\"acronym\":\"wangcangxian\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":696,\"name\":\"温县\",\"pinyin\":\"wenxian\",\"acronym\":\"wenxian\",\"rank\":\"F\",\"firstChar\":\"W\"},{\"id\":551,\"name\":\"乌镇\",\"pinyin\":\"wuzhen\",\"acronym\":\"wuzhen\",\"rank\":\"Z\",\"firstChar\":\"W\"},{\"id\":486,\"name\":\"武当山\",\"pinyin\":\"wudangshan\",\"acronym\":\"wds\",\"rank\":\"Z\",\"firstChar\":\"W\"}]],[\"X\",[{\"id\":42,\"name\":\"西安\",\"pinyin\":\"xian\",\"acronym\":\"xa\",\"rank\":\"A\",\"firstChar\":\"X\"},{\"id\":62,\"name\":\"厦门\",\"pinyin\":\"xiamen\",\"acronym\":\"xm\",\"rank\":\"B\",\"firstChar\":\"X\"},{\"id\":119,\"name\":\"徐州\",\"pinyin\":\"xuzhou\",\"acronym\":\"xz\",\"rank\":\"C\",\"firstChar\":\"X\"},{\"id\":253,\"name\":\"襄阳\",\"pinyin\":\"xiangyang\",\"acronym\":\"xf\",\"rank\":\"C\",\"firstChar\":\"X\"},{\"id\":264,\"name\":\"湘潭\",\"pinyin\":\"xiangtan\",\"acronym\":\"xiangtan\",\"rank\":\"D\",\"firstChar\":\"X\"},{\"id\":374,\"name\":\"西宁\",\"pinyin\":\"xining\",\"acronym\":\"xn\",\"rank\":\"D\",\"firstChar\":\"X\"},{\"id\":206,\"name\":\"宣城\",\"pinyin\":\"xuancheng\",\"acronym\":\"xuancheng\",\"rank\":\"D\",\"firstChar\":\"X\"},{\"id\":354,\"name\":\"咸阳\",\"pinyin\":\"xianyang\",\"acronym\":\"xianyang\",\"rank\":\"D\",\"firstChar\":\"X\"},{\"id\":241,\"name\":\"许昌\",\"pinyin\":\"xuchang\",\"acronym\":\"xc\",\"rank\":\"D\",\"firstChar\":\"X\"},{\"id\":246,\"name\":\"信阳\",\"pinyin\":\"xinyang\",\"acronym\":\"xy\",\"rank\":\"D\",\"firstChar\":\"X\"},{\"id\":124,\"name\":\"邢台\",\"pinyin\":\"xingtai\",\"acronym\":\"xt\",\"rank\":\"D\",\"firstChar\":\"X\"},{\"id\":256,\"name\":\"孝感\",\"pinyin\":\"xiaogan\",\"acronym\":\"xiaogan\",\"rank\":\"D\",\"firstChar\":\"X\"},{\"id\":103,\"name\":\"新乡\",\"pinyin\":\"xinxiang\",\"acronym\":\"xx\",\"rank\":\"D\",\"firstChar\":\"X\"},{\"id\":523,\"name\":\"新泰\",\"pinyin\":\"xintai\",\"acronym\":\"xintai\",\"rank\":\"E\",\"firstChar\":\"X\"},{\"id\":259,\"name\":\"咸宁\",\"pinyin\":\"xianning\",\"acronym\":\"xianning\",\"rank\":\"E\",\"firstChar\":\"X\"},{\"id\":215,\"name\":\"新余\",\"pinyin\":\"xinyu\",\"acronym\":\"xinyu\",\"rank\":\"E\",\"firstChar\":\"X\"},{\"id\":148,\"name\":\"兴安盟\",\"pinyin\":\"xinganmeng\",\"acronym\":\"xan\",\"rank\":\"E\",\"firstChar\":\"X\"},{\"id\":412,\"name\":\"仙桃\",\"pinyin\":\"xiantao\",\"acronym\":\"xiantao\",\"rank\":\"E\",\"firstChar\":\"X\"},{\"id\":517,\"name\":\"兴化\",\"pinyin\":\"xinghua\",\"acronym\":\"xh\",\"rank\":\"E\",\"firstChar\":\"X\"},{\"id\":340,\"name\":\"西双版纳\",\"pinyin\":\"xishuangbanna\",\"acronym\":\"bn\",\"rank\":\"E\",\"firstChar\":\"X\"},{\"id\":543,\"name\":\"辛集\",\"pinyin\":\"xinji\",\"acronym\":\"xinji\",\"rank\":\"E\",\"firstChar\":\"X\"},{\"id\":548,\"name\":\"新沂\",\"pinyin\":\"xinyi\",\"acronym\":\"xinyi\",\"rank\":\"E\",\"firstChar\":\"X\"},{\"id\":555,\"name\":\"新郑\",\"pinyin\":\"xinzheng\",\"acronym\":\"xinzheng\",\"rank\":\"E\",\"firstChar\":\"X\"},{\"id\":556,\"name\":\"新密\",\"pinyin\":\"xinmi\",\"acronym\":\"xinmi\",\"rank\":\"E\",\"firstChar\":\"X\"},{\"id\":136,\"name\":\"忻州\",\"pinyin\":\"xinzhou\",\"acronym\":\"xinzhou\",\"rank\":\"E\",\"firstChar\":\"X\"},{\"id\":729,\"name\":\"信宜\",\"pinyin\":\"xinyixy\",\"acronym\":\"xinyixy\",\"rank\":\"E\",\"firstChar\":\"X\"},{\"id\":1277,\"name\":\"谢岗镇\",\"pinyin\":\"xiegangzhen\",\"acronym\":\"xiegangzhen\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":1261,\"name\":\"萧县\",\"pinyin\":\"xiaoxian\",\"acronym\":\"xiaoxian\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":149,\"name\":\"锡林郭勒\",\"pinyin\":\"xilinguolemeng\",\"acronym\":\"xlgl\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":275,\"name\":\"湘西\",\"pinyin\":\"xiangxi\",\"acronym\":\"xiangxi\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":557,\"name\":\"荥阳\",\"pinyin\":\"xingyang\",\"acronym\":\"xingyang\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":1248,\"name\":\"息县\",\"pinyin\":\"xixian\",\"acronym\":\"xixian\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":562,\"name\":\"兴宁\",\"pinyin\":\"xingning\",\"acronym\":\"xingning\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":574,\"name\":\"新民\",\"pinyin\":\"xinmin\",\"acronym\":\"xinmin\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":580,\"name\":\"项城\",\"pinyin\":\"xiangcheng\",\"acronym\":\"xiangcheng\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":604,\"name\":\"孝义\",\"pinyin\":\"xiaoyi\",\"acronym\":\"xiaoyi\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":614,\"name\":\"湘乡\",\"pinyin\":\"xiangxiang\",\"acronym\":\"xiangxiang\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":641,\"name\":\"兴城\",\"pinyin\":\"xingcheng\",\"acronym\":\"xingcheng\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":661,\"name\":\"兴平\",\"pinyin\":\"xingping\",\"acronym\":\"xp\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":692,\"name\":\"象山\",\"pinyin\":\"xiangshan\",\"acronym\":\"xiangshan\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":695,\"name\":\"修武\",\"pinyin\":\"xiuwu\",\"acronym\":\"xw\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":1244,\"name\":\"孝昌县\",\"pinyin\":\"xiaochangxian\",\"acronym\":\"xiaochangxian\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":1213,\"name\":\"旬阳县\",\"pinyin\":\"xunyangxian\",\"acronym\":\"xunyangxian\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":525,\"name\":\"湘阴\",\"pinyin\":\"xiangyin\",\"acronym\":\"xiangyin\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":534,\"name\":\"响水\",\"pinyin\":\"xiangshui\",\"acronym\":\"xiangshui\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":734,\"name\":\"新化\",\"pinyin\":\"xinhua\",\"acronym\":\"xinhua\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":764,\"name\":\"仙居\",\"pinyin\":\"xianju\",\"acronym\":\"xianju\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":776,\"name\":\"襄垣\",\"pinyin\":\"xiangyuan\",\"acronym\":\"xiangyuan\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":802,\"name\":\"宣威\",\"pinyin\":\"xuanwei\",\"acronym\":\"xuanwei\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":810,\"name\":\"霞浦\",\"pinyin\":\"xiapu\",\"acronym\":\"xiapu\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":818,\"name\":\"新安\",\"pinyin\":\"xinan\",\"acronym\":\"xinan\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":828,\"name\":\"新乡县\",\"pinyin\":\"xinxiangxian\",\"acronym\":\"xinxiangxian\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":843,\"name\":\"盱眙\",\"pinyin\":\"xuyi\",\"acronym\":\"xuyi\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":853,\"name\":\"徐闻\",\"pinyin\":\"xuwen\",\"acronym\":\"xuwen\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":857,\"name\":\"夏邑\",\"pinyin\":\"xiayi\",\"acronym\":\"xiayi\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":863,\"name\":\"浚县\",\"pinyin\":\"xunxian\",\"acronym\":\"xunxian\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":870,\"name\":\"西乡\",\"pinyin\":\"xixiang\",\"acronym\":\"xixiang\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":885,\"name\":\"西平\",\"pinyin\":\"xiping\",\"acronym\":\"xiping\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":892,\"name\":\"新乐\",\"pinyin\":\"xinle\",\"acronym\":\"xinle\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":903,\"name\":\"新昌\",\"pinyin\":\"xinchang\",\"acronym\":\"xinchang\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":920,\"name\":\"薛城\",\"pinyin\":\"xuecheng\",\"acronym\":\"xuecheng\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":936,\"name\":\"西华\",\"pinyin\":\"xihua\",\"acronym\":\"xihua\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":949,\"name\":\"浠水\",\"pinyin\":\"xishui\",\"acronym\":\"xishui\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":957,\"name\":\"香河\",\"pinyin\":\"xianghe\",\"acronym\":\"xianghe\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":959,\"name\":\"信丰\",\"pinyin\":\"xinfeng\",\"acronym\":\"xinfeng\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":961,\"name\":\"新蔡\",\"pinyin\":\"xincai\",\"acronym\":\"xincai\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":996,\"name\":\"溆浦\",\"pinyin\":\"xupu\",\"acronym\":\"xupu\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":1021,\"name\":\"淅川\",\"pinyin\":\"xichuan\",\"acronym\":\"xichuan\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":1026,\"name\":\"新干\",\"pinyin\":\"xingan\",\"acronym\":\"xingan\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":1033,\"name\":\"兴国县\",\"pinyin\":\"xingguoxian\",\"acronym\":\"xingguoxian\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":1036,\"name\":\"新田\",\"pinyin\":\"xintian\",\"acronym\":\"xintian\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":1050,\"name\":\"寻乌县\",\"pinyin\":\"xunwuxian\",\"acronym\":\"xunwuxian\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":1051,\"name\":\"祥云县\",\"pinyin\":\"xiangyunxian\",\"acronym\":\"xiangyunxian\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":1057,\"name\":\"襄城县\",\"pinyin\":\"xiangchengxian\",\"acronym\":\"xiangchengxian\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":1063,\"name\":\"新宁\",\"pinyin\":\"xinning\",\"acronym\":\"xinning\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":1082,\"name\":\"献县\",\"pinyin\":\"xianxian\",\"acronym\":\"xianxian\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":1123,\"name\":\"新洲区\",\"pinyin\":\"xinzhouqu\",\"acronym\":\"xinzhouqu\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":1129,\"name\":\"秀山土家族苗族自治县\",\"pinyin\":\"xiushantujiazumiaozuzizh\",\"acronym\":\"xiushantujiazumi\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":1137,\"name\":\"新野\",\"pinyin\":\"xinye\",\"acronym\":\"xinye\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":1149,\"name\":\"仙游县\",\"pinyin\":\"xianyouxian\",\"acronym\":\"xianyouxian\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":1167,\"name\":\"新津县\",\"pinyin\":\"xinjinxian\",\"acronym\":\"xinjinxian\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":728,\"name\":\"夏津\",\"pinyin\":\"xiajin\",\"acronym\":\"xiajin\",\"rank\":\"F\",\"firstChar\":\"X\"},{\"id\":717,\"name\":\"新竹市\",\"pinyin\":\"xinzhushi\",\"acronym\":\"xinzhushi\",\"rank\":\"Z\",\"firstChar\":\"X\"},{\"id\":704,\"name\":\"新北\",\"pinyin\":\"xinbei\",\"acronym\":\"xinbei\",\"rank\":\"Z\",\"firstChar\":\"X\"},{\"id\":560,\"name\":\"西塘\",\"pinyin\":\"xitang\",\"acronym\":\"xitang\",\"rank\":\"Z\",\"firstChar\":\"X\"},{\"id\":484,\"name\":\"香格里拉\",\"pinyin\":\"xianggelila\",\"acronym\":\"xgll\",\"rank\":\"Z\",\"firstChar\":\"X\"}]],[\"Y\",[{\"id\":104,\"name\":\"烟台\",\"pinyin\":\"yantai\",\"acronym\":\"yt\",\"rank\":\"C\",\"firstChar\":\"Y\"},{\"id\":120,\"name\":\"扬州\",\"pinyin\":\"yangzhou\",\"acronym\":\"yz\",\"rank\":\"C\",\"firstChar\":\"Y\"},{\"id\":382,\"name\":\"银川\",\"pinyin\":\"yinchuan\",\"acronym\":\"yinchuan\",\"rank\":\"C\",\"firstChar\":\"Y\"},{\"id\":181,\"name\":\"盐城\",\"pinyin\":\"yancheng\",\"acronym\":\"yancheng\",\"rank\":\"C\",\"firstChar\":\"Y\"},{\"id\":267,\"name\":\"岳阳\",\"pinyin\":\"yueyang\",\"acronym\":\"yy\",\"rank\":\"C\",\"firstChar\":\"Y\"},{\"id\":252,\"name\":\"宜昌\",\"pinyin\":\"yichang\",\"acronym\":\"yc\",\"rank\":\"C\",\"firstChar\":\"Y\"},{\"id\":155,\"name\":\"营口\",\"pinyin\":\"yingkou\",\"acronym\":\"yk\",\"rank\":\"D\",\"firstChar\":\"Y\"},{\"id\":219,\"name\":\"宜春\",\"pinyin\":\"yichun\",\"acronym\":\"yichun\",\"rank\":\"D\",\"firstChar\":\"Y\"},{\"id\":285,\"name\":\"阳江\",\"pinyin\":\"yangjiang\",\"acronym\":\"yj\",\"rank\":\"D\",\"firstChar\":\"Y\"},{\"id\":135,\"name\":\"运城\",\"pinyin\":\"yuncheng\",\"acronym\":\"yuncheng\",\"rank\":\"D\",\"firstChar\":\"Y\"},{\"id\":313,\"name\":\"宜宾\",\"pinyin\":\"yibin\",\"acronym\":\"yb\",\"rank\":\"D\",\"firstChar\":\"Y\"},{\"id\":358,\"name\":\"榆林\",\"pinyin\":\"yulinyl\",\"acronym\":\"yl\",\"rank\":\"D\",\"firstChar\":\"Y\"},{\"id\":270,\"name\":\"益阳\",\"pinyin\":\"yiyang\",\"acronym\":\"yiyang\",\"rank\":\"D\",\"firstChar\":\"Y\"},{\"id\":405,\"name\":\"义乌\",\"pinyin\":\"yiwu\",\"acronym\":\"yiwu\",\"rank\":\"D\",\"firstChar\":\"Y\"},{\"id\":454,\"name\":\"宜兴\",\"pinyin\":\"yixing\",\"acronym\":\"yixing\",\"rank\":\"D\",\"firstChar\":\"Y\"},{\"id\":459,\"name\":\"余姚\",\"pinyin\":\"yuyao\",\"acronym\":\"yuyao\",\"rank\":\"D\",\"firstChar\":\"Y\"},{\"id\":470,\"name\":\"乐清\",\"pinyin\":\"yueqing\",\"acronym\":\"yueqing\",\"rank\":\"D\",\"firstChar\":\"Y\"},{\"id\":296,\"name\":\"玉林\",\"pinyin\":\"yulin\",\"acronym\":\"yulin\",\"rank\":\"D\",\"firstChar\":\"Y\"},{\"id\":272,\"name\":\"永州\",\"pinyin\":\"yongzhou\",\"acronym\":\"yongzhou\",\"rank\":\"E\",\"firstChar\":\"Y\"},{\"id\":733,\"name\":\"永川\",\"pinyin\":\"yongchuan\",\"acronym\":\"yongchuan\",\"rank\":\"E\",\"firstChar\":\"Y\"},{\"id\":289,\"name\":\"云浮\",\"pinyin\":\"yunfu\",\"acronym\":\"yf\",\"rank\":\"E\",\"firstChar\":\"Y\"},{\"id\":453,\"name\":\"兖州\",\"pinyin\":\"yanzhou\",\"acronym\":\"yanzhou\",\"rank\":\"E\",\"firstChar\":\"Y\"},{\"id\":216,\"name\":\"鹰潭\",\"pinyin\":\"yingtan\",\"acronym\":\"yingtan\",\"rank\":\"E\",\"firstChar\":\"Y\"},{\"id\":458,\"name\":\"永康\",\"pinyin\":\"yongkang\",\"acronym\":\"yongkang\",\"rank\":\"E\",\"firstChar\":\"Y\"},{\"id\":168,\"name\":\"延边\",\"pinyin\":\"yanbian\",\"acronym\":\"yanbian\",\"rank\":\"E\",\"firstChar\":\"Y\"},{\"id\":130,\"name\":\"阳泉\",\"pinyin\":\"yangquan\",\"acronym\":\"yq\",\"rank\":\"E\",\"firstChar\":\"Y\"},{\"id\":514,\"name\":\"英德\",\"pinyin\":\"yingde\",\"acronym\":\"yd\",\"rank\":\"E\",\"firstChar\":\"Y\"},{\"id\":522,\"name\":\"仪征\",\"pinyin\":\"yizheng\",\"acronym\":\"yizheng\",\"rank\":\"E\",\"firstChar\":\"Y\"},{\"id\":577,\"name\":\"永城\",\"pinyin\":\"yongcheng\",\"acronym\":\"yongcheng\",\"rank\":\"E\",\"firstChar\":\"Y\"},{\"id\":609,\"name\":\"禹州\",\"pinyin\":\"yuzhou\",\"acronym\":\"yuzhou\",\"rank\":\"E\",\"firstChar\":\"Y\"},{\"id\":622,\"name\":\"伊宁\",\"pinyin\":\"yining\",\"acronym\":\"yn\",\"rank\":\"E\",\"firstChar\":\"Y\"},{\"id\":356,\"name\":\"延安\",\"pinyin\":\"yanan\",\"acronym\":\"yanan\",\"rank\":\"E\",\"firstChar\":\"Y\"},{\"id\":331,\"name\":\"玉溪\",\"pinyin\":\"yuxi\",\"acronym\":\"yx\",\"rank\":\"E\",\"firstChar\":\"Y\"},{\"id\":516,\"name\":\"伊川\",\"pinyin\":\"yichuan\",\"acronym\":\"yichuan\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":1218,\"name\":\"宜良县\",\"pinyin\":\"yiliangxian\",\"acronym\":\"yiliangxian\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":528,\"name\":\"偃师\",\"pinyin\":\"yanshi\",\"acronym\":\"yanshi\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":559,\"name\":\"扬中\",\"pinyin\":\"yangzhong\",\"acronym\":\"yangzhong\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":1273,\"name\":\"玉田县\",\"pinyin\":\"yutianxian\",\"acronym\":\"yutianxian\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":597,\"name\":\"永济\",\"pinyin\":\"yongji\",\"acronym\":\"yongji\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":608,\"name\":\"禹城\",\"pinyin\":\"yucheng\",\"acronym\":\"yucheng\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":1199,\"name\":\"盂县\",\"pinyin\":\"yuxian\",\"acronym\":\"yuxian\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":466,\"name\":\"阳朔\",\"pinyin\":\"yangshuo\",\"acronym\":\"yangshuo\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":625,\"name\":\"宜城\",\"pinyin\":\"yicheng\",\"acronym\":\"yicheng\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":637,\"name\":\"原平\",\"pinyin\":\"yuanping\",\"acronym\":\"yp\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":656,\"name\":\"宜都\",\"pinyin\":\"yidu\",\"acronym\":\"yidu\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":1282,\"name\":\"永宁县\",\"pinyin\":\"yongningxian\",\"acronym\":\"yongningxian\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":693,\"name\":\"玉环市\",\"pinyin\":\"yuhuanshi\",\"acronym\":\"yh\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":1198,\"name\":\"永嘉县\",\"pinyin\":\"yongjiaxian\",\"acronym\":\"yongjiaxian\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":316,\"name\":\"雅安\",\"pinyin\":\"yaan\",\"acronym\":\"ya\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":763,\"name\":\"永年\",\"pinyin\":\"yongnian\",\"acronym\":\"yongnian\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":770,\"name\":\"阳城\",\"pinyin\":\"yangcheng\",\"acronym\":\"yangcheng\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":778,\"name\":\"云阳\",\"pinyin\":\"yunyang\",\"acronym\":\"yunyang\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":784,\"name\":\"叶县\",\"pinyin\":\"yexian\",\"acronym\":\"yexian\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":803,\"name\":\"易县\",\"pinyin\":\"yixian\",\"acronym\":\"yixian\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":814,\"name\":\"宜阳\",\"pinyin\":\"yiyangyy\",\"acronym\":\"yiyangyy\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":822,\"name\":\"阎良\",\"pinyin\":\"yanliang\",\"acronym\":\"yanliang\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":829,\"name\":\"原阳\",\"pinyin\":\"yuanyang\",\"acronym\":\"yuanyang\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":859,\"name\":\"虞城\",\"pinyin\":\"yuchengxian\",\"acronym\":\"yuchengxian\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":876,\"name\":\"玉山\",\"pinyin\":\"yushan\",\"acronym\":\"yushan\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":878,\"name\":\"阳谷\",\"pinyin\":\"yanggu\",\"acronym\":\"yanggu\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":884,\"name\":\"郓城\",\"pinyin\":\"yunchengxian\",\"acronym\":\"yunchengxian\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":901,\"name\":\"伊金霍洛旗\",\"pinyin\":\"yijinhuoluoqi\",\"acronym\":\"yjhlq\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":908,\"name\":\"杨陵\",\"pinyin\":\"yangling\",\"acronym\":\"yangling\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":940,\"name\":\"沂水\",\"pinyin\":\"yishui\",\"acronym\":\"yishui\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":943,\"name\":\"沂南\",\"pinyin\":\"yinan\",\"acronym\":\"yinan\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":958,\"name\":\"于都\",\"pinyin\":\"yudu\",\"acronym\":\"yudu\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":1027,\"name\":\"宜丰\",\"pinyin\":\"yifeng\",\"acronym\":\"yifeng\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":1043,\"name\":\"营山县\",\"pinyin\":\"yingshanxian\",\"acronym\":\"yingshanxian\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":1047,\"name\":\"永安\",\"pinyin\":\"yongan\",\"acronym\":\"yongan\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":1058,\"name\":\"鄢陵\",\"pinyin\":\"yanling\",\"acronym\":\"yanling\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":1069,\"name\":\"永丰\",\"pinyin\":\"yongfeng\",\"acronym\":\"yongfeng\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":1072,\"name\":\"永新\",\"pinyin\":\"yongxin\",\"acronym\":\"yongxin\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":1094,\"name\":\"永兴县\",\"pinyin\":\"yongxingxian\",\"acronym\":\"yongxingxian\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":1096,\"name\":\"攸县\",\"pinyin\":\"youxian\",\"acronym\":\"youxian\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":1099,\"name\":\"永顺县\",\"pinyin\":\"yongshunxian\",\"acronym\":\"yongshunxian\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":1117,\"name\":\"裕民县\",\"pinyin\":\"yuminxian\",\"acronym\":\"yuminxian\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":1127,\"name\":\"酉阳土家族苗族自治县\",\"pinyin\":\"youyangtujiazumiaozuzizh\",\"acronym\":\"youyangtujiazumi\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":1151,\"name\":\"应县\",\"pinyin\":\"yingxian\",\"acronym\":\"yingxian\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":1159,\"name\":\"阳山县\",\"pinyin\":\"yangshanxian\",\"acronym\":\"yangshanxian\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":1160,\"name\":\"榆树市\",\"pinyin\":\"yushushi\",\"acronym\":\"yushushi\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":1162,\"name\":\"沅陵县\",\"pinyin\":\"yuanlingxian\",\"acronym\":\"yuanlingxian\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":1169,\"name\":\"永登县\",\"pinyin\":\"yongdengxian\",\"acronym\":\"yongdengxian\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":1181,\"name\":\"鱼台县\",\"pinyin\":\"yutaixian\",\"acronym\":\"yutaixian\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":1182,\"name\":\"宜州区\",\"pinyin\":\"yizhouqu\",\"acronym\":\"yizhoushi\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":1186,\"name\":\"义马市\",\"pinyin\":\"yimashi\",\"acronym\":\"yimashi\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":658,\"name\":\"沅江\",\"pinyin\":\"yuanjiang\",\"acronym\":\"yuanjiang\",\"rank\":\"F\",\"firstChar\":\"Y\"},{\"id\":709,\"name\":\"宜兰\",\"pinyin\":\"yilan\",\"acronym\":\"yilan\",\"rank\":\"Z\",\"firstChar\"F:\"Y\"},{\"id\":398,\"name\":\"伊犁\",\"pinyin\":\"yili\",\"acronym\":\"yili\",\"rank\":\"Z\",\"firstChar\":\"Y\"},{\"id\":380,\"name\":\"玉树\",\"pinyin\":\"yushu\",\"acronym\":\"ys\",\"rank\":\"Z\",\"firstChar\":\"Y\"},{\"id\":172,\"name\":\"伊春\",\"pinyin\":\"yichunyc\",\"acronym\":\"yich\",\"rank\":\"Z\",\"firstChar\":\"Y\"}]],[\"Z\",[{\"id\":73,\"name\":\"郑州\",\"pinyin\":\"zhengzhou\",\"acronym\":\"zz\",\"rank\":\"B\",\"firstChar\":\"Z\"},{\"id\":81,\"name\":\"淄博\",\"pinyin\":\"zibo\",\"acronym\":\"zb\",\"rank\":\"C\",\"firstChar\":\"Z\"},{\"id\":113,\"name\":\"中山\",\"pinyin\":\"zhongshan\",\"acronym\":\"zs\",\"rank\":\"C\",\"firstChar\":\"Z\"},{\"id\":278,\"name\":\"湛江\",\"pinyin\":\"zhanjiang\",\"acronym\":\"zhanjiang\",\"rank\":\"C\",\"firstChar\":\"Z\"},{\"id\":182,\"name\":\"镇江\",\"pinyin\":\"zhenjiang\",\"acronym\":\"zj\",\"rank\":\"C\",\"firstChar\":\"Z\"},{\"id\":263,\"name\":\"株洲\",\"pinyin\":\"zhuzhou\",\"acronym\":\"zhuzhou\",\"rank\":\"C\",\"firstChar\":\"Z\"},{\"id\":108,\"name\":\"珠海\",\"pinyin\":\"zhuhai\",\"acronym\":\"zh\",\"rank\":\"C\",\"firstChar\":\"Z\"},{\"id\":222,\"name\":\"枣庄\",\"pinyin\":\"zaozhuang\",\"acronym\":\"zaozhuang\",\"rank\":\"D\",\"firstChar\":\"Z\"},{\"id\":209,\"name\":\"漳州\",\"pinyin\":\"zhangzhou\",\"acronym\":\"zhangzhou\",\"rank\":\"D\",\"firstChar\":\"Z\"},{\"id\":248,\"name\":\"驻马店\",\"pinyin\":\"zhumadian\",\"acronym\":\"zmd\",\"rank\":\"D\",\"firstChar\":\"Z\"},{\"id\":190,\"name\":\"舟山\",\"pinyin\":\"zhoushan\",\"acronym\":\"zhoushan\",\"rank\":\"D\",\"firstChar\":\"Z\"},{\"id\":125,\"name\":\"张家口\",\"pinyin\":\"zhangjiakou\",\"acronym\":\"zjk\",\"rank\":\"D\",\"firstChar\":\"Z\"},{\"id\":280,\"name\":\"肇庆\",\"pinyin\":\"zhaoqing\",\"acronym\":\"zq\",\"rank\":\"D\",\"firstChar\":\"Z\"},{\"id\":323,\"name\":\"遵义\",\"pinyin\":\"zunyi\",\"acronym\":\"zunyi\",\"rank\":\"D\",\"firstChar\":\"Z\"},{\"id\":419,\"name\":\"张家港\",\"pinyin\":\"zhangjiagang\",\"acronym\":\"zjg\",\"rank\":\"D\",\"firstChar\":\"Z\"},{\"id\":468,\"name\":\"诸暨\",\"pinyin\":\"zhuji\",\"acronym\":\"zhuji\",\"rank\":\"D\",\"firstChar\":\"Z\"},{\"id\":247,\"name\":\"周口\",\"pinyin\":\"zhoukou\",\"acronym\":\"zk\",\"rank\":\"D\",\"firstChar\":\"Z\"},{\"id\":526,\"name\":\"诸城\",\"pinyin\":\"zhucheng\",\"acronym\":\"zhucheng\",\"rank\":\"E\",\"firstChar\":\"Z\"},{\"id\":333,\"name\":\"昭通\",\"pinyin\":\"zhaotong\",\"acronym\":\"zt\",\"rank\":\"E\",\"firstChar\":\"Z\"},{\"id\":366,\"name\":\"张掖\",\"pinyin\":\"zhangye\",\"acronym\":\"zhangye\",\"rank\":\"E\",\"firstChar\":\"Z\"},{\"id\":834,\"name\":\"邹城\",\"pinyin\":\"zoucheng\",\"acronym\":\"zoucheng\",\"rank\":\"E\",\"firstChar\":\"Z\"},{\"id\":269,\"name\":\"张家界\",\"pinyin\":\"zhangjiajie\",\"acronym\":\"zjj\",\"rank\":\"E\",\"firstChar\":\"Z\"},{\"id\":426,\"name\":\"涿州\",\"pinyin\":\"zhuozhou\",\"acronym\":\"zhuozhou\",\"rank\":\"E\",\"firstChar\":\"Z\"},{\"id\":465,\"name\":\"章丘区\",\"pinyin\":\"zhangqiuqu\",\"acronym\":\"zhangqiu\",\"rank\":\"E\",\"firstChar\":\"Z\"},{\"id\":302,\"name\":\"自贡\",\"pinyin\":\"zigong\",\"acronym\":\"zg\",\"rank\":\"E\",\"firstChar\":\"Z\"},{\"id\":494,\"name\":\"枣阳\",\"pinyin\":\"zaoyang\",\"acronym\":\"zaoyang\",\"rank\":\"E\",\"firstChar\":\"Z\"},{\"id\":591,\"name\":\"遵化\",\"pinyin\":\"zunhua\",\"acronym\":\"zunhua\",\"rank\":\"E\",\"firstChar\":\"Z\"},{\"id\":318,\"name\":\"资阳\",\"pinyin\":\"ziyang\",\"acronym\":\"zy\",\"rank\":\"E\",\"firstChar\":\"Z\"},{\"id\":558,\"name\":\"庄河\",\"pinyin\":\"zhuanghe\",\"acronym\":\"zhuanghe\",\"rank\":\"E\",\"firstChar\":\"Z\"},{\"id\":586,\"name\":\"招远\",\"pinyin\":\"zhaoyuan\",\"acronym\":\"zhaoyuan\",\"rank\":\"E\",\"firstChar\":\"Z\"},{\"id\":891,\"name\":\"准格尔旗\",\"pinyin\":\"zhungeerqi\",\"acronym\":\"zhungeerqi\",\"rank\":\"F\",\"firstChar\":\"Z\"},{\"id\":508,\"name\":\"邹平\",\"pinyin\":\"zouping\",\"acronym\":\"zp\",\"rank\":\"F\",\"firstChar\":\"Z\"},{\"id\":1246,\"name\":\"镇雄县\",\"pinyin\":\"zhenxiongxian\",\"acronym\":\"zhenxiongxian\",\"rank\":\"F\",\"firstChar\":\"Z\"},{\"id\":654,\"name\":\"枝江\",\"pinyin\":\"zhijiang\",\"acronym\":\"zhijiang\",\"rank\":\"F\",\"firstChar\":\"Z\"},{\"id\":663,\"name\":\"漳浦\",\"pinyin\":\"zhangpu\",\"acronym\":\"zhangpu\",\"rank\":\"F\",\"firstChar\":\"Z\"},{\"id\":671,\"name\":\"樟树\",\"pinyin\":\"zhangshu\",\"acronym\":\"zhangshu\",\"rank\":\"F\",\"firstChar\":\"Z\"},{\"id\":1200,\"name\":\"中江县\",\"pinyin\":\"zhongjiangxian\",\"acronym\":\"zhongjiangxian\",\"rank\":\"F\",\"firstChar\":\"Z\"},{\"id\":757,\"name\":\"正定\",\"pinyin\":\"zhengding\",\"acronym\":\"zhengding\",\"rank\":\"F\",\"firstChar\":\"Z\"},{\"id\":821,\"name\":\"中牟\",\"pinyin\":\"zhongmou\",\"acronym\":\"zhongmou\",\"rank\":\"F\",\"firstChar\":\"Z\"},{\"id\":386,\"name\":\"中卫\",\"pinyin\":\"zhongwei\",\"acronym\":\"zw\",\"rank\":\"F\",\"firstChar\":\"Z\"},{\"id\":841,\"name\":\"赵县\",\"pinyin\":\"zhaoxian\",\"acronym\":\"zhaoxian\",\"rank\":\"F\",\"firstChar\":\"Z\"},{\"id\":858,\"name\":\"柘城\",\"pinyin\":\"zhecheng\",\"acronym\":\"zhecheng\",\"rank\":\"F\",\"firstChar\":\"Z\"},{\"id\":612,\"name\":\"钟祥\",\"pinyin\":\"zhongxiang\",\"acronym\":\"zx\",\"rank\":\"F\",\"firstChar\":\"Z\"},{\"id\":985,\"name\":\"周至\",\"pinyin\":\"zhouzhi\",\"acronym\":\"zhouzhi\",\"rank\":\"F\",\"firstChar\":\"Z\"},{\"id\":997,\"name\":\"芷江\",\"pinyin\":\"zhijiangtongzu\",\"acronym\":\"zhijiangtongzu\",\"rank\":\"F\",\"firstChar\":\"Z\"},{\"id\":1007,\"name\":\"织金\",\"pinyin\":\"zhijin\",\"acronym\":\"zhijin\",\"rank\":\"F\",\"firstChar\":\"Z\"},{\"id\":1048,\"name\":\"漳平\",\"pinyin\":\"zhangping\",\"acronym\":\"zhangping\",\"rank\":\"F\",\"firstChar\":\"Z\"},{\"id\":1093,\"name\":\"资兴市\",\"pinyin\":\"zixingshi\",\"acronym\":\"zixingshi\",\"rank\":\"F\",\"firstChar\":\"Z\"},{\"id\":1140,\"name\":\"扎兰屯市\",\"pinyin\":\"zhalantunshi\",\"acronym\":\"zhalantunshi\",\"rank\":\"F\",\"firstChar\":\"Z\"},{\"id\":1179,\"name\":\"忠县\",\"pinyin\":\"zhongxian\",\"acronym\":\"zhongxian\",\"rank\":\"F\",\"firstChar\":\"Z\"},{\"id\":1196,\"name\":\"柘荣\",\"pinyin\":\"zherong\",\"acronym\":\"zherong\",\"rank\":\"F\",\"firstChar\":\"Z\"},{\"id\":1259,\"name\":\"中宁县\",\"pinyin\":\"zhongningxian\",\"acronym\":\"zhongningxian\",\"rank\":\"F\",\"firstChar\":\"Z\"},{\"id\":721,\"name\":\"彰化\",\"pinyin\":\"zhanghua\",\"acronym\":\"zhanghua\",\"rank\":\"Z\",\"firstChar\":\"Z\"},{\"id\":615,\"name\":\"周庄\",\"pinyin\":\"zhouzhuang\",\"acronym\":\"zhouzhuang\",\"rank\":\"Z\",\"firstChar\":\"Z\"}]]]");

        String jsonStr = sb.toString();
        JSONArray jsonArray = JSONUtil.parseArray(jsonStr);



//        List<CityData> cityDatas = JSONUtil.toList(jsonArray, CityData.class);
        NewCity newCity2 = new NewCity();
        newCity2.setCity(new ArrayList<NewTitle>());
        for(int i = 0; i < jsonArray.size(); i++) {
            JSONArray jsonSonArray = JSONUtil.parseArray(jsonArray.get(i));
            char c = jsonSonArray.get(0).toString().charAt(0);
            JSONArray cityListJson = JSONUtil.parseArray(jsonSonArray.get(1).toString());
            List<OpenCityItem> openCityItems =  JSONUtil.toList(cityListJson, OpenCityItem.class);
            if(c >= 'A' && c <= 'Z') {
                NewTitle newTitle = new NewTitle();
                newTitle.setLists(new ArrayList<NewData>());
                for(OpenCityItem openCityItem : openCityItems) {
                    List<SysRegion> sysRegions = new ArrayList<SysRegion>();
                    for(int j = 1; j < 4; j++) {
                        sysRegions = sysRegionBiz.selectByExample(
                                Example.builder(SysRegion.class).where(
                                        WeekendSqls.<SysRegion>custom().andLike(SysRegion::getName, "%"+ openCityItem.getName()+ "%").andEqualTo(SysRegion::getType, j)
                                ).build()
                        );
                        if(sysRegions.size() > 0) {
                            break;
                        }
                    }

                    NewData newData;
                    if(sysRegions.size() > 0) {
                        List<SysRegion> finalSysRegions = sysRegions;
                        newData = new NewData(){{
                            setId(finalSysRegions.get(0).getId());
                            setName(openCityItem.getName());
                        }};
                    }else {
                        newData = new NewData(){{
                            setId(-1L);
                            setName(openCityItem.getName());
                        }};
                    }
                    newTitle.getLists().add(newData);
                }
                newCity2.getCity().add(newTitle);
            }
        }
        FileWriter writer = new FileWriter("/Users/zhoujianwei/opt/xxfc/"+ DateUtil.currentSeconds()+ "test.properties");
        writer.write(JSONUtil.toJsonStr(newCity2));
        System.out.println("test");
    }

    @Data
    public class OpenCityItem {
        String acronym;
        String firstChar;
        Integer id;
        String name;
        String pinyin;
        String rank;
    }

}
