package com.xxfc.platform.vehicle.biz;



import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.context.BaseContextHandler;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.constant.VehicleBookRecordStatus;
import com.xxfc.platform.vehicle.entity.*;
import com.xxfc.platform.vehicle.mapper.VehicleRecordEmployMapper;
import com.xxfc.platform.vehicle.pojo.BookVehicleVO;
import com.xxfc.platform.vehicle.pojo.dto.VehicleRecordEmployDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import java.util.List;


@Service
@Slf4j
public class VehicleRecordEmployBiz extends BaseBiz<VehicleRecordEmployMapper, VehicleRecordEmploy> {



    @Autowired
    VehicleBiz vehicleBiz;

    @Autowired
    BranchCompanyBiz branchCompanyBiz;



     public  void  addOrUpd(VehicleRecordEmployDTO recordEmployDTO) throws Exception{
         String vehicleId = recordEmployDTO.getVehicleId();
         if (StringUtils.isBlank(vehicleId) ){
             throw  new BaseException("参数不能为空", ResultCode.FAILED_CODE);
         }
         Integer status = recordEmployDTO.getStatus() == null ? 1 : recordEmployDTO.getStatus();
         VehicleRecordEmploy vehicleRecordEmploy = new VehicleRecordEmployDTO();
         BeanUtils.copyProperties(recordEmployDTO,vehicleRecordEmploy);
         VehicleRecordEmploy vehicleRecordEmploy1 = getInfo(vehicleId);
         if (vehicleRecordEmploy1 != null){
             Long bookRecordId = vehicleRecordEmploy1.getBookRecordId() == null ? 0L : vehicleRecordEmploy1.getBookRecordId();
             if (bookRecordId > 0L){
                 if (vehicleRecordEmploy1.getStatus() == 1)
                     canelRecord(bookRecordId);
                 if (status == 1){
                     bookRecordId = addRecord(recordEmployDTO);
                 }
             }
             vehicleRecordEmploy.setStatus(status);
             vehicleRecordEmploy.setBookRecordId(bookRecordId);
             vehicleRecordEmploy.setId(vehicleRecordEmploy1.getId());
             updateSelectiveById(vehicleRecordEmploy);
         }else {
             Long bookRecordId = addRecord(recordEmployDTO);
             vehicleRecordEmploy.setBookRecordId(bookRecordId);
             insertSelective(vehicleRecordEmploy);
         }
     }


     //车辆预定
     public  Long addRecord(VehicleRecordEmployDTO recordEmployDTO) throws  Exception{
         Integer companyId = recordEmployDTO.getCompanyId() == null ? 0 :recordEmployDTO.getCompanyId();
         BranchCompany branchCompany = branchCompanyBiz.selectById(companyId);
         if (branchCompany == null)
             throw  new BaseException("公司不能为空", ResultCode.FAILED_CODE);
         BookVehicleVO bookVehicleVo = new BookVehicleVO();
         BeanUtils.copyProperties(recordEmployDTO,bookVehicleVo);
         Integer operatorId = Integer.parseInt(BaseContextHandler.getUserID());
         String userName = BaseContextHandler.getName();
         bookVehicleVo.setBookType(4);
         bookVehicleVo.setStatus(VehicleBookRecordStatus.APPROVE.getCode());
         bookVehicleVo.setNotCheckTimeLegal(Boolean.FALSE);
         bookVehicleVo.setVehicleUsername(branchCompany.getLeader());
         bookVehicleVo.setVehicleUserPhone(branchCompany.getLeaderContactInfo());
         bookVehicleVo.setRetCompany(companyId);
         VehicleBookRecord vehicleBookRecord = vehicleBiz.applyVehicle(operatorId, bookVehicleVo, userName);
         if (vehicleBookRecord == null )
             throw  new BaseException("公司不能为空", ResultCode.FAILED_CODE);
         return  vehicleBookRecord.getId();
     }

    //取消预定
    public void canelRecord(Long bookRecordI) throws  Exception{
        Integer operatorId = Integer.parseInt(BaseContextHandler.getUserID());
        String userName = BaseContextHandler.getName();
        RestResponse restResponse = vehicleBiz.unbookVehicle4Employee(operatorId, bookRecordI, userName, null, Boolean.FALSE);
        if (!restResponse.getCode().equals(RestResponse.suc().getCode()))
            throw  new BaseException("取消失败", ResultCode.FAILED_CODE);

    }


    public  VehicleRecordEmploy getInfo(String vehicleId){
        Example example = new Example(VehicleRecordEmploy.class);
        example.createCriteria().andEqualTo("vehicleId",vehicleId).andEqualTo("isDel" , 0);
        List<VehicleRecordEmploy> list = selectByExample(example);
        if (list.size() > 0)
            return  list.get(0);
        return  null;
    }











}
