package com.xxfc.platform.vehicle.biz;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xxfc.platform.vehicle.entity.VehicleCategory;
import com.xxfc.platform.vehicle.mapper.VehicleCategoryMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

/**
 * 
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2020-09-19 17:48:20
 */
@Service
public class VehicleCategoryBiz extends BaseBiz<VehicleCategoryMapper, VehicleCategory> {


    @Autowired
    VehicleBrandBiz vehicleBrandBiz;

    public  VehicleCategory addCategory(VehicleCategory vehicleCategory){
        Example example = new Example(VehicleCategory.class);
        example.createCriteria().andEqualTo("name",vehicleCategory.getName()).andEqualTo("isDel",0);
        List<VehicleCategory> list = selectByExample(example);
        if (list.size() == 0){
            Integer brandId = vehicleBrandBiz.addBrand(vehicleCategory);
            vehicleCategory.setBrandId(brandId);
            insertSelective(vehicleCategory);
        }else {
            vehicleCategory = list.get(0);
        }

        return  vehicleCategory;
    }
}