package com.xxfc.platform.vehicle.pojo.dto;

import com.xxfc.platform.vehicle.entity.VehicleRecordEmploy;
import io.swagger.annotations.ApiModelProperty;
import java.text.SimpleDateFormat;
import java.util.Date;

public class VehicleRecordEmployDTO extends VehicleRecordEmploy {

    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");


    @ApiModelProperty("预定目标日期(开始) yyyy-MM-dd HH:mm:ss")
    private String bookStartDate;

    /**
     * 预定目标日期(结束)
     */
    @ApiModelProperty("预定目标日期(结束) yyyy-MM-dd HH:mm:ss")
    private String bookEndDate;


    public String getBookStartDate(){
        String bookStartDate = null;
        if (this.getStartTime() != null && this.getStartTime() > 0){
            try {
                bookStartDate = dateFormat.format(new Date(this.getStartTime()));
            }catch (Exception e){
            }
        }
        return  bookStartDate;
    }


    public String getBookEndDate(){
        String bookEndDate = null;
        if (this.getEndTime() != null && this.getEndTime() > 0){
            try {
                bookEndDate = dateFormat.format(new Date(this.getEndTime()));
            }catch (Exception e){
            }
        }
        return  bookEndDate;
    }
}
